/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;

class Treemap
extends D3Diagram {
    public Treemap(ElementStructure structure, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(structure, data, interaction, out);
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Define treemap (hierarchy) data structures");
        this.makeHierarchicalTree(false);
        this.out.add("var treemap = d3.treemap().tile(d3.treemapResquarify)").addChained("size([geom.inner_width, geom.inner_height])").addChained("padding(function(d) { return d.depth < 3 ? 2*d.depth : 0} )").addChained("paddingTop(function(d) { return d.depth ==1 ? 15 : (d.depth == 2) ? 12 : 0})").endStatement();
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.rect, "polygon", "treemap(tree).descendants()");
    }

    @Override
    public void writeDiagramEnter() {
        this.out.add("added.filter(function(d) { return d.parent })").addChained("attr('x', function(d) { return scale_x((d.parent.x0+d.parent.x1)/2) })").addChained("attr('y', function(d) { return scale_y((d.parent.y0+d.parent.y1)/2) })").addChained("attr('width', 0).attr('height', 0)").endStatement();
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.writeHierarchicalClass();
        this.out.addChained("attr('x', function(d) { return scale_x(d.x0) })").addChained("attr('y', function(d) { return scale_y(d.y0) })").addChained("attr('width', function(d) { return scale_x(d.x1) - scale_x(d.x0) })").addChained("attr('height', function(d) { return scale_y(d.y1) - scale_y(d.y0) })");
        this.addAestheticsAndTooltips(details);
        this.labelBuilder.addTreeInternalLabelsInsideNode();
    }

    @Override
    public boolean needsDiagramLabels() {
        return true;
    }
}

