/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.D3ElementBuilder;
import org.brunel.build.d3.element.EdgeBuilder;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.d3.element.GeomAttribute;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.model.VisTypes;
import org.brunel.model.style.StyleTarget;

class Tree
extends D3Diagram {
    private final Method method;
    private final int labelSize;
    private final int pad;
    private final boolean usesSize;

    public Tree(ElementStructure structure, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(structure, data, interaction, out);
        this.method = this.vis.coords == VisTypes.Coordinates.polar ? Method.polar : Method.leftRight;
        this.labelSize = this.labelBuilder.estimateLabelLength() * 6;
        this.usesSize = !this.vis.fSize.isEmpty();
        StyleTarget target = StyleTarget.makeElementTarget("point", "element");
        ModelUtil.Size size = ModelUtil.getSize(this.vis, target, "size");
        this.pad = size == null ? 10 : (int)size.value(10.0) / 2 + 3;
    }

    @Override
    public void writePerChartDefinitions() {
        super.writePerChartDefinitions();
        this.out.add("var graph;").at(50).comment("The tree with links");
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Define tree (hierarchy) data structures");
        this.makeHierarchicalTree(true);
        this.out.add("var treeLayout = d3.tree()");
        if (this.method == Method.polar) {
            this.out.addChained("size([2*Math.PI, geom.inner_radius-" + (this.pad + this.labelSize) + "])").addChained("separation(function(a,b) { return (a.parent == b.parent ? 1 : 2) / a.depth })");
        } else {
            this.out.addChained("size([geom.inner_height-" + 2 * this.pad + ", geom.inner_width-" + (2 * this.pad + this.labelSize) + "])");
        }
        this.out.endStatement();
        this.out.add("var treeNodes = treeLayout(tree).descendants()").endStatement();
        this.out.add("BrunelD3.copyTreeLayoutInfo(treeNodes, graph, " + (this.method == Method.polar ? "0" : Integer.valueOf(this.pad)) + ")").endStatement();
        if (this.usesSize && this.vis.positionFields().length != 0) {
            this.out.add("size = function(d) { return scale_size(d.value) }").endStatement();
        }
        ElementRepresentation rep = ModelUtil.getElementSymbol(this.vis) != null ? ElementRepresentation.symbol : (this.method == Method.leftRight ? ElementRepresentation.pointLikeCircle : ElementRepresentation.largeCircle);
        return ElementDetails.makeForDiagram(this.vis, rep, "point", "treeNodes");
    }

    @Override
    public void writeDiagramEnter() {
        this.out.add("added.filter(function(d) { return d.parent })");
        this.writeNodePlacement(this.structure.details, "d.parent");
        this.out.endStatement();
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.writeHierarchicalClass();
        this.writeNodePlacement(details, "d");
        this.out.addChained("attr('r', " + details.overallSize.halved() + ")");
        this.addAestheticsAndTooltips(details);
        if (this.structure.findDependentEdges() == null) {
            this.out.onNewLine().ln().comment("Add in the arcs on the outside for the groups");
            this.out.add("diagramExtras.attr('class', 'diagram tree edge')").endStatement();
            this.out.add("function edgeKey(d) { return nodeKey(d.source) + '%' + nodeKey(d.target) }").endStatement();
            this.out.add("var edgeGroup = diagramExtras.selectAll('path').data(tree.links(), edgeKey)").endStatement();
            new EdgeBuilder(this.out, this.method == Method.polar).write("edgeGroup");
            D3ElementBuilder.writeRemovalOnExit(this.out, "edgeGroup");
            this.labelBuilder.addTreeInternalLabelsOutsideNode(this.method == Method.leftRight || !this.usesSize ? "bottom" : "center");
        }
    }

    private void writeNodePlacement(ElementDetails details, String d) {
        String cy;
        String cx;
        if (this.method == Method.leftRight) {
            cx = "scale_x(" + d + ".y)";
            cy = "scale_y(" + d + ".x)";
        } else if (this.method == Method.topBottom) {
            cx = "scale_x(" + d + ".x)";
            cy = "scale_y(" + d + ".y)";
        } else {
            cx = "scale_x(" + d + ".y * Math.cos(" + d + ".x))";
            cy = "scale_y(" + d + ".y * Math.sin(" + d + ".x))";
        }
        String symbolName = ModelUtil.getElementSymbol(this.vis);
        if (symbolName != null) {
            this.out.addChained("attr('transform', function(d) { return 'translate(' + " + cx + " + ', ' + " + cy + " + ')' })");
            symbolName = Data.quote((String)symbolName);
            if (details == null) {
                this.out.addChained("attr('d', BrunelD3.symbol(" + symbolName + ", 10))");
            } else {
                GeomAttribute size = details.overallSize.halved();
                if (size.isFunc()) {
                    this.out.addChained("attr('d', function(d) { return BrunelD3.symbol(" + symbolName + ", " + size.definition() + ") })");
                } else {
                    this.out.addChained("attr('d', BrunelD3.symbol(" + symbolName + ", " + size + "))");
                }
            }
        } else {
            this.out.addChained("attr('cx', function(d) { return " + cx + " })").addChained("attr('cy', function(d) { return " + cy + " })");
        }
    }

    @Override
    public boolean needsDiagramExtras() {
        return true;
    }

    @Override
    public boolean needsDiagramLabels() {
        return true;
    }

    private static enum Method {
        leftRight,
        topBottom,
        polar;

    }
}

