/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.action.Param;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.Bubble;
import org.brunel.build.d3.element.D3ElementBuilder;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.d3.element.GeomAttribute;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;

class Grid
extends Bubble {
    private int rows = 0;
    private int columns = 0;
    private double aspect = 1.0;

    Grid(ElementStructure structure, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(structure, data, interaction, out);
        for (Param p : this.vis.tDiagramParameters) {
            String s = p.asString();
            if (s.equals("aspect") && p.hasModifiers()) {
                this.aspect = p.firstModifier().asDouble();
            } else if (s.equals("rows") && p.hasModifiers()) {
                this.rows = (int)p.firstModifier().asDouble();
            }
            if (!s.equals("columns") || !p.hasModifiers()) continue;
            this.columns = (int)p.firstModifier().asDouble();
        }
    }

    @Override
    public void writeDiagramEnter() {
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Define hierarchy and grid data structures");
        this.makeHierarchicalTree(false);
        this.out.add("var gridLabels = BrunelD3.gridLayout(tree, [geom.inner_width, geom.inner_height], " + this.rows + ", " + this.columns + ", " + this.aspect + ")").endStatement();
        ElementRepresentation representation = ModelUtil.getElementSymbol(this.vis) == null ? ElementRepresentation.spaceFillingCircle : ElementRepresentation.symbol;
        return ElementDetails.makeForDiagram(this.vis, representation, "point", "tree.leaves()");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        details.x.center = GeomAttribute.makeFunction("scale_x(d.x)");
        details.y.center = GeomAttribute.makeFunction("scale_y(d.y)");
        String replacement = details.overallSize.definition().replace("geom.default_point_size", "(scale_x(d.r) - scale_x(0))");
        details.overallSize = GeomAttribute.makeFunction(replacement);
        this.out.addChained("attr('class', function(d) { return (d.children ? 'element L' + d.depth : 'leaf element " + this.element.name() + "') })");
        D3ElementBuilder.definePointLikeMark(details, this.vis, this.out);
        this.addAestheticsAndTooltips(details);
        this.labelBuilder.addGridLabels();
    }

    @Override
    public boolean needsDiagramExtras() {
        return true;
    }
}

