/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import java.util.ArrayList;
import org.brunel.action.Param;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.d3.diagrams.Bubble;
import org.brunel.build.d3.diagrams.Chord;
import org.brunel.build.d3.diagrams.Cloud;
import org.brunel.build.d3.diagrams.DependentEdge;
import org.brunel.build.d3.diagrams.GeoMap;
import org.brunel.build.d3.diagrams.GeoMapLabels;
import org.brunel.build.d3.diagrams.Grid;
import org.brunel.build.d3.diagrams.Network;
import org.brunel.build.d3.diagrams.ParallelCoordinates;
import org.brunel.build.d3.diagrams.Table;
import org.brunel.build.d3.diagrams.Tree;
import org.brunel.build.d3.diagrams.Treemap;
import org.brunel.build.d3.element.D3ElementBuilder;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public abstract class D3Diagram {
    final ScriptWriter out;
    final Param size;
    final VisTypes.Element element;
    final VisSingle vis;
    final D3LabelBuilder labelBuilder;
    final D3Interaction interaction;
    final String[] position;
    final ElementStructure structure;
    private boolean isHierarchy;

    public static D3Diagram make(ElementStructure structure, D3Interaction interaction, ScriptWriter out) {
        VisSingle vis = structure.vis;
        Dataset data = structure.data;
        if (vis.tDiagram == null) {
            if (structure.chart.diagram != null && structure.isDependentEdge()) {
                return new DependentEdge(structure, data, interaction, out);
            }
            return null;
        }
        if (vis.tDiagram == VisTypes.Diagram.bubble) {
            return new Bubble(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.chord) {
            return new Chord(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.cloud) {
            return new Cloud(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.tree) {
            return new Tree(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.parallel) {
            return new ParallelCoordinates(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.gridded) {
            return new Grid(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.table) {
            return new Table(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.treemap) {
            return new Treemap(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.network) {
            return new Network(structure, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.map) {
            if (vis.tDiagramParameters.length == 1 && vis.tDiagramParameters[0].asString().equals("labels")) {
                return new GeoMapLabels(structure, data, interaction, out);
            }
            return new GeoMap(structure, data, structure.geo, interaction, out);
        }
        throw new IllegalStateException("Unknown diagram: " + (Object)((Object)vis.tDiagram));
    }

    D3Diagram(ElementStructure structure, Dataset data, D3Interaction interaction, ScriptWriter out) {
        this.structure = structure;
        this.vis = structure.vis;
        this.out = out;
        this.size = this.vis.fSize.isEmpty() ? null : this.vis.fSize.get(0);
        this.position = this.vis.positionFields();
        this.element = this.vis.tElement;
        this.interaction = interaction;
        this.labelBuilder = new D3LabelBuilder(this.vis, out, data);
    }

    public String getRowKeyFunction() {
        return this.vis.tDiagram.isHierarchical ? "nodeKey" : "function(d) { return d.key }";
    }

    public String getStyleClasses() {
        String classes = "diagram " + this.vis.tDiagram.name();
        return "'" + (this.isHierarchy ? classes + " hierarchy" : classes) + "'";
    }

    public boolean needsDiagramExtras() {
        return false;
    }

    public boolean needsDiagramLabels() {
        return false;
    }

    public void preBuildDefinitions() {
    }

    public void writeBuildCommands() {
    }

    public abstract ElementDetails initializeDiagram();

    public abstract void writeDefinition(ElementDetails var1);

    public void writeDiagramEnter() {
    }

    public void writePerChartDefinitions() {
        if (this.vis.tDiagram != null && this.vis.tDiagram.isHierarchical) {
            this.out.add("var tree, expandState = [], collapseState = {};").at(50).comment("collapse state maps node IDs to true/false");
        }
    }

    public void writePreDefinition(ElementDetails details) {
    }

    void addAestheticsAndTooltips(ElementDetails details) {
        D3ElementBuilder.writeAesthetics(details, true, this.vis, this.out, this.labelBuilder);
    }

    void makeHierarchicalTree(boolean definedHierarchy) {
        boolean reduceSizes;
        String sizeParam;
        Integer prune = this.findPruneParameter(this.vis.tDiagramParameters);
        String pruneValue = prune == null ? null : (prune < 1 ? (this.vis.coords == VisTypes.Coordinates.polar ? "geom.inner_width * geom.inner_height / 1000" : (this.vis.coords == VisTypes.Coordinates.transposed ? "geom.inner_width / 10" : "geom.inner_height / 10")) : prune.toString());
        String[] positionFields = this.vis.positionFields();
        String string = sizeParam = this.size == null ? null : Data.quote((String)this.size.asField());
        if (positionFields.length != 0 || this.vis.fKeys.isEmpty()) {
            String fieldsList = positionFields.length == 0 ? "" : ", " + this.quoted(positionFields);
            this.defineOrDeclareHierarchy(definedHierarchy);
            this.out.add("graph = BrunelData.diagram_Hierarchical.makeByNestingFields(processed, " + sizeParam + fieldsList + ")").endStatement();
        } else {
            ElementStructure edges = this.structure.findDependentEdges();
            if (this.vis.fKeys.isEmpty()) {
                throw new IllegalStateException("Tree needs keys for ids");
            }
            if (edges == null) {
                throw new IllegalStateException("Tree needs edges defined by another element if no positions defined");
            }
            String nodeIDField = Data.quote((String)this.vis.fKeys.get(0).asField());
            String edge1Field = Data.quote((String)edges.vis.fKeys.get(0).asField());
            String edge2Field = Data.quote((String)edges.vis.fKeys.get(1).asField());
            this.defineOrDeclareHierarchy(definedHierarchy);
            this.out.add("graph = BrunelData.diagram_Hierarchical.makeByEdges(processed, " + nodeIDField + ", " + sizeParam + ", elements[" + edges.index + "].data(), " + edge1Field + ", " + edge2Field + ")").endStatement();
        }
        if (this.interaction.needsHierarchySearch()) {
            this.out.add("var targetNode = expandState.length ? graph.find(expandState[expandState.length-1]) : graph.root").endStatement();
        } else {
            this.out.add("var targetNode = graph.root").endStatement();
        }
        this.out.add("tree = d3.hierarchy(targetNode).sum(function(d) { return d.value })").endStatement();
        boolean bl = reduceSizes = this.vis.tDiagram == VisTypes.Diagram.bubble || this.vis.tDiagram == VisTypes.Diagram.treemap;
        if (this.interaction.needsHierarchyPrune()) {
            if (pruneValue == null) {
                this.out.add("BrunelD3.prune(tree, collapseState, " + reduceSizes + ")").endStatement();
            } else {
                this.out.add("BrunelD3.prune(tree, collapseState, " + reduceSizes + ", first ? " + pruneValue + ": null)").endStatement();
            }
        }
        this.out.add("function nodeKey(d) { return d.data.key == null ? data._key(d.data.row) : d.data.key }").endStatement();
        this.isHierarchy = true;
    }

    private void defineOrDeclareHierarchy(boolean definedHierarchy) {
        this.out.add("var first = (!tree)");
        if (definedHierarchy) {
            this.out.endStatement();
        } else {
            this.out.add(", ");
        }
    }

    private Integer findPruneParameter(Param[] params) {
        for (Param p : params) {
            if (!p.asString().equals("prune")) continue;
            if (p.hasModifiers()) {
                return p.firstModifier().asInteger();
            }
            return -1;
        }
        return null;
    }

    protected String quoted(String ... items) {
        ArrayList<String> p = new ArrayList<String>();
        for (String s : items) {
            p.add(Data.quote((String)s));
        }
        return Data.join(p);
    }

    protected void writeHierarchicalClass() {
        this.out.addChained("attr('class', function(d) { return (d.collapsed ? 'collapsed ' : '') + (d.data.children ? 'element L' + d.depth : 'leaf element " + this.element.name() + "') })");
    }
}

