/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.brunel.action.Param;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.d3.element.D3ElementBuilder;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;

public class GuideBuilder
extends D3ElementBuilder {
    private static final Set<String> MATH_FUNCTIONS = new HashSet<String>(Arrays.asList("e pi abs acos asin atan atan2 ceil cos exp floor log max min pow random round sin sqrt tan".split(" ")));
    private static final Set<Character> SYMBOLS = new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf(':')));

    public GuideBuilder(ElementStructure structure, ScriptWriter out, D3ScaleBuilder scalesBuilder, D3Interaction interaction) {
        super(structure, out, scalesBuilder, interaction);
    }

    @Override
    public void generate(int elementIndex) {
        List<Param> guides = this.vis.tGuides;
        int steps = this.getSteps(guides);
        this.out.add("var i, x, y, t, selection, path, data = [], ").onNewLine().add("xDomain = scale_x.domain(), x0 = xDomain[0], xs = xDomain[xDomain.length-1]-x0, ").onNewLine().add("yDomain = scale_y.domain(), y0 = yDomain[0], ys = xDomain[yDomain.length-1]-y0").endStatement();
        this.out.add("var guideData = Array.apply(null, Array(" + steps + ")).map(function (v, i) {").indentMore().onNewLine().add("t = i /", steps - 1, ";", "return {x:x0 + xs*t, y:y0 + ys*t, t:t} })").endStatement();
        int index = 0;
        ElementDetails details = this.makeDetails();
        this.setGeometry(details);
        for (Param p : guides) {
            this.out.onNewLine().ln().comment("Defining guide #" + ++index).onNewLine();
            String defX = this.definition(p, "x");
            String defY = this.definition(p, "y");
            this.out.add("path = d3.line().curve(d3.curveCatmullRom)").addChained("x(function(d) { return scale_x(", defX, ") })").addChained("y(function(d) { return scale_y(", defY, ") })").endStatement();
            this.defineLabeling(details);
            this.out.add("selection = main.selectAll('.element.guide" + index + "').data(guideData)").endStatement();
            this.out.add("var added = selection.enter().append('path').attr('class', 'element line guide guide" + index + "')");
            if (this.structure.chart.accessible) {
                this.out.addChained("attr('role', 'img').attr('aria-label', 'reference guide')");
            }
            this.out.endStatement();
            this.out.add("BrunelD3.transition(selection.merge(added), transitionMillis)").addChained("attr('d', path(guideData))").endStatement();
            this.writeCoordinateLabelingAndAesthetics(details, false);
        }
    }

    private int getSteps(List<Param> guides) {
        int max = 0;
        for (Param p : guides) {
            if (p.modifiers().length <= 1) continue;
            try {
                max = Math.max((int)p.modifiers()[1].asDouble(), max);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("When setting number of steps in a guide, the value must be an integer");
            }
        }
        return max <= 1 ? 40 : max;
    }

    private String definition(Param p, String coord) {
        if (p.asString().equals(coord)) {
            return this.sanitize(p.firstModifier().asString());
        }
        return "d." + coord;
    }

    private String sanitize(String text) {
        try {
            int tok;
            StreamTokenizer in = new StreamTokenizer(new StringReader(text));
            for (Character c : SYMBOLS) {
                in.ordinaryChar(c.charValue());
            }
            StringBuilder out = new StringBuilder();
            while ((tok = in.nextToken()) != -1 && tok != 10) {
                if (tok == -2) {
                    out.append(in.nval);
                    continue;
                }
                if (tok == -3) {
                    String s = in.sval.toLowerCase();
                    if (s.equals("x") || s.equals("y") || s.equals("t")) {
                        out.append("d.").append(s);
                        continue;
                    }
                    if (MATH_FUNCTIONS.contains(s)) {
                        out.append("Math.").append(s);
                        continue;
                    }
                    throw new IllegalStateException("Cannot use term '" + s + "' in a function definition");
                }
                char c = (char)tok;
                if (SYMBOLS.contains(Character.valueOf(c))) {
                    out.append(c);
                    continue;
                }
                throw new IllegalStateException("Cannot use symbol '" + c + "' in a function definition");
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

