/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.controls;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.data.Dataset;
import org.brunel.data.Field;

public class FilterControl {
    public final int datasetIndex;
    public final String id;
    public final String label;
    public final Object[] categories;
    public final Double min;
    public final Double max;
    public final Double lowValue;
    public final Double highValue;
    public final Object[] selectedCategories;
    public final Double animateSpeed;
    public final Double animateFrames;
    public final boolean animate;

    public static FilterControl makeForFilterField(Dataset data, int datasetIndex, String fieldID, Param modifier) {
        Field field = data.field(fieldID);
        if (field.preferCategorical()) {
            Object[] selectedCategories = null;
            if (modifier != null) {
                if (modifier.type() == Param.Type.option) {
                    selectedCategories = new String[]{modifier.asString()};
                } else if (modifier.type() == Param.Type.list) {
                    List<Param> params = modifier.asList();
                    selectedCategories = new String[params.size()];
                    for (int i = 0; i < selectedCategories.length; ++i) {
                        selectedCategories[i] = params.get(i).asString();
                    }
                }
            }
            return new FilterControl(datasetIndex, fieldID, field.label, field.categories(), null, null, null, null, selectedCategories, false, null, null);
        }
        Double low = null;
        Double high = null;
        if (modifier != null) {
            List<Param> params;
            if (modifier.type() == Param.Type.number) {
                low = modifier.asDouble();
            } else if (modifier.type() == Param.Type.list && (params = modifier.asList()).size() == 2) {
                low = params.get(0).asDouble();
                high = params.get(1).asDouble();
            }
        }
        return new FilterControl(datasetIndex, fieldID, field.label, null, field.min(), field.max(), low, high, null, false, null, null);
    }

    public static FilterControl makeForAnimation(Dataset data, int datasetIndex, List<Param> p) {
        String fieldId = null;
        Field field = null;
        Double animateFrames = null;
        Double animateSpeed = null;
        for (Param param : p) {
            if (param.isField()) {
                fieldId = param.asField(data);
                field = data.field(fieldId);
                if (field.preferCategorical()) {
                    return null;
                }
                Param frames = param.firstModifier();
                if (frames != null) {
                    animateFrames = frames.asDouble();
                }
            }
            if (param.type() != Param.Type.option || !param.asString().equals("speed")) continue;
            animateSpeed = param.firstModifier().asDouble();
        }
        if (fieldId == null) {
            return null;
        }
        return new FilterControl(datasetIndex, fieldId, field.label, null, field.min(), field.max(), null, null, null, true, animateSpeed, animateFrames);
    }

    public static JsonObject buildFilterDefaults(List<FilterControl> filterControls) {
        JsonObject jobj = new JsonObject();
        for (FilterControl f : filterControls) {
            JsonObject aFilter;
            if (f.categories != null) {
                Object[] cats;
                aFilter = new JsonObject();
                aFilter.addProperty("filter_type", "category");
                aFilter.addProperty("datasetIndex", (Number)f.datasetIndex);
                JsonArray jarray = new JsonArray();
                for (Object o : cats = f.selectedCategories != null ? f.selectedCategories : f.categories) {
                    jarray.add((JsonElement)new JsonPrimitive(o.toString()));
                }
                aFilter.add("filter", (JsonElement)jarray);
                jobj.add(f.id, (JsonElement)aFilter);
                continue;
            }
            aFilter = new JsonObject();
            aFilter.addProperty("filter_type", "range");
            aFilter.addProperty("datasetIndex", (Number)f.datasetIndex);
            JsonObject range = new JsonObject();
            Double low = f.lowValue == null ? f.min : f.lowValue;
            range.addProperty("min", (Number)low);
            Double high = f.highValue == null ? f.max : f.highValue;
            range.addProperty("max", (Number)high);
            aFilter.add("filter", (JsonElement)range);
            jobj.add(f.id, (JsonElement)aFilter);
        }
        return jobj;
    }

    private FilterControl(int dataIndex, String id, String label, Object[] categories, Double min, Double max, Double lowValue, Double highValue, Object[] selectedCategories, boolean animate, Double animateSpeed, Double animateFrames) {
        this.datasetIndex = dataIndex;
        this.id = id;
        this.label = label;
        this.categories = categories;
        this.min = min;
        this.max = max;
        this.lowValue = lowValue == null ? null : Double.valueOf(Math.max(min, lowValue));
        this.highValue = highValue == null ? null : Double.valueOf(Math.min(max, highValue));
        this.selectedCategories = selectedCategories;
        this.animateSpeed = animateSpeed;
        this.animateFrames = animateFrames;
        this.animate = animate;
        if (lowValue != null && highValue != null && lowValue > highValue) {
            throw new IllegalArgumentException("Low filter value (" + lowValue + ") cannot be greater than high filter value (" + highValue + ") for: " + label);
        }
        this.substituteExactCase();
    }

    private void substituteExactCase() {
        if (this.selectedCategories != null) {
            for (int i = 0; i < this.selectedCategories.length; ++i) {
                for (int j = 0; j < this.categories.length; ++j) {
                    String main;
                    String selected;
                    if (!(this.selectedCategories[i] instanceof String) || !(this.categories[j] instanceof String) || !(selected = (String)this.selectedCategories[i]).equalsIgnoreCase(main = (String)this.categories[j])) continue;
                    this.selectedCategories[i] = main;
                }
            }
        }
    }
}

