/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.ArrayList;
import java.util.List;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.summary.Fit;
import org.brunel.data.summary.MeasureField;
import org.brunel.data.summary.Regression;
import org.brunel.data.summary.Smooth;
import org.brunel.data.util.ItemsList;
import org.brunel.data.util.Range;

public final class SummaryValues {
    private final Field[] fields;
    private final Field[] xFields;
    public final List<Integer> rows = new ArrayList<Integer>();
    private final ArrayList<Field> groupFields;
    public double[] percentSums;

    public SummaryValues(Field[] fields, Field[] xFields, Field[] allDimensions) {
        this.fields = fields;
        this.xFields = xFields;
        this.groupFields = new ArrayList();
        for (Field f : allDimensions) {
            boolean isGroup = true;
            for (Field x : xFields) {
                if (x != f) continue;
                isGroup = false;
            }
            if (!isGroup) continue;
            this.groupFields.add(f);
        }
    }

    public int firstRow() {
        return this.rows.get(0);
    }

    public Object get(int fieldIndex, MeasureField m) {
        String summary = m.method;
        if (summary.equals("count")) {
            return this.rows.size();
        }
        Field x = this.xFields.length == 0 ? null : this.xFields[this.xFields.length - 1];
        int index = this.rows.get(0);
        if (summary.equals("fit")) {
            Fit fit = m.getFit(this.groupFields, index);
            if (fit == null) {
                fit = new Regression(m.field, x, this.validForGroup(index));
            }
            m.setFit(this.groupFields, index, fit);
            return fit.get(x.value(index));
        }
        if (summary.equals("smooth")) {
            Fit fit = m.getFit(this.groupFields, index);
            if (fit == null) {
                Double windowPercent = null;
                if (m.option != null) {
                    windowPercent = Double.parseDouble(m.option);
                }
                fit = new Smooth(m.field, x, windowPercent, this.validForGroup(index));
            }
            m.setFit(this.groupFields, index, fit);
            return fit.get(x.value(this.rows.get(0)));
        }
        Object[] data = new Object[this.rows.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.fields[fieldIndex].value(this.rows.get(i));
        }
        Field f = Fields.makeColumnField("temp", null, data);
        Double mean = f.numProperty("mean");
        if (summary.equals("percent")) {
            if (mean == null) {
                return null;
            }
            double sum = "overall".equals(m.option) ? (double)m.field.valid() * m.field.numProperty("mean") : this.percentSums[fieldIndex];
            return sum > 0.0 ? Double.valueOf(100.0 * mean * (double)f.valid() / sum) : null;
        }
        if (summary.equals("range")) {
            return this.makeRange(m, f, "min", "max");
        }
        if (summary.equals("iqr")) {
            return this.makeRange(m, f, "q1", "q3");
        }
        if (summary.equals("stderr")) {
            Double s = f.numProperty("stddev");
            Double multiplier = 1.0;
            if (m.option != null) {
                multiplier = Double.parseDouble(m.option);
            }
            if (s != null && mean != null) {
                return Range.make(mean - s * multiplier, mean + s * multiplier, m.getDateFormat());
            }
        }
        if (summary.equals("sum")) {
            if (mean == null) {
                return null;
            }
            return mean * f.numProperty("valid");
        }
        if (summary.equals("list")) {
            ItemsList categories = new ItemsList((Object[])f.property("categories"));
            if (m.option != null) {
                int displayCount = Integer.parseInt(m.option);
                categories.setDisplayCount(displayCount);
            }
            return categories;
        }
        return f.property(summary);
    }

    protected Object makeRange(MeasureField m, Field f, String a, String b) {
        return Range.make(f.numProperty(a), f.numProperty(b), m.getDateFormat());
    }

    private List<Integer> validForGroup(int index) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int n = this.fields[0].rowCount();
        for (int i = 0; i < n; ++i) {
            boolean valid = true;
            for (Field f : this.groupFields) {
                if (f.compareRows(index, i) == 0) continue;
                valid = false;
            }
            if (!valid) continue;
            list.add(i);
        }
        return list;
    }
}

