/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.modify.DataOperation;

public class SetRowCount
extends DataOperation {
    private final Dataset base;
    private final Field sizeField;
    private final int N;

    public static Dataset transform(Dataset base, String command) {
        if (base.rowCount() == 0 || command.isEmpty()) {
            return base;
        }
        String[] parts = DataOperation.strings(command, ',');
        return new SetRowCount(base, base.field(parts[0]), Integer.parseInt(parts[1])).make();
    }

    private SetRowCount(Dataset base, Field sizeField, int N) {
        this.base = base;
        this.sizeField = sizeField;
        if (!sizeField.isNumeric()) {
            throw new IllegalArgumentException("Cannot set rows based on a non-numeric field");
        }
        this.N = N;
    }

    private Dataset make() {
        if (this.base.rowCount() < this.N) {
            return this.addRows();
        }
        return this.base;
    }

    private Dataset addRows() {
        int n = this.base.rowCount();
        double[] fractional = new double[n];
        int[] replications = new int[fractional.length];
        int calculatedN = 0;
        double total = this.sizeField.numProperty("mean") * this.sizeField.numProperty("n");
        for (int i = 0; i < n; ++i) {
            Double value = Data.asNumeric(this.sizeField.value(i));
            fractional[i] = value == null ? 0.0 : value * (double)this.N / total;
            replications[i] = (int)Math.round(fractional[i]);
            calculatedN += replications[i];
        }
        while (calculatedN > this.N) {
            int least = 0;
            for (int i = 1; i < n; ++i) {
                if (!(fractional[i] - (double)replications[i] < fractional[least] - (double)replications[least])) continue;
                least = i;
            }
            int n2 = least;
            replications[n2] = replications[n2] - 1;
            --calculatedN;
        }
        while (calculatedN < this.N) {
            int most = 0;
            for (int i = 1; i < n; ++i) {
                if (!(fractional[i] - (double)replications[i] > fractional[most] - (double)replications[most])) continue;
                most = i;
            }
            int n3 = most;
            replications[n3] = replications[n3] + 1;
            ++calculatedN;
        }
        int[] rowMap = new int[this.N];
        int targetRow = 0;
        int baseRow = 0;
        while (targetRow < this.N) {
            for (int i = 0; i < replications[baseRow]; ++i) {
                rowMap[targetRow++] = baseRow;
            }
            ++baseRow;
        }
        Field[] newFields = new Field[this.base.fields.length];
        for (int i = 0; i < newFields.length; ++i) {
            newFields[i] = Fields.permute(this.base.fields[i], rowMap, false);
        }
        return this.base.replaceFields(newFields);
    }
}

