/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import java.util.List;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.modify.Stack;

public class AllCombinations {
    private final Field[] fields;
    private final int xCount;
    private final int keyLength;
    private final Object[][] categories;
    private final int[] index;

    public AllCombinations(Field[] fields, int xCount, int groupCount) {
        this.fields = fields;
        this.xCount = xCount;
        this.keyLength = xCount + groupCount;
        this.index = new int[this.keyLength];
        this.categories = this.makeFieldCategories();
    }

    private Object[][] makeFieldCategories() {
        Object[][] result = new Object[this.keyLength][];
        for (int i = 0; i < this.keyLength; ++i) {
            Object[] objects = this.fields[i].categories();
            if (i < this.xCount) {
                result[i] = objects;
                continue;
            }
            if (i < this.xCount) continue;
            result[i] = new Object[objects.length];
            for (int j = 0; j < objects.length; ++j) {
                result[i][j] = objects[objects.length - 1 - j];
            }
        }
        return result;
    }

    Field[] make() {
        Integer[] rowOrder = Stack.makeStackDataOrder(this.fields, this.keyLength, this.xCount);
        int dataIndex = 0;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        do {
            Object[] row = this.makeKeyRow();
            boolean matched = false;
            while (this.matchesCurrent(row, rowOrder, dataIndex)) {
                matched = true;
                rows.add(this.makeRealRow(rowOrder[dataIndex++]));
            }
            if (matched) continue;
            rows.add(row);
        } while (this.nextIndex());
        Field[] built = new Field[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            built[i] = Fields.makeColumnField(this.fields[i].name, this.fields[i].label, this.extractColumn(rows, i));
            Fields.copyBaseProperties(this.fields[i], built[i]);
        }
        return built;
    }

    private Object[] extractColumn(List<Object[]> rows, int index) {
        Object[] result = new Object[rows.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = rows.get(i)[index];
        }
        return result;
    }

    private Object[] makeKeyRow() {
        Object[] row = new Object[this.fields.length];
        for (int i = 0; i < this.keyLength; ++i) {
            row[i] = this.categories[i][this.index[i]];
        }
        return row;
    }

    private Object[] makeRealRow(int index) {
        int n = this.fields.length;
        Object[] row = new Object[n];
        for (int i = 0; i < this.fields.length; ++i) {
            row[i] = this.fields[i].value(index);
        }
        return row;
    }

    private boolean matchesCurrent(Object[] row, Integer[] dataRowOrder, int dataIndex) {
        if (dataIndex >= dataRowOrder.length) {
            return false;
        }
        int dataRow = dataRowOrder[dataIndex];
        for (int i = 0; i < this.keyLength; ++i) {
            if (Data.compare(row[i], this.fields[i].value(dataRow)) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean nextIndex() {
        for (int p = this.index.length - 1; p >= 0; --p) {
            int n = p;
            this.index[n] = this.index[n] + 1;
            if (this.index[n] < this.categories[p].length) {
                return true;
            }
            this.index[p] = 0;
        }
        return false;
    }
}

