/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.diagram.Edge;
import org.brunel.data.diagram.Node;

public class Hierarchical {
    public Node root;
    public Edge[] links;

    public static Hierarchical makeByNestingFields(Dataset data, String sizeField, String ... fieldNames) {
        Hierarchical result = new Hierarchical();
        Field size = sizeField == null ? null : data.field(sizeField);
        Field[] fields = Hierarchical.toFields(data, fieldNames);
        result.makeNodesUsingFields(data, size, fields);
        result.fixChildren();
        return result;
    }

    public static Hierarchical makeByEdges(Dataset data, String nodeField, String nodeSizeField, Dataset edges, String fromField, String toField) {
        Hierarchical result = new Hierarchical();
        Field id = data.field(nodeField);
        Field from = edges.field(fromField);
        Field to = edges.field(toField);
        Field size = nodeSizeField == null ? null : data.field(nodeSizeField);
        result.makeNodesUsingEdges(id, size, from, to);
        result.fixChildren();
        return result;
    }

    public static int compare(Node a, Node b) {
        int d = Data.compare(a.meanRow(), b.meanRow());
        return d != 0 ? d : Data.compare(a.key, b.key);
    }

    public static int compareReverse(Node a, Node b) {
        return Hierarchical.compare(b, a);
    }

    public Node find(Object name) {
        return this.findNamedNode(this.root, name);
    }

    private Node findNamedNode(Node node, Object name) {
        if (name.equals(node.key)) {
            return node;
        }
        if (node.children == null) {
            return null;
        }
        for (Node n : (Node[])node.children) {
            Node hit = this.findNamedNode(n, name);
            if (hit == null) continue;
            return hit;
        }
        return null;
    }

    private void fixChildren() {
        this.replaceCollections(this.root, null, new HashSet<Node>());
    }

    private static Node makeInternalNode(String label) {
        Node node = new Node(null, 0.0, label, new ArrayList());
        node.temp = new HashMap();
        return node;
    }

    private void makeNodesUsingFields(Dataset data, Field size, Field[] fields) {
        this.root = Hierarchical.makeInternalNode("");
        for (int row = 0; row < data.rowCount(); ++row) {
            Double d = size == null ? 1.0 : Data.asNumeric(size.value(row));
            if (!(d > 0.0)) continue;
            Node current = this.root;
            for (Field field : fields) {
                Map map = (Map)current.temp;
                List children = (List)current.children;
                Object v = field.value(row);
                if (v != null) {
                    current = (Node)map.get(v);
                }
                if (current != null) continue;
                current = Hierarchical.makeInternalNode(field.valueFormatted(row));
                children.add(current);
                map.put(v, current);
            }
            Node child = new Node(row, d, null, null);
            ((List)current.children).add(child);
            child.parent = current;
        }
    }

    private void makeNodesUsingEdges(Field id, Field size, Field from, Field to) {
        int N = id.rowCount();
        HashSet<Node> unparented = new HashSet<Node>();
        ArrayList<Node> all = new ArrayList<Node>();
        HashMap<Object, Node> byID = new HashMap<Object, Node>();
        for (int i = 0; i < N; ++i) {
            Object key = id.value(i);
            Double d = size == null ? 1.0 : Data.asNumeric(size.value(i));
            Node node = new Node(i, d, null, new ArrayList());
            node.key = key;
            unparented.add(node);
            all.add(node);
            byID.put(key, node);
        }
        ArrayList<Edge> validEdges = new ArrayList<Edge>();
        int M = from.rowCount();
        for (int i = 0; i < M; ++i) {
            Node a = (Node)byID.get(from.value(i));
            Node b = (Node)byID.get(to.value(i));
            if (a == null || b == null || !unparented.contains(b)) continue;
            ((List)a.children).add(b);
            unparented.remove(b);
            validEdges.add(new Edge(a, b, i));
        }
        this.links = validEdges.toArray(new Edge[validEdges.size()]);
        if (unparented.size() == 1) {
            this.root = (Node)new ArrayList(unparented).get(0);
        } else {
            this.root = Hierarchical.makeInternalNode("");
            for (Node n : all) {
                if (!unparented.contains(n)) continue;
                ((List)this.root.children).add(n);
            }
        }
    }

    private void replaceCollections(Node current, Object parentKey, Set<Node> processed) {
        if (!processed.add(current)) {
            return;
        }
        current.temp = null;
        List array = (List)current.children;
        if (array != null) {
            Object object = current.children = array.isEmpty() ? null : array.toArray(new Node[array.size()]);
            if (current.key == null) {
                current.key = parentKey == null ? current.innerNodeName : parentKey + "|" + current.innerNodeName;
            }
            for (Node child : array) {
                this.replaceCollections(child, current.key, processed);
            }
        }
    }

    private static Field[] toFields(Dataset data, String[] fieldNames) {
        Field[] fields = new Field[fieldNames.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = data.field(fieldNames[i]);
        }
        return fields;
    }
}

