# -*- coding: utf-8 -*-
"""
著作權所有 (C) 民國102年 意傳文化科技
開發者：薛丞宏
網址：http://意傳.台灣
語料來源：請看各資料庫內說明

本程式乃自由軟體，您必須遵照SocialCalc設計的通用公共授權（Common Public Attribution License, CPAL)來修改和重新發佈這一程式，詳情請參閱條文。授權大略如下，若有歧異，以授權原文為主：
	１．得使用、修改、複製並發佈此程式碼，且必須以通用公共授權發行；
	２．任何以程式碼衍生的執行檔或網路服務，必須公開該程式碼；
	３．將此程式的原始碼當函式庫引用入商業軟體，且不需公開非關此函式庫的任何程式碼

此開放原始碼、共享軟體或說明文件之使用或散佈不負擔保責任，並拒絕負擔因使用上述軟體或說明文件所致任何及一切賠償責任或損害。

臺灣言語工具緣起於本土文化推廣與傳承，非常歡迎各界用於商業軟體，但希望在使用之餘，能夠提供建議、錯誤回報或修補，回饋給這塊土地。

感謝您的使用與推廣～～勞力！承蒙！
"""
from unittest.case import TestCase
from 臺灣言語工具.字詞組集句章.解析整理.拆文分析器 import 拆文分析器
from 臺灣言語工具.字詞組集句章.基本元素.集 import 集
from 臺灣言語工具.字詞組集句章.基本元素.句 import 句
from 臺灣言語工具.字詞組集句章.基本元素.章 import 章
from 臺灣言語工具.字詞組集句章.解析整理.集內組照排 import 集內組照排
from 臺灣言語工具.字詞組集句章.解析整理.物件譀鏡 import 物件譀鏡
from timeit import itertools

class 集內組照排試驗(TestCase):
	def setUp(self):
		self.分析器 = 拆文分析器()
		self.組照排 = 集內組照排()

	def tearDown(self):
		pass

	def test_型照排(self):
		一 = self.分析器.建立組物件('1一')
		一.內底詞[0].屬性 = '我是一'
		空 = self.分析器.建立組物件('0零')
		空.屬性 = '⿰厓係零'
		顛倒集 = 集()
		顛倒集.內底組 = [一, 空]
		顛倒集.資料 = '9'
		答案集 = 集()
		答案集.內底組 = [空, 一]
		顛倒集.物件 = '6'
		譀鏡 = 物件譀鏡()
		排法 = lambda 組物件:譀鏡.看型(組物件)
		self.assertEqual(self.組照排.排好(排法, 顛倒集), 答案集)
		self.assertEqual(self.組照排.排好(排法, 答案集), 答案集)
		self.assertEqual(self.組照排.排好(排法, 顛倒集).內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 答案集).內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 顛倒集).內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(self.組照排.排好(排法, 答案集).內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(hasattr(self.組照排.排好(排法, 顛倒集), '資料'), False)
		self.assertEqual(hasattr(self.組照排.排好(排法, 答案集), '物件'), False)
		句物件 = 句()
		句物件.內底集 = [答案集, 顛倒集, 顛倒集]
		self.assertEqual(self.組照排.排好(排法, 句物件), 句([答案集, 答案集, 答案集]))
		self.assertEqual(self.組照排.排好(排法, 句物件).內底集[0].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 句物件).內底集[0].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(self.組照排.排好(排法, 句物件).內底集[1].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 句物件).內底集[1].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(self.組照排.排好(排法, 句物件).內底集[2].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 句物件).內底集[2].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		章物件 = 章()
		章物件.內底句 = [句物件, 句物件]
		self.assertEqual(self.組照排.排好(排法, 章物件),
			章([句([答案集, 答案集, 答案集]), 句([答案集, 答案集, 答案集])]))
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[0].內底集[0].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[0].內底集[0].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[0].內底集[1].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[0].內底集[1].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[0].內底集[2].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[0].內底集[2].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[1].內底集[0].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[1].內底集[0].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[1].內底集[1].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[1].內底集[1].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[1].內底集[2].內底組[0].屬性, 空.屬性)
		self.assertEqual(self.組照排.排好(排法, 章物件).內底句[1].內底集[2].內底組[1].內底詞[0].屬性, 一.內底詞[0].屬性)
		
	def test_排序試驗(self):
		毋著四 = self.分析器.產生對齊組('我有一張椅仔', 'ngoo2 iu2 it4 tiong1 i2 a2')
		毋著三 = self.分析器.產生對齊組('我有一張椅仔', 'ngoo2 u7 it4 tiong1 i2 a2')
		毋著二 = self.分析器.產生對齊組('我有一張椅仔', 'ngoo2 u7 tsit8 tiong1 i2 a2')
		毋著一 = self.分析器.產生對齊組('我有一張椅仔', 'ngoo2 u7 tsit8 tiunn1 i2 a2')
		無毋著 = self.分析器.產生對齊組('我有一張椅仔', 'gua2 u7 tsit8 tiunn1 i2 a2')
		無毋著.分數 = 90
		毋著一.分數 = 80
		毋著二.分數 = 70
		毋著三.分數 = 60
		毋著四.分數 = 50
		答案集 = 集()
		答案集.內底組 = [無毋著, 毋著一, 毋著二, 毋著三, 毋著四, ]
		for 組陣列 in itertools.permutations([毋著四, 毋著三, 毋著二, 毋著一, 無毋著]):
			集物件 = 集()
			集物件.內底組 = 組陣列
			self.assertEqual(self.組照排.排好(lambda 組物件:-組物件.分數, 集物件), 答案集)
