/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.constants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.snu.ids.ha.util.Hangul;

public class Condition
extends Hangul {
    public static final String[] COND_ARR = new String[]{"\u3163\uacb9", "\ubaa8\uc74c", "\uc790\uc74c", "\uc591\uc131", "\uc74c\uc131", "\uc0ac\uc624", "\uc0ac\uc635", "\uc2dc\uc624", "\uc624", "\uc73c\ub77c", "\uc73c\ub9ac", "\uc73c\uc2dc", "\uc544", "\uc5c8", "\uaca0", "\ub824", "\u3134", "\u3139", "\u3141", "\u3142", "-\u3142", "-\u3139", "-\u314e", "-\u3145", "\ud558", "\uac00\ub2e4", "\uc624\ub2e4", "ENG", "\uccb4\uc5b8", "\uad00\ud615\uc5b4", "\ubd80\uc0ac\uc5b4", "\uc11c\uc220\uc5b4", "EC", "F", "\uc0dd\ub7b5"};
    public static final Hashtable<String, Long> COND_HASH = new Hashtable();
    public static final Hashtable<Long, String> COND_NUM_HASH = new Hashtable();
    public static final long YI_DB;
    public static final long MOEUM;
    public static final long JAEUM;
    public static final long YANGSEONG;
    public static final long EUMSEONG;
    public static final long SAO;
    public static final long SAOP;
    public static final long SIO;
    public static final long OH;
    public static final long ERA;
    public static final long ERI;
    public static final long ESI;
    public static final long AH;
    public static final long EUT;
    public static final long GET;
    public static final long LYEO;
    public static final long NIEUN;
    public static final long MIEUM;
    public static final long LIEUL;
    public static final long BIEUB;
    public static final long MINUS_BIEUB;
    public static final long MINUS_LIEUL;
    public static final long MINUS_HIEUT;
    public static final long MINUS_SIOT;
    public static final long HA;
    public static final long GADA;
    public static final long ODA;
    public static final long ENG;
    public static final long N;
    public static final long D;
    public static final long A;
    public static final long V;
    public static final long EC;
    public static final long F;
    public static final long SHORTEN;
    public static final long MINUS_JA_SET;
    public static final long SET_FOR_UN;

    static {
        long conditionNum = 0L;
        int i = 0;
        int stop = COND_ARR.length;
        while (i < stop) {
            conditionNum = 1L << i;
            COND_HASH.put(COND_ARR[i], new Long(conditionNum));
            COND_NUM_HASH.put(new Long(conditionNum), COND_ARR[i]);
            ++i;
        }
        YI_DB = Condition.getCondNum("\u3163\uacb9");
        MOEUM = Condition.getCondNum("\ubaa8\uc74c");
        JAEUM = Condition.getCondNum("\uc790\uc74c");
        YANGSEONG = Condition.getCondNum("\uc591\uc131");
        EUMSEONG = Condition.getCondNum("\uc74c\uc131");
        SAO = Condition.getCondNum("\uc0ac\uc624");
        SAOP = Condition.getCondNum("\uc0ac\uc635");
        SIO = Condition.getCondNum("\uc2dc\uc624");
        OH = Condition.getCondNum("\uc624");
        ERA = Condition.getCondNum("\uc73c\ub77c");
        ERI = Condition.getCondNum("\uc73c\ub9ac");
        ESI = Condition.getCondNum("\uc73c\uc2dc");
        AH = Condition.getCondNum("\uc544");
        EUT = Condition.getCondNum("\uc5c8");
        GET = Condition.getCondNum("\uaca0");
        LYEO = Condition.getCondNum("\ub824");
        NIEUN = Condition.getCondNum("\u3134");
        MIEUM = Condition.getCondNum("\u3141");
        LIEUL = Condition.getCondNum("\u3139");
        BIEUB = Condition.getCondNum("\u3142");
        MINUS_BIEUB = Condition.getCondNum("-\u3142");
        MINUS_LIEUL = Condition.getCondNum("-\u3139");
        MINUS_HIEUT = Condition.getCondNum("-\u314e");
        MINUS_SIOT = Condition.getCondNum("-\u3145");
        HA = Condition.getCondNum("\ud558");
        GADA = Condition.getCondNum("\uac00\ub2e4");
        ODA = Condition.getCondNum("\uc624\ub2e4");
        ENG = Condition.getCondNum("ENG");
        N = Condition.getCondNum("\uccb4\uc5b8");
        D = Condition.getCondNum("\uad00\ud615\uc5b4");
        A = Condition.getCondNum("\ubd80\uc0ac\uc5b4");
        V = Condition.getCondNum("\uc11c\uc220\uc5b4");
        EC = Condition.getCondNum("EC");
        F = Condition.getCondNum("F");
        SHORTEN = Condition.getCondNum("\uc0dd\ub7b5");
        MINUS_JA_SET = MINUS_LIEUL | MINUS_HIEUT | MINUS_SIOT;
        SET_FOR_UN = JAEUM | MOEUM | YANGSEONG | EUMSEONG;
    }

    private static final long getCondNum(int i) {
        return 1L << i;
    }

    public static long getCondNum(String cond) {
        try {
            return COND_HASH.get(cond);
        }
        catch (Exception e) {
            System.err.println("[" + cond + "] \uc815\uc758\ub418\uc9c0 \uc54a\uc740 \uc870\uac74\uc785\ub2c8\ub2e4.");
            return 0L;
        }
    }

    public static long getCondNum(String[] conds) {
        long l = 0L;
        int i = 0;
        int size = conds == null ? 0 : conds.length;
        while (i < size) {
            l |= Condition.getCondNum(conds[i]);
            ++i;
        }
        return l;
    }

    public static String getCond(long condNum) {
        return condNum == 0L ? null : COND_NUM_HASH.get(new Long(condNum));
    }

    public static List<String> getCondList(long encCondNum) {
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        int stop = COND_ARR.length;
        while (i < stop) {
            if ((encCondNum & Condition.getCondNum(i)) > 0L) {
                ret.add(COND_ARR[i]);
            }
            ++i;
        }
        return ret;
    }

    public static String getCondStr(long encCondNum) {
        StringBuffer sb = new StringBuffer();
        List<String> condList = Condition.getCondList(encCondNum);
        int i = 0;
        int size = condList.size();
        while (i < size) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(condList.get(i));
            ++i;
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public static final List<String> getCondList() {
        ArrayList<String> condList = new ArrayList<String>();
        ArrayList<Long> condNumList = new ArrayList<Long>(COND_NUM_HASH.keySet());
        Collections.sort(condNumList);
        int i = 0;
        int size = condNumList.size();
        while (i < size) {
            condList.add(COND_NUM_HASH.get(condNumList.get(i)));
            ++i;
        }
        return condList;
    }

    public static final boolean checkAnd(long havingCond, long checkingCond) {
        return (havingCond & checkingCond) == checkingCond;
    }

    public static final boolean checkOr(long havingCond, long checkingCond) {
        return (havingCond & checkingCond) > 0L;
    }
}

