# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GalleryImageVersionStorageProfile(Model):
    """This is the storage profile of a gallery Image Version.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar os_disk_image:
    :vartype os_disk_image:
     ~azure.mgmt.compute.v2019_03_01.models.GalleryOSDiskImage
    :ivar data_disk_images: A list of data disk images.
    :vartype data_disk_images:
     list[~azure.mgmt.compute.v2019_03_01.models.GalleryDataDiskImage]
    """

    _validation = {
        'os_disk_image': {'readonly': True},
        'data_disk_images': {'readonly': True},
    }

    _attribute_map = {
        'os_disk_image': {'key': 'osDiskImage', 'type': 'GalleryOSDiskImage'},
        'data_disk_images': {'key': 'dataDiskImages', 'type': '[GalleryDataDiskImage]'},
    }

    def __init__(self, **kwargs) -> None:
        super(GalleryImageVersionStorageProfile, self).__init__(**kwargs)
        self.os_disk_image = None
        self.data_disk_images = None
