import functools
import urlparse
from route import Route
import os, sys, time

from pprint import pformat as pr

# } imports

author = 'Alex'
version = '1.0.1'

class Hashtable(dict):
    def __init__(self, list={}):
        self.update(list)

    def __getattr__(self, name):
        return self.get(name, None)

    def __setattr__(self, name, value):
        self[name] = value

#    def __getitem__(self, name):
#        return self.__getattr__(name)
#
#    def __setitem__(self, name, value):
#        self[name] = value

import re

class Router(object):
    _routes = {}
    def __init__(self):
        pass

    def add(self, template, handler):
        self._routes[re.compile(template)] = handler

    def match(self, path):
        for r in self._routes:
            if r.match(path):
                return self._routes[r]()

        return None

class Request(object):
    def __init__(self, environ=None):
        self.environ = environ or {}
        self.path = '/' + self.environ.get('PATH_INFO', '/').lstrip('/')
        self.method = self.environ.get('REQUEST_METHOD', 'GET').upper()

    def bind(self, environ):
        """ Bind a new WSGI environment.

            This is done automatically for the global `bottle.request`
            instance on every request.
        """
        self.environ = environ
        # These attributes are used anyway, so it is ok to compute them here
        self.path = '/' + environ.get('PATH_INFO', '/').lstrip('/')
        self.method = environ.get('REQUEST_METHOD', 'GET').upper()

    @property
    def GET(self):
        return Hashtable(urlparse.parse_qs(self.environ['QUERY_STRING'], True))

    @property
    def POST(self):
        if self.method != 'POST':
            return Hashtable()

        post_input = urlparse.parse_qs(self.body, True)

        return Hashtable(post_input)

    @property
    def COOKIES(self):
        return Hashtable(urlparse.parse_qs(self.environ['HTTP_COOKIE'], True))

    @property
    def headers(self):
        return Hashtable(self.environ)

    @property
    def body(self):
        try:
            content_length = int(self.environ.get('CONTENT_LENGTH', '0'))
            stream = self.environ.get('wsgi.input', None)
        except:
            return ''

        if stream is None or content_length is 0:
            return ''

        from cStringIO import StringIO

        body = StringIO(stream.read(content_length))

        return body.read()

    def is_ajax(self):
        return False

class Response(object):
    content_type = 'text/html'

    def type(self, type=None):
        if type:
            self.content_type = type
        else:
             return self.content_type

    def bind(self):
        """ Resets the Response object to its factory defaults. """
        self._COOKIES = None
        self.status = 200
        self.headers = {}
        self.content_type = 'text/html; charset=UTF-8'

class Config(dict):
    def __init__(self):
        self.update({
            'VIEW_DIR_NAME': 'views'
        })

    def __getattr__(self, name):
        return self[name]

    def __setattr__(self, name, value):
        self[name] = value

    def __delattr__(self, name):
        del self[name]

    def load(self, res):
        if type(res) is dict:
            self.update(res)
        elif type(res) is str:
            res = os.path.join(os.path.realpath('.'), res)

            execfile(res, {}, self)
        else:
            print 'ERROR: Provided config type not supported'
            exit()

from wsgi import *

class App(object):
    filters = {}

    request = Request()
    response = Response()
    router = Router()

    name = None
    path = None

    __errors = None

    def __init__(self, name=__name__):
        self.name = name
        self.path = __path__
        self.__errors = {
        404: self.page_not_found,
        500: self.server_error
    }

    def new(self, name):
        self.name = name
        self.path = os.path.abspath(os.path.dirname(sys.modules[self.name].__file__))

    #wsgi
    def wsgi(self, environ, start_response):
        global request

        """ The bottle WSGI-interface. """
        try:
            environ['bottle.app'] = self
            request.bind(environ)
            response.bind()
            out = ''

            self.request = request = app.request = Request(environ)

            content = self.router.match(self.request.path)

#            out = self.handle(request.path, request.method)
#            out = self._cast(out, request, response)
            # rfc2616 section 4.3
            if response.status in (100, 101, 204, 304) or request.method == 'HEAD':
                if hasattr(out, 'close'): out.close()
                out = []
            status = '%d %s' % (response.status, response.status)
            start_response(status, [])
            return out
        except (KeyboardInterrupt, SystemExit, MemoryError):
            raise
        except Exception, e:
            from traceback import format_exc

            err = '<h1>Critical error while processing request: %s</h1>' \
                  % environ.get('PATH_INFO', '/')
#            if DEBUG:
            err += '<h2>Error:</h2>\n<pre>%s</pre>\n' % repr(e)
            err += '<h2>Traceback:</h2>\n<pre>%s</pre>\n' % format_exc(10)
            environ['wsgi.errors'].write(err) #TODO: wsgi.error should not get html
            start_response('500 INTERNAL SERVER ERROR', [('Content-Type', 'text/html')])
            return [err]

    def __call__(self, environ, start_response):
        return self.wsgi(environ, start_response)
    #wsgi

    @property
    def page_not_found(self):
        return '404'

    @property
    def server_error(self):
        return '500'

    def route(self, rule):
        def decorator(f):
            self.routes = Route(template=rule, handler=f)

            self.router.add(template=rule, handler=f)

            return f

        return decorator

    def render(self, name, **vars):
        from jinja2 import Environment, PackageLoader

        view_dir = os.path.join(self.path, config.VIEW_DIR_NAME)

        env = Environment(loader=PackageLoader(__name__, view_dir))

        if self.filters: env.filters.update(self.filters)

        template = env.get_template(name)

        return str(template.render(vars))

    def error(self, code, handler=None):
        def decorator(f):

            self.__errors[code] = f

            return f

        if handler:
            decorator(handler)

        return decorator

    def filter(self, name=None):
        if callable(name):
            self.filters[name.__name__] = name

        def decorator(f):

            self.filters[name or f.__name__] = f

            return f

        return decorator

    def run(self, host='0.0.0.0', port='8000'):
        from wsgiref.util import setup_testing_defaults
        from wsgiref.simple_server import make_server

        # A relatively simple WSGI application. It's going to print out the
        # environment dictionary after being updated by setup_testing_defaults
        def simple_app(environ, start_response):
            start_time = time.time()

            setup_testing_defaults(environ)

            status = '200 OK'
            headers = [('Content-type', self.response.type())]

            content = '404'

#            ret = ["%s: %s\n" % (key, value)
#                   for key, value in environ.iteritems()]

            self.request = request = app.request = Request(environ)

            content = self.router.match(self.request.path)

            if not content:
                content = self.__errors[404]()

            if config.DEBUG:
                headers.append(('X-Time', '%2fs' % (time.time() - start_time)))

            start_response(status, headers)

            return content

        def start_server():
            print "Serving on port %s..." % (port)
            self.httpd = make_server(host, int(port), simple_app)
            self.httpd.serve_forever()

        # Auto reload server on file change. Only in DEBUG mode
        def AutoReload():
            _files = {}

            while True:
                for module in sys.modules.values():
                    if not hasattr(module, '__file__'):
                        continue

                    path = getattr(module, '__file__')

                    if not path:
                        continue

                    if os.path.splitext(path)[1] in ['.pyc', '.pyo', '.pyd']:
                        path = path[:-1]

                    if path in _files:
                        if not os.path.isfile(path) or _files[path] != os.stat(path).st_mtime:
                            print "%s file is changed" % path
                            print "Reloading..."

                            sys.exit(10)
                    else:
                        if os.path.isfile(path):
                            _files[path] = os.stat(path).st_mtime

                time.sleep(1)

        exit_code = 0

        try:
            if config.DEBUG:
                import threading, subprocess, signal

                if os.environ.get('MAIN_PROCESS', None) is None:
                    exit_code = 10
                    os.environ['MAIN_PROCESS'] = 'true'

                    while exit_code is 10:
                        exit_code = subprocess.call([sys.executable] + sys.argv, env=os.environ)
                else:
                    _thread = threading.Thread(target=start_server)
                    _thread.setDaemon(True)
                    _thread.start()

                    AutoReload()

        except KeyboardInterrupt:
            pass

        exit(exit_code)

app = App(__name__)

globals()['route'] = app.route
globals()['error'] = app.error
globals()['filter'] = app.filter
globals()['run'] = app.run

request = req = app.request = Request()
response = res = app.response = Response()
config = app.config = Config()