"""
This file demonstrates writing tests using the unittest module. These will pass
when you run "manage.py test".

Replace this with more appropriate tests for your application.
"""

from django.test import TestCase
from autograph.models import Autograph

signature_test = [
    '{"lines":[[[42.73,144.55],[42.73,146.55],'
    '[42.73,147.55],[42.73,148.55],[42.73,150.55],'
    '[44.73,151.55],[50.73,151.55],[60.73,148.55],'
    '[91.73,136.55],[124.73,117.55],[152.73,98.55],'
    '[172.73,80.55],[177.73,64.55],[177.73,56.55],'
    '[177.73,52.55],[172.73,51.55],[162.73,55.55],'
    '[148.73,67.55],[129.73,85.55],[116.73,103.55],'
    '[107.73,120.55],[104.73,131.55],[105.73,138.55],'
    '[111.73,143.55],[122.73,145.55],[133.73,145.55],'
    '[150.73,144.55],[169.73,140.55],[188.73,132.55],'
    '[202.73,124.55],[209.73,117.55],[209.73,116.55],'
    '[209.73,118.55],[209.73,119.55],[209.73,120.55],'
    '[209.73,127.55],[209.73,134.55],[209.73,135.55],'
    '[212.73,135.55],[217.73,133.55],[229.73,126.55],'
    '[246.73,114.55],[259.73,106.55],[262.73,104.55],'
    '[262.73,104.55],[264.73,107.55],[267.73,115.55],'
    '[270.73,118.55],[273.73,119.55],[280.73,119.55],'
    '[287.73,117.55],[293.73,114.55],[296.73,114.55]]]}',
    '{"lines":[[[114.73,115.55],[113.73,116.55],'
    '[112.73,116.55],[113.73,115.55],[117.73,112.55],'
    '[133.73,105.55],[162.73,97.55],[200.73,88.55],'
    '[244.73,77.55],[285.73,69.55],[306.73,63.55],'
    '[309.73,63.55],[308.73,64.55],[307.73,64.55],'
    '[304.73,69.55],[289.73,82.55],[266.73,98.55],'
    '[242.73,114.55],[214.73,129.55],[191.73,140.55],'
    '[177.73,147.55],[170.73,151.55],[169.73,151.55],'
    '[168.73,151.55],[168.73,150.55],[168.73,148.55],'
    '[169.73,144.55],[174.73,128.55],[182.73,106.55],'
    '[192.73,81.55],[198.73,59.55],[202.73,40.55],'
    '[205.73,31.55],[205.73,28.55],[205.73,27.55],'
    '[205.73,26.55],[206.73,26.55],[207.73,27.55],'
    '[212.73,38.55],[224.73,64.55],[240.73,89.55],'
    '[254.73,111.55],[268.73,125.55],[280.73,134.55],'
    '[283.73,137.55],[283.73,138.55],[282.73,138.55],'
    '[282.73,138.55],[280.73,138.55],[272.73,138.55],'
    '[257.73,138.55],[238.73,134.55],[215.73,130.55],'
    '[191.73,127.55],[172.73,123.55],[157.73,120.55],'
    '[143.73,117.55],[131.73,117.55],[123.73,117.55],'
    '[120.73,117.55],[119.73,117.55],[116.73,116.55],'
    '[115.73,116.55],[114.73,116.55],[112.73,116.55]]]}'
]


class AutographTest(TestCase):
    """Demo for Autograph."""
    def setUp(self):
        """Test dummy data creation."""
        Autograph.objects.create(signature=signature_test[0])
        Autograph.objects.create(signature=signature_test[1])

    def test_autograph_data(self):
        """Test setUp data."""
        Autograph.objects.get(signature=signature_test[0])
        Autograph.objects.get(signature=signature_test[1])

    def test_autograph_image(self):
        """Test for generate signature image."""
        autograph = Autograph.objects.get(signature=signature_test[0])
        autograph.generate_signature_image(im_output_name='signature_test_1.png')
        autograph = Autograph.objects.get(signature=signature_test[1])
        autograph.generate_signature_image(im_output_name='signature_test_2.png')