/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.util.KeyValue;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.XmlReportAbstract;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class XmpReportImpl
extends XmlReportAbstract {
    public XmpReportImpl(PrintWriter out, String ePubName, String versionEpubCheck) {
        super(out, ePubName, versionEpubCheck);
    }

    @Override
    public int generateReport() {
        if (this.out == null) {
            return 1;
        }
        int returnCode = 1;
        int ident = 0;
        this.generationDate = XmpReportImpl.fromTime(System.currentTimeMillis());
        try {
            this.output(ident, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.startElement(ident++, "x:xmpmeta", KeyValue.with("xmlns:x", "adobe:ns:meta/"), KeyValue.with("x:xmptk", "Adobe XMP Core 5.1.0-jc003"));
            this.startElement(ident++, "rdf:RDF", KeyValue.with("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
            ArrayList<KeyValue<String, String>> attrs = new ArrayList<KeyValue<String, String>>();
            attrs.add(KeyValue.with("rdf:about", ""));
            attrs.add(KeyValue.with("xmlns:dc", "http://purl.org/dc/elements/1.1/"));
            attrs.add(KeyValue.with("xmlns:xmp", "http://ns.adobe.com/xap/1.0/"));
            attrs.add(KeyValue.with("xmlns:xmpTPg", "http://ns.adobe.com/xap/1.0/t/pg/"));
            attrs.add(KeyValue.with("xmlns:stFnt", "http://ns.adobe.com/xap/1.0/sType/Font#"));
            attrs.add(KeyValue.with("xmlns:extended-properties", "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/"));
            attrs.add(KeyValue.with("xmlns:premis", "http://www.loc.gov/premis/rdf/v1#"));
            if (this.formatName == null) {
                attrs.add(KeyValue.with("dc:format", "application/octet-stream"));
            } else if (this.formatVersion == null) {
                attrs.add(KeyValue.with("dc:format", this.formatName));
            } else {
                attrs.add(KeyValue.with("dc:format", this.formatName + ";version=" + this.formatVersion));
            }
            if (this.creationDate != null) {
                attrs.add(KeyValue.with("xmp:CreateDate", this.creationDate));
            }
            if (this.charsCount != 0L) {
                attrs.add(KeyValue.with("extended-properties:Characters", Long.toString(this.charsCount)));
            }
            if (this.pagesCount != 0L) {
                attrs.add(KeyValue.with("xmpTPg:NPages", Long.toString(this.pagesCount)));
            }
            if (this.publisher != null) {
                attrs.add(KeyValue.with("dc:publisher", this.publisher));
            }
            attrs.add(KeyValue.with("dc:identifier", this.identifier));
            if (this.language != null) {
                attrs.add(KeyValue.with("dc:language", this.language));
            }
            this.startElement(ident++, "rdf:Description", attrs);
            if (!this.creators.isEmpty()) {
                this.startElement(ident++, "dc:creator");
                this.startElement(ident++, "rdf:Seq");
                for (Object creator : this.creators) {
                    this.generateElement(ident, "rdf:li", (String)creator);
                }
                this.endElement(--ident, "rdf:Seq");
                this.endElement(--ident, "dc:creator");
            }
            if (!this.titles.isEmpty()) {
                this.startElement(ident++, "dc:title");
                this.startElement(ident++, "rdf:Alt");
                boolean first = true;
                for (String title : this.titles) {
                    if (first) {
                        this.generateElement(ident, "rdf:li", title.trim(), KeyValue.with("xml:lang", "x-default"));
                        first = false;
                        continue;
                    }
                    this.generateElement(ident, "rdf:li", title);
                }
                this.endElement(--ident, "rdf:Alt");
                this.endElement(--ident, "dc:title");
            }
            if (!this.subjects.isEmpty()) {
                this.startElement(ident++, "dc:subject");
                this.startElement(ident++, "rdf:Bag");
                for (String subject : this.subjects) {
                    this.generateElement(ident, "rdf:li", subject);
                }
                this.endElement(--ident, "rdf:Bag");
                this.endElement(--ident, "dc:subject");
            }
            if (!this.embeddedFonts.isEmpty() || !this.refFonts.isEmpty()) {
                this.startElement(ident++, "xmpTPg:Fonts");
                this.startElement(ident++, "rdf:Bag");
                for (String font : this.embeddedFonts) {
                    this.generateFont(ident, font, true);
                }
                for (String font : this.refFonts) {
                    this.generateFont(ident, font, false);
                }
                this.endElement(--ident, "rdf:Bag");
                this.endElement(--ident, "xmpTPg:Fonts");
            }
            this.startElement(ident++, "premis:hasEvent", KeyValue.with("rdf:parseType", "Resource"));
            this.generateElement(ident, "premis:hasEventDateTime", this.generationDate, KeyValue.with("rdf:datatype", "http://www.w3.org/2001/XMLSchema#dateTime"));
            this.generateElement(ident, "premis:hasEventType", null, KeyValue.with("rdf:resource", "http://id.loc.gov/vocabulary/preservation/eventType/val"));
            if (this.fatalErrors.isEmpty() && this.errors.isEmpty()) {
                this.generateElement(ident, "premis:hasEventDetail", "Well-formed");
            } else {
                this.generateElement(ident, "premis:hasEventDetail", "Not well-formed");
            }
            if (this.fatalErrors.size() + this.errors.size() + this.warns.size() + this.hints.size() != 0) {
                this.startElement(ident++, "premis:hasEventOutcomeInformation");
                this.startElement(ident++, "rdf:Seq");
                this.generateEventOutcome(ident, this.fatalErrors, "FATAL");
                this.generateEventOutcome(ident, this.errors, "ERROR");
                this.generateEventOutcome(ident, this.warns, "WARN");
                this.generateEventOutcome(ident, this.hints, "HINT");
                this.endElement(--ident, "rdf:Seq");
                this.endElement(--ident, "premis:hasEventOutcomeInformation");
            }
            this.startElement(ident++, "premis:hasEventRelatedAgent", KeyValue.with("rdf:parseType", "Resource"));
            this.generateElement(ident, "premis:hasAgentType", null, KeyValue.with("rdf:resource", "http://id.loc.gov/vocabulary/preservation/agentType/sof"));
            if (this.epubCheckVersion == null) {
                this.generateElement(ident, "premis:hasAgentName", this.epubCheckName);
            } else {
                this.generateElement(ident, "premis:hasAgentName", this.epubCheckName + " " + this.epubCheckVersion);
            }
            this.endElement(--ident, "premis:hasEventRelatedAgent");
            this.endElement(--ident, "premis:hasEvent");
            this.startElement(ident++, "premis:hasSignificantProperties");
            this.startElement(ident++, "rdf:Bag");
            this.generateSignificantProperty(ident, "renditionLayout", this.hasFixedLayout ? "fixed-layout" : "reflowable");
            this.generateSignificantProperty(ident, "isScripted", Boolean.toString(this.hasScripts));
            this.generateSignificantProperty(ident, "hasEncryption", Boolean.toString(this.hasEncryption));
            this.generateSignificantProperty(ident, "hasAudio", Boolean.toString(this.hasAudio));
            this.generateSignificantProperty(ident, "hasVideo", Boolean.toString(this.hasVideo));
            this.generateSignificantProperty(ident, "hasSignatures", Boolean.toString(this.hasSignatures));
            this.generateSignificantProperty(ident, "hasAllFontsEmbedded", Boolean.toString(this.refFonts.isEmpty()));
            int nRefs = 0;
            for (String ref : this.references) {
                if (++nRefs > 50) {
                    this.generateSignificantProperty(ident, "reference", "" + (this.references.size() - 50) + " more references");
                    break;
                }
                this.generateSignificantProperty(ident, "reference", ref);
            }
            this.endElement(--ident, "rdf:Bag");
            this.endElement(--ident, "premis:hasSignificantProperties");
            this.endElement(--ident, "rdf:Description");
            this.endElement(--ident, "rdf:RDF");
            this.endElement(--ident, "x:xmpmeta");
            returnCode = 0;
        }
        catch (Exception e) {
            System.err.println("Exception encountered: " + e.getMessage());
            returnCode = 1;
        }
        return returnCode;
    }

    protected void generateFont(int ident, String font, boolean embeded) {
        String[] elFont = font.split(",");
        ArrayList<KeyValue<String, String>> attrs = new ArrayList<KeyValue<String, String>>();
        attrs.add(KeyValue.with("stFnt:fontFamily", this.capitalize(elFont[0])));
        String fontFace = "";
        for (int i = 1; i < elFont.length; ++i) {
            fontFace = fontFace + this.capitalize(elFont[i]) + " ";
        }
        if ((fontFace = fontFace.trim()).length() == 0) {
            attrs.add(KeyValue.with("stFnt:fontFace", "Regular"));
        } else {
            attrs.add(KeyValue.with("stFnt:fontFace", fontFace));
        }
        this.generateElement(ident, "rdf:li", null, attrs);
    }

    private void generateEventOutcome(int ident, List<CheckMessage> messages, String sev) {
        for (CheckMessage c : messages) {
            this.startElement(ident++, "rdf:li", KeyValue.with("rdf:parseType", "Resource"));
            this.generateElement(ident, "premis:hasEventOutcome", c.getID() + ", " + sev + ", " + XmpReportImpl.encodeContent(c.getMessage()));
            if (c.getLocations().size() != 0) {
                this.startElement(ident++, "premis:hasEventOutcomeDetail");
                this.startElement(ident++, "rdf:Seq");
                String previousValue = "";
                for (EPUBLocation ml : c.getLocations()) {
                    String value = PathUtil.removeWorkingDirectory(ml.getPath());
                    if (ml.getLine() > 0 || ml.getColumn() > 0) {
                        value = value + " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                    }
                    if (previousValue.equals(value)) continue;
                    this.generateElement(ident, "rdf:li", null, KeyValue.with("premis:hasEventOutcomeDetailNote", value));
                    previousValue = value;
                }
                this.endElement(--ident, "rdf:Seq");
                this.endElement(--ident, "premis:hasEventOutcomeDetail");
            }
            this.endElement(--ident, "rdf:li");
        }
    }

    private void generateSignificantProperty(int ident, String property, String value) {
        ArrayList<KeyValue<String, String>> attrs = new ArrayList<KeyValue<String, String>>();
        attrs.add(KeyValue.with("premis:hasSignificantPropertiesType", property));
        attrs.add(KeyValue.with("premis:hasSignificantPropertiesValue", value));
        this.generateElement(ident, "rdf:li", null, attrs);
    }
}

