/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.bitmap.BitmapCheckerFactory;
import com.adobe.epubcheck.css.CSSCheckerFactory;
import com.adobe.epubcheck.dtbook.DTBookCheckerFactory;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.nav.NavCheckerFactory;
import com.adobe.epubcheck.ncx.NCXCheckerFactory;
import com.adobe.epubcheck.ocf.OCFFilenameChecker;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.ContentCheckerFactory;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.GenericContentCheckerFactory;
import com.adobe.epubcheck.opf.OPFData;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.OPFReference;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.ValidatorMap;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

public class OPFChecker
implements DocumentValidator,
ContentChecker {
    private static final ValidatorMap validatorMap = ValidatorMap.builder().put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2), XMLValidators.OPF_20_RNG).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2), XMLValidators.OPF_20_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_RNC).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_DO_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_DICT_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_IDX_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_MANIFEST_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_PREVIEW_SCH).put(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.DICT), ValidationContext.ValidationContextPredicates.hasPubType("dictionary")), XMLValidators.OPF_DICT_SCH).put(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.EDUPUB), ValidationContext.ValidationContextPredicates.hasPubType("edupub")), XMLValidators.OPF_EDUPUB_SCH).put(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.PREVIEW), ValidationContext.ValidationContextPredicates.hasPubType("preview")), XMLValidators.OPF_PREVIEW_SCH).build();
    protected final ValidationContext context;
    protected final Report report;
    protected final String path;
    protected final EPUBVersion version;
    protected OPFHandler opfHandler = null;
    protected XMLParser opfParser = null;
    protected final Hashtable<String, ContentCheckerFactory> contentCheckerFactoryMap = new Hashtable();

    protected void initContentCheckerFactoryMap() {
        Hashtable<String, ContentCheckerFactory> map = new Hashtable<String, ContentCheckerFactory>();
        map.put("application/xhtml+xml", OPSCheckerFactory.getInstance());
        map.put("application/x-dtbook+xml", DTBookCheckerFactory.getInstance());
        map.put("image/jpeg", BitmapCheckerFactory.getInstance());
        map.put("image/gif", BitmapCheckerFactory.getInstance());
        map.put("image/png", BitmapCheckerFactory.getInstance());
        map.put("image/svg+xml", OPSCheckerFactory.getInstance());
        map.put("text/css", CSSCheckerFactory.getInstance());
        map.put("text/html", OPSCheckerFactory.getInstance());
        map.put("text/x-oeb1-document", OPSCheckerFactory.getInstance());
        this.contentCheckerFactoryMap.putAll(map);
    }

    public OPFChecker(ValidationContext context) {
        this.report = context.report;
        this.path = context.path;
        this.version = context.version;
        ValidationContext.ValidationContextBuilder newContext = new ValidationContext.ValidationContextBuilder(context);
        if (context.ocf.isPresent()) {
            OPFData opfData = context.ocf.get().getOpfData().get(context.path);
            newContext.pubTypes(opfData != null ? opfData.getTypes() : null);
            newContext.xrefChecker(new XRefChecker(context.ocf.get(), context.report, context.version));
            newContext.profile(EPUBProfile.makeOPFCompatible(context.profile, opfData, this.path, this.report));
        }
        this.context = newContext.build();
        this.initContentCheckerFactoryMap();
    }

    @Override
    public void runChecks() {
        OCFPackage ocf = this.context.ocf.get();
        XRefChecker xrefChecker = this.context.xrefChecker.get();
        if (!ocf.hasEntry(this.path)) {
            this.report.message(MessageId.PKG_020, EPUBLocation.create(ocf.getName()), this.path);
            return;
        }
        this.validate();
        if (!this.opfHandler.checkUniqueIdentExists()) {
            this.report.message(MessageId.OPF_030, EPUBLocation.create(this.path), this.opfHandler.getIdentId());
        }
        List<OPFItem> items = this.opfHandler.getItems();
        this.report.info(null, FeatureEnum.ITEMS_COUNT, Integer.toString(items.size()));
        for (OPFItem item : items) {
            xrefChecker.registerResource(item, new FallbackChecker().checkItemFallbacks(item, this.opfHandler, true), new FallbackChecker().checkImageFallbacks(item, this.opfHandler));
            this.report.info(item.getPath(), FeatureEnum.DECLARED_MIMETYPE, item.getMimeType());
        }
        this.checkGuide();
        this.checkBindings();
        for (OPFItem item : items) {
            if (item.getPath().matches("^[^:/?#]+://.*")) continue;
            this.checkItemContent(item);
        }
        xrefChecker.checkReferences();
    }

    protected void checkBindings() {
    }

    protected void checkGuide() {
        int refCount = this.opfHandler.getReferenceCount();
        for (int i = 0; i < refCount; ++i) {
            OPFReference ref = this.opfHandler.getReference(i);
            String itemPath = PathUtil.removeAnchor(ref.getHref());
            Optional<OPFItem> item = this.opfHandler.getItemByPath(itemPath);
            if (!item.isPresent()) {
                this.report.message(MessageId.OPF_031, EPUBLocation.create(this.path, ref.getLineNumber(), ref.getColumnNumber()), ref.getHref());
                continue;
            }
            if (OPFChecker.isBlessedItemType(item.get().getMimeType(), this.version) || OPFChecker.isDeprecatedBlessedItemType(item.get().getMimeType())) continue;
            this.report.message(MessageId.OPF_032, EPUBLocation.create(this.path, ref.getLineNumber(), ref.getColumnNumber()), ref.getHref());
        }
    }

    protected void initHandler() {
        this.opfHandler = new OPFHandler(this.context, this.opfParser);
    }

    public OPFHandler getOPFHandler() {
        return this.opfHandler;
    }

    @Override
    public boolean validate() {
        int fatalErrorsSoFar = this.report.getFatalErrorCount();
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        this.opfParser = new XMLParser(new ValidationContext.ValidationContextBuilder(this.context).mimetype("opf").build());
        this.initHandler();
        this.opfParser.addXMLHandler(this.opfHandler);
        for (XMLValidator validator : validatorMap.getValidators(this.context)) {
            this.opfParser.addValidator(validator);
        }
        this.opfParser.process();
        for (OPFItem item : this.opfHandler.getItems()) {
            if (!this.context.xrefChecker.isPresent()) {
                OCFFilenameChecker.checkCompatiblyEscaped(item.getPath(), this.report, this.version);
            }
            if (!item.equals(this.opfHandler.getItemByPath(item.getPath()).orNull())) {
                this.report.message(MessageId.OPF_074, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), item.getPath());
                continue;
            }
            this.checkItem(item, this.opfHandler);
        }
        if (!this.opfHandler.getSpineItems().isEmpty()) {
            boolean linearFound = false;
            int spineIndex = 0;
            for (OPFItem item : this.opfHandler.getSpineItems()) {
                this.checkSpineItem(item, this.opfHandler);
                if (item.isLinear()) {
                    linearFound = true;
                }
                this.report.info(item.getPath(), FeatureEnum.SPINE_INDEX, Integer.toString(spineIndex++));
            }
            if (!linearFound) {
                this.report.message(MessageId.OPF_033, EPUBLocation.create(this.path), new Object[0]);
            }
        }
        if (this.version == EPUBVersion.VERSION_2) {
            HashSet<OPFItem> seen = new HashSet<OPFItem>();
            for (OPFItem item : this.opfHandler.getSpineItems()) {
                if (seen.contains(item)) {
                    this.report.message(MessageId.OPF_034, EPUBLocation.create(this.path, item.getLineNumber(), item.getLineNumber()), item.getId());
                    continue;
                }
                seen.add(item);
            }
        }
        return fatalErrorsSoFar == this.report.getFatalErrorCount() && errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }

    public static boolean isBlessedItemType(String type, EPUBVersion version) {
        if (version == EPUBVersion.VERSION_2) {
            return type.equals("application/xhtml+xml") || type.equals("application/x-dtbook+xml");
        }
        return type.equals("application/xhtml+xml") || type.equals("image/svg+xml");
    }

    public static boolean isDeprecatedBlessedItemType(String type) {
        return type.equals("text/x-oeb1-document") || type.equals("text/html");
    }

    public static boolean isBlessedStyleType(String type) {
        return type.equals("text/css");
    }

    public static boolean isDeprecatedBlessedStyleType(String type) {
        return type.equals("text/x-oeb1-css");
    }

    public static boolean isBlessedImageType(String type) {
        return type.equals("image/gif") || type.equals("image/png") || type.equals("image/jpeg") || type.equals("image/svg+xml");
    }

    public static boolean isBlessedFontMimetype20(String mime) {
        return mime != null && (mime.startsWith("font/") || mime.startsWith("application/font") || mime.startsWith("application/x-font") || "application/vnd.ms-opentype".equals(mime));
    }

    protected void checkItem(OPFItem item, OPFHandler opfHandler) {
        Optional<OPFItem> fallbackStyleItem;
        Optional<OPFItem> fallbackItem;
        String mimeType = item.getMimeType();
        Optional<String> fallback = item.getFallback();
        if (mimeType.matches("[a-zA-Z0-9!#$&+-^_]+/[a-zA-Z0-9!#$&+-^_]+") && (OPFChecker.isDeprecatedBlessedItemType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType))) {
            if (opfHandler.getOpf20PackageFile() && mimeType.equals("text/html")) {
                this.report.message(MessageId.OPF_035, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber(), item.getId()), new Object[0]);
            } else if (opfHandler.getOpf12PackageFile() && mimeType.equals("text/html")) {
                this.report.message(MessageId.OPF_038, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber(), item.getId()), mimeType);
            } else if (opfHandler.getOpf20PackageFile()) {
                this.report.message(MessageId.OPF_037, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber(), item.getId()), mimeType);
            }
        }
        if (opfHandler.getOpf12PackageFile() && !fallback.isPresent()) {
            if (OPFChecker.isBlessedItemType(mimeType, this.version)) {
                this.report.message(MessageId.OPF_038, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber(), item.getId()), mimeType);
            } else if (OPFChecker.isBlessedStyleType(mimeType)) {
                this.report.message(MessageId.OPF_039, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber(), item.getId()), mimeType);
            }
        }
        if (fallback.isPresent() && !(fallbackItem = opfHandler.getItemById(fallback.get())).isPresent()) {
            this.report.message(MessageId.OPF_040, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber(), item.getId()), new Object[0]);
        }
        if (item.getFallbackStyle().isPresent() && !(fallbackStyleItem = opfHandler.getItemById(item.getFallbackStyle().get())).isPresent()) {
            this.report.message(MessageId.OPF_041, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber(), item.getId()), new Object[0]);
        }
    }

    protected void checkItemContent(OPFItem item) {
        String mimetype = item.getMimeType();
        ContentCheckerFactory checkerFactory = item.isNcx() ? NCXCheckerFactory.getInstance() : (item.isNav() ? NavCheckerFactory.getInstance() : this.contentCheckerFactoryMap.get(mimetype));
        if (checkerFactory == null) {
            checkerFactory = GenericContentCheckerFactory.getInstance();
        }
        if (checkerFactory != null) {
            ContentChecker checker = checkerFactory.newInstance(new ValidationContext.ValidationContextBuilder(this.context).path(item.getPath()).mimetype(mimetype).properties(item.getProperties()).build());
            checker.runChecks();
        }
    }

    protected void checkSpineItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType) || OPFChecker.isBlessedImageType(mimeType)) {
            this.report.message(MessageId.OPF_042, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), mimeType);
        } else if (!(OPFChecker.isBlessedItemType(mimeType, this.version) || OPFChecker.isDeprecatedBlessedItemType(mimeType) || item.getFallback().isPresent())) {
            this.report.message(MessageId.OPF_043, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), mimeType);
        } else if (!(OPFChecker.isBlessedItemType(mimeType, this.version) || OPFChecker.isDeprecatedBlessedItemType(mimeType) || new FallbackChecker().checkItemFallbacks(item, opfHandler, true))) {
            this.report.message(MessageId.OPF_044, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), mimeType);
        }
    }

    class FallbackChecker {
        private final Set<String> checked = new HashSet<String>();

        boolean checkItemFallbacks(OPFItem item, OPFHandler opfHandler, boolean checkFallbackStyle) {
            String fallbackStyle;
            Optional<OPFItem> fallbackStyleItem;
            String mimeType;
            if (item.getFallback().isPresent()) {
                String fallback = item.getFallback().get();
                if (this.checked.contains(fallback)) {
                    OPFChecker.this.report.message(MessageId.OPF_045, EPUBLocation.create(OPFChecker.this.path, item.getLineNumber(), item.getColumnNumber()), new Object[0]);
                    return false;
                }
                this.checked.add(fallback);
                Optional<OPFItem> fallbackItem = opfHandler.getItemById(fallback);
                if (fallbackItem.isPresent()) {
                    mimeType = fallbackItem.get().getMimeType();
                    if (OPFChecker.isBlessedItemType(mimeType, OPFChecker.this.version) || OPFChecker.isDeprecatedBlessedItemType(mimeType)) {
                        return true;
                    }
                    if (this.checkItemFallbacks(fallbackItem.get(), opfHandler, checkFallbackStyle)) {
                        return true;
                    }
                }
            }
            if (!checkFallbackStyle) {
                return false;
            }
            if (item.getFallbackStyle().isPresent() && (fallbackStyleItem = opfHandler.getItemById(fallbackStyle = item.getFallbackStyle().get())).isPresent()) {
                mimeType = fallbackStyleItem.get().getMimeType();
                return OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType);
            }
            return false;
        }

        boolean checkImageFallbacks(OPFItem item, OPFHandler opfHandler) {
            if (item.getFallback().isPresent()) {
                String fallback = item.getFallback().get();
                if (this.checked.contains(fallback)) {
                    OPFChecker.this.report.message(MessageId.OPF_045, EPUBLocation.create(OPFChecker.this.path, item.getLineNumber(), item.getColumnNumber()), new Object[0]);
                    return false;
                }
                this.checked.add(fallback);
                Optional<OPFItem> fallbackItem = opfHandler.getItemById(fallback);
                if (fallbackItem.isPresent()) {
                    String mimeType = fallbackItem.get().getMimeType();
                    if (OPFChecker.isBlessedImageType(mimeType)) {
                        return true;
                    }
                    if (this.checkImageFallbacks(fallbackItem.get(), opfHandler)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

