
/* #########################################################################
 * [2016-08-11 14:28:15.230000] THIS FILE IS AUTOGENERATED - DO NOT EDIT!
 * ######################################################################### */
#ifndef ___DROPBOT_DX__COMMAND_PROCESSOR___
#define ___DROPBOT_DX__COMMAND_PROCESSOR___

#include "CArrayDefs.h"
#include "Commands.h"



namespace dropbot_dx {

template <typename Obj>
class CommandProcessor {
  /* # `CommandProcessor` #
   *
   * Each call to this functor processes a single command.
   *
   * All arguments are passed by reference, such that they may be used to form
   * a response.  If the integer return value of the call is zero, the call is
   * assumed to have no response required.  Otherwise, the arguments contain
   * must contain response values. */
protected:
  Obj &obj_;
public:
  CommandProcessor(Obj &obj) : obj_(obj) {}

  UInt8Array process_command(UInt8Array request_arr, UInt8Array buffer) {
    /* ## Call operator ##
     *
     * Arguments:
     *
     *  - `request_arr`: Serialized command request structure array,
     *  - `buffer`: Buffer array (available for writing output). */

    UInt8Array result;
    uint16_t &command = *reinterpret_cast<uint16_t *>(&request_arr.data[0]);

    // Interpret first byte of request as command code.
    switch (command) {

        case CMD_BASE_NODE_SOFTWARE_VERSION:
          {
            /* Cast buffer as request. */
    
    
            BaseNodeSoftwareVersionResponse response;

            response.result =
            obj_.base_node_software_version();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_PACKAGE_NAME:
          {
            /* Cast buffer as request. */
    
    
            PackageNameResponse response;

            response.result =
            obj_.package_name();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_DISPLAY_NAME:
          {
            /* Cast buffer as request. */
    
    
            DisplayNameResponse response;

            response.result =
            obj_.display_name();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MANUFACTURER:
          {
            /* Cast buffer as request. */
    
    
            ManufacturerResponse response;

            response.result =
            obj_.manufacturer();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_SOFTWARE_VERSION:
          {
            /* Cast buffer as request. */
    
    
            SoftwareVersionResponse response;

            response.result =
            obj_.software_version();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_URL:
          {
            /* Cast buffer as request. */
    
    
            UrlResponse response;

            response.result =
            obj_.url();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MICROSECONDS:
          {
            /* Cast buffer as request. */
    
    
            MicrosecondsResponse response;

            response.result =
            obj_.microseconds();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MicrosecondsResponse &output = *(reinterpret_cast
                                                 <MicrosecondsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_MILLISECONDS:
          {
            /* Cast buffer as request. */
    
    
            MillisecondsResponse response;

            response.result =
            obj_.milliseconds();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MillisecondsResponse &output = *(reinterpret_cast
                                                 <MillisecondsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DELAY_US:
          {
            /* Cast buffer as request. */
    
            DelayUsRequest &request = *(reinterpret_cast
                                          <DelayUsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.delay_us(request.us);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DELAY_MS:
          {
            /* Cast buffer as request. */
    
            DelayMsRequest &request = *(reinterpret_cast
                                          <DelayMsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.delay_ms(request.ms);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_RAM_FREE:
          {
            /* Cast buffer as request. */
    
    
            RamFreeResponse response;

            response.result =
            obj_.ram_free();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            RamFreeResponse &output = *(reinterpret_cast
                                                 <RamFreeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_PIN_MODE:
          {
            /* Cast buffer as request. */
    
            PinModeRequest &request = *(reinterpret_cast
                                          <PinModeRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.pin_mode(request.pin, request.mode);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DIGITAL_READ:
          {
            /* Cast buffer as request. */
    
            DigitalReadRequest &request = *(reinterpret_cast
                                          <DigitalReadRequest *>
                                          (&request_arr.data[2]));
    
    
            DigitalReadResponse response;

            response.result =
            obj_.digital_read(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DigitalReadResponse &output = *(reinterpret_cast
                                                 <DigitalReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DIGITAL_WRITE:
          {
            /* Cast buffer as request. */
    
            DigitalWriteRequest &request = *(reinterpret_cast
                                          <DigitalWriteRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.digital_write(request.pin, request.value);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ANALOG_READ:
          {
            /* Cast buffer as request. */
    
            AnalogReadRequest &request = *(reinterpret_cast
                                          <AnalogReadRequest *>
                                          (&request_arr.data[2]));
    
    
            AnalogReadResponse response;

            response.result =
            obj_.analog_read(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AnalogReadResponse &output = *(reinterpret_cast
                                                 <AnalogReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ANALOG_WRITE:
          {
            /* Cast buffer as request. */
    
            AnalogWriteRequest &request = *(reinterpret_cast
                                          <AnalogWriteRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.analog_write(request.pin, request.value);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ARRAY_LENGTH:
          {
            /* Cast buffer as request. */
    
            ArrayLengthRequest &request = *(reinterpret_cast
                                          <ArrayLengthRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.array.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.array.data);
            ArrayLengthResponse response;

            response.result =
            obj_.array_length(request.array);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ArrayLengthResponse &output = *(reinterpret_cast
                                                 <ArrayLengthResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ECHO_ARRAY:
          {
            /* Cast buffer as request. */
    
            EchoArrayRequest &request = *(reinterpret_cast
                                          <EchoArrayRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.array.data = (uint32_t *)((uint8_t *)&request + (unsigned int)request.array.data);
            EchoArrayResponse response;

            response.result =
            obj_.echo_array(request.array);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_STR_ECHO:
          {
            /* Cast buffer as request. */
    
            StrEchoRequest &request = *(reinterpret_cast
                                          <StrEchoRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.msg.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.msg.data);
            StrEchoResponse response;

            response.result =
            obj_.str_echo(request.msg);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MAX_SERIAL_PAYLOAD_SIZE:
          {
            /* Cast buffer as request. */
    
    
            MaxSerialPayloadSizeResponse response;

            response.result =
            obj_.max_serial_payload_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MaxSerialPayloadSizeResponse &output = *(reinterpret_cast
                                                 <MaxSerialPayloadSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_UPDATE_EEPROM_BLOCK:
          {
            /* Cast buffer as request. */
    
            UpdateEepromBlockRequest &request = *(reinterpret_cast
                                          <UpdateEepromBlockRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.data.data);
            obj_.update_eeprom_block(request.address, request.data);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_READ_EEPROM_BLOCK:
          {
            /* Cast buffer as request. */
    
            ReadEepromBlockRequest &request = *(reinterpret_cast
                                          <ReadEepromBlockRequest *>
                                          (&request_arr.data[2]));
    
    
            ReadEepromBlockResponse response;

            response.result =
            obj_.read_eeprom_block(request.address, request.n);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_EEPROM_E2END:
          {
            /* Cast buffer as request. */
    
    
            EepromE2endResponse response;

            response.result =
            obj_.eeprom_e2end();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            EepromE2endResponse &output = *(reinterpret_cast
                                                 <EepromE2endResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SET_CLOCK:
          {
            /* Cast buffer as request. */
    
            SetClockRequest &request = *(reinterpret_cast
                                          <SetClockRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.set_clock(request.frequency);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SET_I2C_ADDRESS:
          {
            /* Cast buffer as request. */
    
            SetI2cAddressRequest &request = *(reinterpret_cast
                                          <SetI2cAddressRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.set_i2c_address(request.address);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_I2C_ADDRESS:
          {
            /* Cast buffer as request. */
    
    
            I2cAddressResponse response;

            response.result =
            obj_.i2c_address();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cAddressResponse &output = *(reinterpret_cast
                                                 <I2cAddressResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_BUFFER_SIZE:
          {
            /* Cast buffer as request. */
    
    
            I2cBufferSizeResponse response;

            response.result =
            obj_.i2c_buffer_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cBufferSizeResponse &output = *(reinterpret_cast
                                                 <I2cBufferSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_SCAN:
          {
            /* Cast buffer as request. */
    
    
            I2cScanResponse response;

            response.result =
            obj_.i2c_scan();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_AVAILABLE:
          {
            /* Cast buffer as request. */
    
    
            I2cAvailableResponse response;

            response.result =
            obj_.i2c_available();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cAvailableResponse &output = *(reinterpret_cast
                                                 <I2cAvailableResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_READ_BYTE:
          {
            /* Cast buffer as request. */
    
    
            I2cReadByteResponse response;

            response.result =
            obj_.i2c_read_byte();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cReadByteResponse &output = *(reinterpret_cast
                                                 <I2cReadByteResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_REQUEST_FROM:
          {
            /* Cast buffer as request. */
    
            I2cRequestFromRequest &request = *(reinterpret_cast
                                          <I2cRequestFromRequest *>
                                          (&request_arr.data[2]));
    
    
            I2cRequestFromResponse response;

            response.result =
            obj_.i2c_request_from(request.address, request.n_bytes_to_read);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cRequestFromResponse &output = *(reinterpret_cast
                                                 <I2cRequestFromResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_READ:
          {
            /* Cast buffer as request. */
    
            I2cReadRequest &request = *(reinterpret_cast
                                          <I2cReadRequest *>
                                          (&request_arr.data[2]));
    
    
            I2cReadResponse response;

            response.result =
            obj_.i2c_read(request.address, request.n_bytes_to_read);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_WRITE:
          {
            /* Cast buffer as request. */
    
            I2cWriteRequest &request = *(reinterpret_cast
                                          <I2cWriteRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.data.data);
            obj_.i2c_write(request.address, request.data);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_I2C_ENABLE_BROADCAST:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_enable_broadcast();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_I2C_DISABLE_BROADCAST:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_disable_broadcast();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MAX_I2C_PAYLOAD_SIZE:
          {
            /* Cast buffer as request. */
    
    
            MaxI2cPayloadSizeResponse response;

            response.result =
            obj_.max_i2c_payload_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MaxI2cPayloadSizeResponse &output = *(reinterpret_cast
                                                 <MaxI2cPayloadSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_REQUEST:
          {
            /* Cast buffer as request. */
    
            I2cRequestRequest &request = *(reinterpret_cast
                                          <I2cRequestRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.data.data);
            I2cRequestResponse response;

            response.result =
            obj_.i2c_request(request.address, request.data);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_PACKET_RESET:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_packet_reset();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_LOAD_CONFIG:
          {
            /* Cast buffer as request. */
    
    
            obj_.load_config();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SAVE_CONFIG:
          {
            /* Cast buffer as request. */
    
    
            obj_.save_config();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_RESET_CONFIG:
          {
            /* Cast buffer as request. */
    
    
            obj_.reset_config();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERIALIZE_CONFIG:
          {
            /* Cast buffer as request. */
    
    
            SerializeConfigResponse response;

            response.result =
            obj_.serialize_config();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_CONFIG:
          {
            /* Cast buffer as request. */
    
            UpdateConfigRequest &request = *(reinterpret_cast
                                          <UpdateConfigRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized.data);
            UpdateConfigResponse response;

            response.result =
            obj_.update_config(request.serialized);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateConfigResponse &output = *(reinterpret_cast
                                                 <UpdateConfigResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_CONFIG_SERIAL_NUMBER_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnConfigSerialNumberChangedRequest &request = *(reinterpret_cast
                                          <OnConfigSerialNumberChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnConfigSerialNumberChangedResponse response;

            response.result =
            obj_.on_config_serial_number_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnConfigSerialNumberChangedResponse &output = *(reinterpret_cast
                                                 <OnConfigSerialNumberChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_CONFIG_BAUD_RATE_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnConfigBaudRateChangedRequest &request = *(reinterpret_cast
                                          <OnConfigBaudRateChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnConfigBaudRateChangedResponse response;

            response.result =
            obj_.on_config_baud_rate_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnConfigBaudRateChangedResponse &output = *(reinterpret_cast
                                                 <OnConfigBaudRateChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_CONFIG_I2C_ADDRESS_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnConfigI2cAddressChangedRequest &request = *(reinterpret_cast
                                          <OnConfigI2cAddressChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnConfigI2cAddressChangedResponse response;

            response.result =
            obj_.on_config_i2c_address_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnConfigI2cAddressChangedResponse &output = *(reinterpret_cast
                                                 <OnConfigI2cAddressChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_RESET_STATE:
          {
            /* Cast buffer as request. */
    
    
            obj_.reset_state();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERIALIZE_STATE:
          {
            /* Cast buffer as request. */
    
    
            SerializeStateResponse response;

            response.result =
            obj_.serialize_state();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_STATE:
          {
            /* Cast buffer as request. */
    
            UpdateStateRequest &request = *(reinterpret_cast
                                          <UpdateStateRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized.data);
            UpdateStateResponse response;

            response.result =
            obj_.update_state(request.serialized);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateStateResponse &output = *(reinterpret_cast
                                                 <UpdateStateResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_TIMER_CALLBACK:
          {
            /* Cast buffer as request. */
    
    
            obj_.timer_callback();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_GET_BUFFER:
          {
            /* Cast buffer as request. */
    
    
            GetBufferResponse response;

            response.result =
            obj_.get_buffer();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_BEGIN:
          {
            /* Cast buffer as request. */
    
    
            obj_.begin();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERVO_READ:
          {
            /* Cast buffer as request. */
    
    
            ServoReadResponse response;

            response.result =
            obj_.servo_read();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ServoReadResponse &output = *(reinterpret_cast
                                                 <ServoReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SERVO_WRITE:
          {
            /* Cast buffer as request. */
    
            ServoWriteRequest &request = *(reinterpret_cast
                                          <ServoWriteRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.servo_write(request.angle);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERVO_WRITE_MICROSECONDS:
          {
            /* Cast buffer as request. */
    
            ServoWriteMicrosecondsRequest &request = *(reinterpret_cast
                                          <ServoWriteMicrosecondsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.servo_write_microseconds(request.us);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERVO_ATTACHED:
          {
            /* Cast buffer as request. */
    
    
            ServoAttachedResponse response;

            response.result =
            obj_.servo_attached();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ServoAttachedResponse &output = *(reinterpret_cast
                                                 <ServoAttachedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_NUMBER_OF_CHANNELS:
          {
            /* Cast buffer as request. */
    
    
            NumberOfChannelsResponse response;

            response.result =
            obj_.number_of_channels();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            NumberOfChannelsResponse &output = *(reinterpret_cast
                                                 <NumberOfChannelsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SET_NUMBER_OF_CHANNELS:
          {
            /* Cast buffer as request. */
    
            SetNumberOfChannelsRequest &request = *(reinterpret_cast
                                          <SetNumberOfChannelsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.set_number_of_channels(request.number_of_channels);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_HARDWARE_VERSION:
          {
            /* Cast buffer as request. */
    
    
            HardwareVersionResponse response;

            response.result =
            obj_.hardware_version();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD__UUID:
          {
            /* Cast buffer as request. */
    
    
            _UuidResponse response;

            response.result =
            obj_._uuid();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_STATE_OF_CHANNELS:
          {
            /* Cast buffer as request. */
    
    
            StateOfChannelsResponse response;

            response.result =
            obj_.state_of_channels();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_SET_ID:
          {
            /* Cast buffer as request. */
    
            SetIdRequest &request = *(reinterpret_cast
                                          <SetIdRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.id.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.id.data);
            SetIdResponse response;

            response.result =
            obj_.set_id(request.id);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            SetIdResponse &output = *(reinterpret_cast
                                                 <SetIdResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SET_STATE_OF_CHANNELS:
          {
            /* Cast buffer as request. */
    
            SetStateOfChannelsRequest &request = *(reinterpret_cast
                                          <SetStateOfChannelsRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.channel_states.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.channel_states.data);
            SetStateOfChannelsResponse response;

            response.result =
            obj_.set_state_of_channels(request.channel_states);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            SetStateOfChannelsResponse &output = *(reinterpret_cast
                                                 <SetStateOfChannelsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_STATE_FREQUENCY_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnStateFrequencyChangedRequest &request = *(reinterpret_cast
                                          <OnStateFrequencyChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnStateFrequencyChangedResponse response;

            response.result =
            obj_.on_state_frequency_changed(request.frequency);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnStateFrequencyChangedResponse &output = *(reinterpret_cast
                                                 <OnStateFrequencyChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD__SET_VOLTAGE:
          {
            /* Cast buffer as request. */
    
            _SetVoltageRequest &request = *(reinterpret_cast
                                          <_SetVoltageRequest *>
                                          (&request_arr.data[2]));
    
    
            _SetVoltageResponse response;

            response.result =
            obj_._set_voltage(request.voltage);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            _SetVoltageResponse &output = *(reinterpret_cast
                                                 <_SetVoltageResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_STATE_VOLTAGE_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnStateVoltageChangedRequest &request = *(reinterpret_cast
                                          <OnStateVoltageChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnStateVoltageChangedResponse response;

            response.result =
            obj_.on_state_voltage_changed(request.voltage);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnStateVoltageChangedResponse &output = *(reinterpret_cast
                                                 <OnStateVoltageChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_STATE_HV_OUTPUT_ENABLED_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnStateHvOutputEnabledChangedRequest &request = *(reinterpret_cast
                                          <OnStateHvOutputEnabledChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnStateHvOutputEnabledChangedResponse response;

            response.result =
            obj_.on_state_hv_output_enabled_changed(request.value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnStateHvOutputEnabledChangedResponse &output = *(reinterpret_cast
                                                 <OnStateHvOutputEnabledChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_STATE_HV_OUTPUT_SELECTED_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnStateHvOutputSelectedChangedRequest &request = *(reinterpret_cast
                                          <OnStateHvOutputSelectedChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnStateHvOutputSelectedChangedResponse response;

            response.result =
            obj_.on_state_hv_output_selected_changed(request.value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnStateHvOutputSelectedChangedResponse &output = *(reinterpret_cast
                                                 <OnStateHvOutputSelectedChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_STATE_MAGNET_ENGAGED_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnStateMagnetEngagedChangedRequest &request = *(reinterpret_cast
                                          <OnStateMagnetEngagedChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnStateMagnetEngagedChangedResponse response;

            response.result =
            obj_.on_state_magnet_engaged_changed(request.value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnStateMagnetEngagedChangedResponse &output = *(reinterpret_cast
                                                 <OnStateMagnetEngagedChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_CONFIG_LIGHT_INTENSITY_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnConfigLightIntensityChangedRequest &request = *(reinterpret_cast
                                          <OnConfigLightIntensityChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnConfigLightIntensityChangedResponse response;

            response.result =
            obj_.on_config_light_intensity_changed(request.value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnConfigLightIntensityChangedResponse &output = *(reinterpret_cast
                                                 <OnConfigLightIntensityChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_STATE_LIGHT_ENABLED_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnStateLightEnabledChangedRequest &request = *(reinterpret_cast
                                          <OnStateLightEnabledChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnStateLightEnabledChangedResponse response;

            response.result =
            obj_.on_state_light_enabled_changed(request.value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnStateLightEnabledChangedResponse &output = *(reinterpret_cast
                                                 <OnStateLightEnabledChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_MAGNET_ENGAGED:
          {
            /* Cast buffer as request. */
    
    
            MagnetEngagedResponse response;

            response.result =
            obj_.magnet_engaged();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MagnetEngagedResponse &output = *(reinterpret_cast
                                                 <MagnetEngagedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD__INITIALIZE_SWITCHING_BOARDS:
          {
            /* Cast buffer as request. */
    
    
            obj_._initialize_switching_boards();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD__MAGNET_ENGAGE:
          {
            /* Cast buffer as request. */
    
    
            obj_._magnet_engage();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD__MAGNET_DISENGAGE:
          {
            /* Cast buffer as request. */
    
    
            obj_._magnet_disengage();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_TEST:
          {
            /* Cast buffer as request. */
    
            TestRequest &request = *(reinterpret_cast
                                          <TestRequest *>
                                          (&request_arr.data[2]));
    
    
            TestResponse response;

            response.result =
            obj_.test(request.a);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            TestResponse &output = *(reinterpret_cast
                                                 <TestResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DMA_TCD:
          {
            /* Cast buffer as request. */
    
    
            DmaTcdResponse response;

            response.result =
            obj_.dma_tcd();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_DMA_START:
          {
            /* Cast buffer as request. */
    
            DmaStartRequest &request = *(reinterpret_cast
                                          <DmaStartRequest *>
                                          (&request_arr.data[2]));
    
    
            DmaStartResponse response;

            response.result =
            obj_.dma_start(request.buffer_size);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DmaStartResponse &output = *(reinterpret_cast
                                                 <DmaStartResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DMA_STOP:
          {
            /* Cast buffer as request. */
    
    
            obj_.dma_stop();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DMA_READ:
          {
            /* Cast buffer as request. */
    
    
            DmaReadResponse response;

            response.result =
            obj_.dma_read();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DmaReadResponse &output = *(reinterpret_cast
                                                 <DmaReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DMA_FULL:
          {
            /* Cast buffer as request. */
    
    
            DmaFullResponse response;

            response.result =
            obj_.dma_full();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DmaFullResponse &output = *(reinterpret_cast
                                                 <DmaFullResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DMA_EMPTY:
          {
            /* Cast buffer as request. */
    
    
            DmaEmptyResponse response;

            response.result =
            obj_.dma_empty();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DmaEmptyResponse &output = *(reinterpret_cast
                                                 <DmaEmptyResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ADC_BUFFER:
          {
            /* Cast buffer as request. */
    
    
            AdcBufferResponse response;

            response.result =
            obj_.adc_buffer();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_SETREFERENCE:
          {
            /* Cast buffer as request. */
    
            SetreferenceRequest &request = *(reinterpret_cast
                                          <SetreferenceRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.setReference(request.type, request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ON_TICK:
          {
            /* Cast buffer as request. */
    
    
            obj_.on_tick();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_V__SYST_CVR:
          {
            /* Cast buffer as request. */
    
    
            V_SystCvrResponse response;

            response.result =
            obj_.V__SYST_CVR();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            V_SystCvrResponse &output = *(reinterpret_cast
                                                 <V_SystCvrResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_V__SCB_ICSR:
          {
            /* Cast buffer as request. */
    
    
            V_ScbIcsrResponse response;

            response.result =
            obj_.V__SCB_ICSR();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            V_ScbIcsrResponse &output = *(reinterpret_cast
                                                 <V_ScbIcsrResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_D__F_CPU:
          {
            /* Cast buffer as request. */
    
    
            D_FCpuResponse response;

            response.result =
            obj_.D__F_CPU();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            D_FCpuResponse &output = *(reinterpret_cast
                                                 <D_FCpuResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_D__F_BUS:
          {
            /* Cast buffer as request. */
    
    
            D_FBusResponse response;

            response.result =
            obj_.D__F_BUS();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            D_FBusResponse &output = *(reinterpret_cast
                                                 <D_FBusResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_ADC_DONE:
          {
            /* Cast buffer as request. */
    
    
            obj_.on_adc_done();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ADC_TIMESTAMP_US:
          {
            /* Cast buffer as request. */
    
    
            AdcTimestampUsResponse response;

            response.result =
            obj_.adc_timestamp_us();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AdcTimestampUsResponse &output = *(reinterpret_cast
                                                 <AdcTimestampUsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_COMPUTE_TIMESTAMP_US:
          {
            /* Cast buffer as request. */
    
            ComputeTimestampUsRequest &request = *(reinterpret_cast
                                          <ComputeTimestampUsRequest *>
                                          (&request_arr.data[2]));
    
    
            ComputeTimestampUsResponse response;

            response.result =
            obj_.compute_timestamp_us(request._SYST_CVR, request._millis);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ComputeTimestampUsResponse &output = *(reinterpret_cast
                                                 <ComputeTimestampUsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ADC_PERIOD_US:
          {
            /* Cast buffer as request. */
    
    
            AdcPeriodUsResponse response;

            response.result =
            obj_.adc_period_us();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AdcPeriodUsResponse &output = *(reinterpret_cast
                                                 <AdcPeriodUsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SETRESOLUTION:
          {
            /* Cast buffer as request. */
    
            SetresolutionRequest &request = *(reinterpret_cast
                                          <SetresolutionRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.setResolution(request.bits, request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_GETRESOLUTION:
          {
            /* Cast buffer as request. */
    
            GetresolutionRequest &request = *(reinterpret_cast
                                          <GetresolutionRequest *>
                                          (&request_arr.data[2]));
    
    
            GetresolutionResponse response;

            response.result =
            obj_.getResolution(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            GetresolutionResponse &output = *(reinterpret_cast
                                                 <GetresolutionResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_GETMAXVALUE:
          {
            /* Cast buffer as request. */
    
            GetmaxvalueRequest &request = *(reinterpret_cast
                                          <GetmaxvalueRequest *>
                                          (&request_arr.data[2]));
    
    
            GetmaxvalueResponse response;

            response.result =
            obj_.getMaxValue(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            GetmaxvalueResponse &output = *(reinterpret_cast
                                                 <GetmaxvalueResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SETCONVERSIONSPEED:
          {
            /* Cast buffer as request. */
    
            SetconversionspeedRequest &request = *(reinterpret_cast
                                          <SetconversionspeedRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.setConversionSpeed(request.speed, request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SETSAMPLINGSPEED:
          {
            /* Cast buffer as request. */
    
            SetsamplingspeedRequest &request = *(reinterpret_cast
                                          <SetsamplingspeedRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.setSamplingSpeed(request.speed, request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_BENCHMARK_FLOPS:
          {
            /* Cast buffer as request. */
    
            BenchmarkFlopsRequest &request = *(reinterpret_cast
                                          <BenchmarkFlopsRequest *>
                                          (&request_arr.data[2]));
    
    
            BenchmarkFlopsResponse response;

            response.result =
            obj_.benchmark_flops(request.N);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            BenchmarkFlopsResponse &output = *(reinterpret_cast
                                                 <BenchmarkFlopsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_BENCHMARK_IOPS:
          {
            /* Cast buffer as request. */
    
            BenchmarkIopsRequest &request = *(reinterpret_cast
                                          <BenchmarkIopsRequest *>
                                          (&request_arr.data[2]));
    
    
            BenchmarkIopsResponse response;

            response.result =
            obj_.benchmark_iops(request.N);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            BenchmarkIopsResponse &output = *(reinterpret_cast
                                                 <BenchmarkIopsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SETAVERAGING:
          {
            /* Cast buffer as request. */
    
            SetaveragingRequest &request = *(reinterpret_cast
                                          <SetaveragingRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.setAveraging(request.num, request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ENABLEINTERRUPTS:
          {
            /* Cast buffer as request. */
    
            EnableinterruptsRequest &request = *(reinterpret_cast
                                          <EnableinterruptsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.enableInterrupts(request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DISABLEINTERRUPTS:
          {
            /* Cast buffer as request. */
    
            DisableinterruptsRequest &request = *(reinterpret_cast
                                          <DisableinterruptsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.disableInterrupts(request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ENABLEDMA:
          {
            /* Cast buffer as request. */
    
            EnabledmaRequest &request = *(reinterpret_cast
                                          <EnabledmaRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.enableDMA(request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DISABLEDMA:
          {
            /* Cast buffer as request. */
    
            DisabledmaRequest &request = *(reinterpret_cast
                                          <DisabledmaRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.disableDMA(request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ENABLECOMPARE:
          {
            /* Cast buffer as request. */
    
            EnablecompareRequest &request = *(reinterpret_cast
                                          <EnablecompareRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.enableCompare(request.compValue, request.greaterThan, request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ENABLECOMPARERANGE:
          {
            /* Cast buffer as request. */
    
            EnablecomparerangeRequest &request = *(reinterpret_cast
                                          <EnablecomparerangeRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.enableCompareRange(request.lowerLimit, request.upperLimit, request.insideRange, request.inclusive, request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DISABLECOMPARE:
          {
            /* Cast buffer as request. */
    
            DisablecompareRequest &request = *(reinterpret_cast
                                          <DisablecompareRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.disableCompare(request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ENABLEPGA:
          {
            /* Cast buffer as request. */
    
            EnablepgaRequest &request = *(reinterpret_cast
                                          <EnablepgaRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.enablePGA(request.gain, request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_GETPGA:
          {
            /* Cast buffer as request. */
    
            GetpgaRequest &request = *(reinterpret_cast
                                          <GetpgaRequest *>
                                          (&request_arr.data[2]));
    
    
            GetpgaResponse response;

            response.result =
            obj_.getPGA(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            GetpgaResponse &output = *(reinterpret_cast
                                                 <GetpgaResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DISABLEPGA:
          {
            /* Cast buffer as request. */
    
            DisablepgaRequest &request = *(reinterpret_cast
                                          <DisablepgaRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.disablePGA(request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ISCONVERTING:
          {
            /* Cast buffer as request. */
    
            IsconvertingRequest &request = *(reinterpret_cast
                                          <IsconvertingRequest *>
                                          (&request_arr.data[2]));
    
    
            IsconvertingResponse response;

            response.result =
            obj_.isConverting(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            IsconvertingResponse &output = *(reinterpret_cast
                                                 <IsconvertingResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ISCOMPLETE:
          {
            /* Cast buffer as request. */
    
            IscompleteRequest &request = *(reinterpret_cast
                                          <IscompleteRequest *>
                                          (&request_arr.data[2]));
    
    
            IscompleteResponse response;

            response.result =
            obj_.isComplete(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            IscompleteResponse &output = *(reinterpret_cast
                                                 <IscompleteResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ISDIFFERENTIAL:
          {
            /* Cast buffer as request. */
    
            IsdifferentialRequest &request = *(reinterpret_cast
                                          <IsdifferentialRequest *>
                                          (&request_arr.data[2]));
    
    
            IsdifferentialResponse response;

            response.result =
            obj_.isDifferential(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            IsdifferentialResponse &output = *(reinterpret_cast
                                                 <IsdifferentialResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ISCONTINUOUS:
          {
            /* Cast buffer as request. */
    
            IscontinuousRequest &request = *(reinterpret_cast
                                          <IscontinuousRequest *>
                                          (&request_arr.data[2]));
    
    
            IscontinuousResponse response;

            response.result =
            obj_.isContinuous(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            IscontinuousResponse &output = *(reinterpret_cast
                                                 <IscontinuousResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ANALOGREAD:
          {
            /* Cast buffer as request. */
    
            AnalogreadRequest &request = *(reinterpret_cast
                                          <AnalogreadRequest *>
                                          (&request_arr.data[2]));
    
    
            AnalogreadResponse response;

            response.result =
            obj_.analogRead(request.pin, request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AnalogreadResponse &output = *(reinterpret_cast
                                                 <AnalogreadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ANALOGREADDIFFERENTIAL:
          {
            /* Cast buffer as request. */
    
            AnalogreaddifferentialRequest &request = *(reinterpret_cast
                                          <AnalogreaddifferentialRequest *>
                                          (&request_arr.data[2]));
    
    
            AnalogreaddifferentialResponse response;

            response.result =
            obj_.analogReadDifferential(request.pinP, request.pinN, request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AnalogreaddifferentialResponse &output = *(reinterpret_cast
                                                 <AnalogreaddifferentialResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_STARTSINGLEREAD:
          {
            /* Cast buffer as request. */
    
            StartsinglereadRequest &request = *(reinterpret_cast
                                          <StartsinglereadRequest *>
                                          (&request_arr.data[2]));
    
    
            StartsinglereadResponse response;

            response.result =
            obj_.startSingleRead(request.pin, request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            StartsinglereadResponse &output = *(reinterpret_cast
                                                 <StartsinglereadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_STARTSINGLEDIFFERENTIAL:
          {
            /* Cast buffer as request. */
    
            StartsingledifferentialRequest &request = *(reinterpret_cast
                                          <StartsingledifferentialRequest *>
                                          (&request_arr.data[2]));
    
    
            StartsingledifferentialResponse response;

            response.result =
            obj_.startSingleDifferential(request.pinP, request.pinN, request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            StartsingledifferentialResponse &output = *(reinterpret_cast
                                                 <StartsingledifferentialResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_READSINGLE:
          {
            /* Cast buffer as request. */
    
            ReadsingleRequest &request = *(reinterpret_cast
                                          <ReadsingleRequest *>
                                          (&request_arr.data[2]));
    
    
            ReadsingleResponse response;

            response.result =
            obj_.readSingle(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ReadsingleResponse &output = *(reinterpret_cast
                                                 <ReadsingleResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_STARTCONTINUOUS:
          {
            /* Cast buffer as request. */
    
            StartcontinuousRequest &request = *(reinterpret_cast
                                          <StartcontinuousRequest *>
                                          (&request_arr.data[2]));
    
    
            StartcontinuousResponse response;

            response.result =
            obj_.startContinuous(request.pin, request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            StartcontinuousResponse &output = *(reinterpret_cast
                                                 <StartcontinuousResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_STARTCONTINUOUSDIFFERENTIAL:
          {
            /* Cast buffer as request. */
    
            StartcontinuousdifferentialRequest &request = *(reinterpret_cast
                                          <StartcontinuousdifferentialRequest *>
                                          (&request_arr.data[2]));
    
    
            StartcontinuousdifferentialResponse response;

            response.result =
            obj_.startContinuousDifferential(request.pinP, request.pinN, request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            StartcontinuousdifferentialResponse &output = *(reinterpret_cast
                                                 <StartcontinuousdifferentialResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ANALOGREADCONTINUOUS:
          {
            /* Cast buffer as request. */
    
            AnalogreadcontinuousRequest &request = *(reinterpret_cast
                                          <AnalogreadcontinuousRequest *>
                                          (&request_arr.data[2]));
    
    
            AnalogreadcontinuousResponse response;

            response.result =
            obj_.analogReadContinuous(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AnalogreadcontinuousResponse &output = *(reinterpret_cast
                                                 <AnalogreadcontinuousResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_STOPCONTINUOUS:
          {
            /* Cast buffer as request. */
    
            StopcontinuousRequest &request = *(reinterpret_cast
                                          <StopcontinuousRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.stopContinuous(request.adc_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ANALOGSYNCHRONIZEDREAD:
          {
            /* Cast buffer as request. */
    
            AnalogsynchronizedreadRequest &request = *(reinterpret_cast
                                          <AnalogsynchronizedreadRequest *>
                                          (&request_arr.data[2]));
    
    
            AnalogsynchronizedreadResponse response;

            response.result =
            obj_.analogSynchronizedRead(request.pin0, request.pin1);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_ANALOG_INPUT_TO_DIGITAL_PIN:
          {
            /* Cast buffer as request. */
    
            AnalogInputToDigitalPinRequest &request = *(reinterpret_cast
                                          <AnalogInputToDigitalPinRequest *>
                                          (&request_arr.data[2]));
    
    
            AnalogInputToDigitalPinResponse response;

            response.result =
            obj_.analog_input_to_digital_pin(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AnalogInputToDigitalPinResponse &output = *(reinterpret_cast
                                                 <AnalogInputToDigitalPinResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DIGITAL_PIN_HAS_PWM:
          {
            /* Cast buffer as request. */
    
            DigitalPinHasPwmRequest &request = *(reinterpret_cast
                                          <DigitalPinHasPwmRequest *>
                                          (&request_arr.data[2]));
    
    
            DigitalPinHasPwmResponse response;

            response.result =
            obj_.digital_pin_has_pwm(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DigitalPinHasPwmResponse &output = *(reinterpret_cast
                                                 <DigitalPinHasPwmResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DIGITAL_PIN_TO_INTERRUPT:
          {
            /* Cast buffer as request. */
    
            DigitalPinToInterruptRequest &request = *(reinterpret_cast
                                          <DigitalPinToInterruptRequest *>
                                          (&request_arr.data[2]));
    
    
            DigitalPinToInterruptResponse response;

            response.result =
            obj_.digital_pin_to_interrupt(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DigitalPinToInterruptResponse &output = *(reinterpret_cast
                                                 <DigitalPinToInterruptResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_READ_ADC_REGISTERS:
          {
            /* Cast buffer as request. */
    
            ReadAdcRegistersRequest &request = *(reinterpret_cast
                                          <ReadAdcRegistersRequest *>
                                          (&request_arr.data[2]));
    
    
            ReadAdcRegistersResponse response;

            response.result =
            obj_.read_adc_registers(request.adc_num);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_ADC_REGISTERS:
          {
            /* Cast buffer as request. */
    
            UpdateAdcRegistersRequest &request = *(reinterpret_cast
                                          <UpdateAdcRegistersRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized_adc_msg.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized_adc_msg.data);
            UpdateAdcRegistersResponse response;

            response.result =
            obj_.update_adc_registers(request.adc_num, request.serialized_adc_msg);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateAdcRegistersResponse &output = *(reinterpret_cast
                                                 <UpdateAdcRegistersResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_READ_PIT_REGISTERS:
          {
            /* Cast buffer as request. */
    
    
            ReadPitRegistersResponse response;

            response.result =
            obj_.read_pit_registers();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_PIT_REGISTERS:
          {
            /* Cast buffer as request. */
    
            UpdatePitRegistersRequest &request = *(reinterpret_cast
                                          <UpdatePitRegistersRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized_pit_msg.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized_pit_msg.data);
            UpdatePitRegistersResponse response;

            response.result =
            obj_.update_pit_registers(request.serialized_pit_msg);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdatePitRegistersResponse &output = *(reinterpret_cast
                                                 <UpdatePitRegistersResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_READ_PIT_TIMER_CONFIG:
          {
            /* Cast buffer as request. */
    
            ReadPitTimerConfigRequest &request = *(reinterpret_cast
                                          <ReadPitTimerConfigRequest *>
                                          (&request_arr.data[2]));
    
    
            ReadPitTimerConfigResponse response;

            response.result =
            obj_.read_pit_timer_config(request.timer_index);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_PIT_TIMER_CONFIG:
          {
            /* Cast buffer as request. */
    
            UpdatePitTimerConfigRequest &request = *(reinterpret_cast
                                          <UpdatePitTimerConfigRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized_config.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized_config.data);
            UpdatePitTimerConfigResponse response;

            response.result =
            obj_.update_pit_timer_config(request.index, request.serialized_config);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdatePitTimerConfigResponse &output = *(reinterpret_cast
                                                 <UpdatePitTimerConfigResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DMA_CHANNEL_COUNT:
          {
            /* Cast buffer as request. */
    
    
            DmaChannelCountResponse response;

            response.result =
            obj_.dma_channel_count();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DmaChannelCountResponse &output = *(reinterpret_cast
                                                 <DmaChannelCountResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_READ_DMA_TCD:
          {
            /* Cast buffer as request. */
    
            ReadDmaTcdRequest &request = *(reinterpret_cast
                                          <ReadDmaTcdRequest *>
                                          (&request_arr.data[2]));
    
    
            ReadDmaTcdResponse response;

            response.result =
            obj_.read_dma_TCD(request.channel_num);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_RESET_DMA_TCD:
          {
            /* Cast buffer as request. */
    
            ResetDmaTcdRequest &request = *(reinterpret_cast
                                          <ResetDmaTcdRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.reset_dma_TCD(request.channel_num);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_UPDATE_DMA_TCD:
          {
            /* Cast buffer as request. */
    
            UpdateDmaTcdRequest &request = *(reinterpret_cast
                                          <UpdateDmaTcdRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized_tcd.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized_tcd.data);
            UpdateDmaTcdResponse response;

            response.result =
            obj_.update_dma_TCD(request.channel_num, request.serialized_tcd);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateDmaTcdResponse &output = *(reinterpret_cast
                                                 <UpdateDmaTcdResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_READ_DMA_PRIORITY:
          {
            /* Cast buffer as request. */
    
            ReadDmaPriorityRequest &request = *(reinterpret_cast
                                          <ReadDmaPriorityRequest *>
                                          (&request_arr.data[2]));
    
    
            ReadDmaPriorityResponse response;

            response.result =
            obj_.read_dma_priority(request.channel_num);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_READ_DMA_REGISTERS:
          {
            /* Cast buffer as request. */
    
    
            ReadDmaRegistersResponse response;

            response.result =
            obj_.read_dma_registers();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_DMA_REGISTERS:
          {
            /* Cast buffer as request. */
    
            UpdateDmaRegistersRequest &request = *(reinterpret_cast
                                          <UpdateDmaRegistersRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized_dma_msg.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized_dma_msg.data);
            UpdateDmaRegistersResponse response;

            response.result =
            obj_.update_dma_registers(request.serialized_dma_msg);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateDmaRegistersResponse &output = *(reinterpret_cast
                                                 <UpdateDmaRegistersResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_READ_DMA_MUX_CHCFG:
          {
            /* Cast buffer as request. */
    
            ReadDmaMuxChcfgRequest &request = *(reinterpret_cast
                                          <ReadDmaMuxChcfgRequest *>
                                          (&request_arr.data[2]));
    
    
            ReadDmaMuxChcfgResponse response;

            response.result =
            obj_.read_dma_mux_chcfg(request.channel_num);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_DMA_MUX_CHCFG:
          {
            /* Cast buffer as request. */
    
            UpdateDmaMuxChcfgRequest &request = *(reinterpret_cast
                                          <UpdateDmaMuxChcfgRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized_mux.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized_mux.data);
            UpdateDmaMuxChcfgResponse response;

            response.result =
            obj_.update_dma_mux_chcfg(request.channel_num, request.serialized_mux);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateDmaMuxChcfgResponse &output = *(reinterpret_cast
                                                 <UpdateDmaMuxChcfgResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_CLEAR_DMA_ERRORS:
          {
            /* Cast buffer as request. */
    
    
            obj_.clear_dma_errors();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_READ_SIM_SCGC6:
          {
            /* Cast buffer as request. */
    
    
            ReadSimScgc6Response response;

            response.result =
            obj_.read_sim_SCGC6();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_READ_SIM_SCGC7:
          {
            /* Cast buffer as request. */
    
    
            ReadSimScgc7Response response;

            response.result =
            obj_.read_sim_SCGC7();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_SIM_SCGC6:
          {
            /* Cast buffer as request. */
    
            UpdateSimScgc6Request &request = *(reinterpret_cast
                                          <UpdateSimScgc6Request *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized_scgc6.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized_scgc6.data);
            UpdateSimScgc6Response response;

            response.result =
            obj_.update_sim_SCGC6(request.serialized_scgc6);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateSimScgc6Response &output = *(reinterpret_cast
                                                 <UpdateSimScgc6Response *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_UPDATE_SIM_SCGC7:
          {
            /* Cast buffer as request. */
    
            UpdateSimScgc7Request &request = *(reinterpret_cast
                                          <UpdateSimScgc7Request *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized_scgc7.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized_scgc7.data);
            UpdateSimScgc7Response response;

            response.result =
            obj_.update_sim_SCGC7(request.serialized_scgc7);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateSimScgc7Response &output = *(reinterpret_cast
                                                 <UpdateSimScgc7Response *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_FREE_ALL:
          {
            /* Cast buffer as request. */
    
    
            obj_.free_all();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MEM_ALLOC:
          {
            /* Cast buffer as request. */
    
            MemAllocRequest &request = *(reinterpret_cast
                                          <MemAllocRequest *>
                                          (&request_arr.data[2]));
    
    
            MemAllocResponse response;

            response.result =
            obj_.mem_alloc(request.size);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MemAllocResponse &output = *(reinterpret_cast
                                                 <MemAllocResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_MEM_FREE:
          {
            /* Cast buffer as request. */
    
            MemFreeRequest &request = *(reinterpret_cast
                                          <MemFreeRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.mem_free(request.address);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MEM_ALIGNED_ALLOC:
          {
            /* Cast buffer as request. */
    
            MemAlignedAllocRequest &request = *(reinterpret_cast
                                          <MemAlignedAllocRequest *>
                                          (&request_arr.data[2]));
    
    
            MemAlignedAllocResponse response;

            response.result =
            obj_.mem_aligned_alloc(request.alignment, request.size);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MemAlignedAllocResponse &output = *(reinterpret_cast
                                                 <MemAlignedAllocResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_MEM_ALIGNED_FREE:
          {
            /* Cast buffer as request. */
    
            MemAlignedFreeRequest &request = *(reinterpret_cast
                                          <MemAlignedFreeRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.mem_aligned_free(request.address);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MEM_ALIGNED_ALLOC_AND_SET:
          {
            /* Cast buffer as request. */
    
            MemAlignedAllocAndSetRequest &request = *(reinterpret_cast
                                          <MemAlignedAllocAndSetRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.data.data);
            MemAlignedAllocAndSetResponse response;

            response.result =
            obj_.mem_aligned_alloc_and_set(request.alignment, request.data);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MemAlignedAllocAndSetResponse &output = *(reinterpret_cast
                                                 <MemAlignedAllocAndSetResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_MEM_CPY_HOST_TO_DEVICE:
          {
            /* Cast buffer as request. */
    
            MemCpyHostToDeviceRequest &request = *(reinterpret_cast
                                          <MemCpyHostToDeviceRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.data.data);
            obj_.mem_cpy_host_to_device(request.address, request.data);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MEM_CPY_DEVICE_TO_HOST:
          {
            /* Cast buffer as request. */
    
            MemCpyDeviceToHostRequest &request = *(reinterpret_cast
                                          <MemCpyDeviceToHostRequest *>
                                          (&request_arr.data[2]));
    
    
            MemCpyDeviceToHostResponse response;

            response.result =
            obj_.mem_cpy_device_to_host(request.address, request.size);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MEM_FILL_UINT8:
          {
            /* Cast buffer as request. */
    
            MemFillUint8Request &request = *(reinterpret_cast
                                          <MemFillUint8Request *>
                                          (&request_arr.data[2]));
    
    
            obj_.mem_fill_uint8(request.address, request.value, request.size);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MEM_FILL_UINT16:
          {
            /* Cast buffer as request. */
    
            MemFillUint16Request &request = *(reinterpret_cast
                                          <MemFillUint16Request *>
                                          (&request_arr.data[2]));
    
    
            obj_.mem_fill_uint16(request.address, request.value, request.size);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MEM_FILL_UINT32:
          {
            /* Cast buffer as request. */
    
            MemFillUint32Request &request = *(reinterpret_cast
                                          <MemFillUint32Request *>
                                          (&request_arr.data[2]));
    
    
            obj_.mem_fill_uint32(request.address, request.value, request.size);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MEM_FILL_FLOAT:
          {
            /* Cast buffer as request. */
    
            MemFillFloatRequest &request = *(reinterpret_cast
                                          <MemFillFloatRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.mem_fill_float(request.address, request.value, request.size);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_LOOP:
          {
            /* Cast buffer as request. */
    
    
            obj_.loop();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_LAST_DMA_CHANNEL_DONE:
          {
            /* Cast buffer as request. */
    
    
            LastDmaChannelDoneResponse response;

            response.result =
            obj_.last_dma_channel_done();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            LastDmaChannelDoneResponse &output = *(reinterpret_cast
                                                 <LastDmaChannelDoneResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ATTACH_DMA_INTERRUPT:
          {
            /* Cast buffer as request. */
    
            AttachDmaInterruptRequest &request = *(reinterpret_cast
                                          <AttachDmaInterruptRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.attach_dma_interrupt(request.dma_channel);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DETACH_DMA_INTERRUPT:
          {
            /* Cast buffer as request. */
    
            DetachDmaInterruptRequest &request = *(reinterpret_cast
                                          <DetachDmaInterruptRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.detach_dma_interrupt(request.dma_channel);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

      default:
        result.length = 0xFFFFFFFF;
        result.data = NULL;
    }
    return result;
  }
};

}  // namespace dropbot_dx



#endif  // ifndef ___DROPBOT_DX___
