# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServerConfigurationsManagementSettings(Model):
    """Set the connectivity, storage and workload settings.

    :param sql_connectivity_update_settings: SQL connectivity type settings.
    :type sql_connectivity_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlConnectivityUpdateSettings
    :param sql_workload_type_update_settings: SQL workload type settings.
    :type sql_workload_type_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlWorkloadTypeUpdateSettings
    :param sql_storage_update_settings: SQL storage update settings.
    :type sql_storage_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlStorageUpdateSettings
    :param additional_features_server_configurations: Additional SQL feature
     settings.
    :type additional_features_server_configurations:
     ~azure.mgmt.sqlvirtualmachine.models.AdditionalFeaturesServerConfigurations
    """

    _attribute_map = {
        'sql_connectivity_update_settings': {'key': 'sqlConnectivityUpdateSettings', 'type': 'SqlConnectivityUpdateSettings'},
        'sql_workload_type_update_settings': {'key': 'sqlWorkloadTypeUpdateSettings', 'type': 'SqlWorkloadTypeUpdateSettings'},
        'sql_storage_update_settings': {'key': 'sqlStorageUpdateSettings', 'type': 'SqlStorageUpdateSettings'},
        'additional_features_server_configurations': {'key': 'additionalFeaturesServerConfigurations', 'type': 'AdditionalFeaturesServerConfigurations'},
    }

    def __init__(self, **kwargs):
        super(ServerConfigurationsManagementSettings, self).__init__(**kwargs)
        self.sql_connectivity_update_settings = kwargs.get('sql_connectivity_update_settings', None)
        self.sql_workload_type_update_settings = kwargs.get('sql_workload_type_update_settings', None)
        self.sql_storage_update_settings = kwargs.get('sql_storage_update_settings', None)
        self.additional_features_server_configurations = kwargs.get('additional_features_server_configurations', None)
