"""
Normal and sized frames, with some additional goodies:

self.AddAccelerator(spec):
adds the accelerator defined by spec to the given frame, and updates the accelerator table dynamically.
"""

import wx
from wx.lib.sized_controls import SizedFrame

def AddAccelerator(self, modifiers, key, action):
 """
 Add an accelerator.
 
 Modifiers and key follow the same pattern as the list used to create wx.AcceleratorTable objects.
 """
 newId = wx.NewId()
 self.Bind(wx.EVT_MENU, action, id = newId)
 self.RawAcceleratorTable.append((modifiers, key, newId))
 self.SetAcceleratorTable(wx.AcceleratorTable(self.RawAcceleratorTable))
 return newId

class Frame(wx.Frame):
 """A standard frame with the accelerator stuff."""
 def __init__(self, *args, **kwargs):
  super(Frame, self).__init__(*args, **kwargs)
  self.RawAcceleratorTable = []
 def AddAccelerator(self, *args, **kwargs):
  return AddAccelerator(self, *args, **kwargs)

class SizedFrame (SizedFrame):
 """A sized frame with the accelerator stuff."""
 def __init__(self, *args, **kwargs):
  super(SizedFrame, self).__init__(*args, **kwargs)
  self.RawAcceleratorTable = []
 def AddAccelerator(self, *args, **kwargs):
  return AddAccelerator(self, *args, **kwargs)
