'''
.. module:: skrf.vi.vna
++++++++++++++++++++++++++++++++++++++++++++++++++++
Vector Network Analyzers (:mod:`skrf.vi.vna`)
++++++++++++++++++++++++++++++++++++++++++++++++++++

.. warning::

    As of 2017.02 a new architecture for vna drivers is being implemented.

New VNA drivers
---------------

- VNA drivers will now have a common high level functionality across all vendors implemented in an ABCVNA class.
- Different vendor drivers will implement their own mid level functionality as needed to implement the ABC class
- The low level functions are all implemented as SCPI commands which have a new way of being generated and called

Legacy vna module
------------------------
The old vna.py module containing drivers for PNA, PNA-X, HP8510, etc. will be available as vna_old.py and can be used as
follows:

::

    from skrf.vi.vna_old import PNA

Available VNAs
------------------

.. autosummary::
    :toctree: generated/

    PNA
    ZVA40
    HP8510C
    HP8720
'''

from .abcvna import VNA
from .keysight_pna import PNA, PNAX
from .keysight_fieldfox import FieldFox
