#!/usr/bin/env python

__author__ = 'Xyene'
import ez_setup

ez_setup.use_setuptools()
from setuptools import setup, find_packages
import os

with open('README.rst') as file:
    long_description = file.read()

with open(os.path.join(os.path.dirname(os.path.realpath(__file__)), 'cube2sphere', 'version.py')) as version:
    exec (version.read())

setup(name='cube2sphere',
      version=__version__,
      description='Utility to map 6 cube (cubemap, skybox) faces into an equirectangular (cylindrical projection, skysphere) map',
      long_description=long_description,
      author='Tudor Brindus',
      author_email='tbrindus@gmail.com',
      url='http://github.com/Xyene/cube2sphere',
      packages=find_packages(),
      package_data={
          "cube2sphere": ["*.blend"],
      },
      entry_points={
          'console_scripts': ['cube2sphere=cube2sphere.cube2sphere:main'],
      },
      classifiers=[
          'Development Status :: 3 - Alpha',
          'Environment :: Console',
          'Intended Audience :: Developers',
          'Programming Language :: Python :: 2.7',
          'License :: OSI Approved :: GNU Affero General Public License v3 or later (AGPLv3+)',
          'Operating System :: OS Independent',
          'Programming Language :: Python',
          'Topic :: Artistic Software'
      ],
)
