
(function(){var define,requireModule;(function(){var registry={},seen={};define=function(name,deps,callback){registry[name]={deps:deps,callback:callback};};requireModule=function(name){if(seen[name]){return seen[name];}
seen[name]={};var mod,deps,callback,reified,exports;mod=registry[name];if(!mod){throw new Error("Module '"+name+"' not found.");}
deps=mod.deps;callback=mod.callback;reified=[];exports;for(var i=0,l=deps.length;i<l;i++){if(deps[i]==='exports'){reified.push(exports={});}else{reified.push(requireModule(deps[i]));}}
var value=callback.apply(this,reified);return seen[name]=exports||value;};})();(function(){Ember.String.pluralize=function(word){return Ember.Inflector.inflector.pluralize(word);};Ember.String.singularize=function(word){return Ember.Inflector.inflector.singularize(word);};})();(function(){var BLANK_REGEX=/^\s*$/;function loadUncountable(rules,uncountable){for(var i=0,length=uncountable.length;i<length;i++){rules.uncountable[uncountable[i]]=true;}}
function loadIrregular(rules,irregularPairs){var pair;for(var i=0,length=irregularPairs.length;i<length;i++){pair=irregularPairs[i];rules.irregular[pair[0]]=pair[1];rules.irregularInverse[pair[1]]=pair[0];}}
function Inflector(ruleSet){ruleSet=ruleSet||{};ruleSet.uncountable=ruleSet.uncountable||{};ruleSet.irregularPairs=ruleSet.irregularPairs||{};var rules=this.rules={plurals:ruleSet.plurals||[],singular:ruleSet.singular||[],irregular:{},irregularInverse:{},uncountable:{}};loadUncountable(rules,ruleSet.uncountable);loadIrregular(rules,ruleSet.irregularPairs);}
Inflector.prototype={pluralize:function(word){return this.inflect(word,this.rules.plurals);},singularize:function(word){return this.inflect(word,this.rules.singular);},inflect:function(word,typeRules){var inflection,substitution,result,lowercase,isBlank,isUncountable,isIrregular,isIrregularInverse,rule;isBlank=BLANK_REGEX.test(word);if(isBlank){return word;}
lowercase=word.toLowerCase();isUncountable=this.rules.uncountable[lowercase];if(isUncountable){return word;}
isIrregular=this.rules.irregular[lowercase];if(isIrregular){return isIrregular;}
isIrregularInverse=this.rules.irregularInverse[lowercase];if(isIrregularInverse){return isIrregularInverse;}
for(var i=typeRules.length,min=0;i>min;i--){inflection=typeRules[i-1];rule=inflection[0];if(rule.test(word)){break;}}
inflection=inflection||[];rule=inflection[0];substitution=inflection[1];result=word.replace(rule,substitution);return result;}};Ember.Inflector=Inflector;})();(function(){Ember.Inflector.defaultRules={plurals:[[/$/,'s'],[/s$/i,'s'],[/^(ax|test)is$/i,'$1es'],[/(octop|vir)us$/i,'$1i'],[/(octop|vir)i$/i,'$1i'],[/(alias|status)$/i,'$1es'],[/(bu)s$/i,'$1ses'],[/(buffal|tomat)o$/i,'$1oes'],[/([ti])um$/i,'$1a'],[/([ti])a$/i,'$1a'],[/sis$/i,'ses'],[/(?:([^f])fe|([lr])f)$/i,'$1$2ves'],[/(hive)$/i,'$1s'],[/([^aeiouy]|qu)y$/i,'$1ies'],[/(x|ch|ss|sh)$/i,'$1es'],[/(matr|vert|ind)(?:ix|ex)$/i,'$1ices'],[/^(m|l)ouse$/i,'$1ice'],[/^(m|l)ice$/i,'$1ice'],[/^(ox)$/i,'$1en'],[/^(oxen)$/i,'$1'],[/(quiz)$/i,'$1zes']],singular:[[/s$/i,''],[/(ss)$/i,'$1'],[/(n)ews$/i,'$1ews'],[/([ti])a$/i,'$1um'],[/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)(sis|ses)$/i,'$1sis'],[/(^analy)(sis|ses)$/i,'$1sis'],[/([^f])ves$/i,'$1fe'],[/(hive)s$/i,'$1'],[/(tive)s$/i,'$1'],[/([lr])ves$/i,'$1f'],[/([^aeiouy]|qu)ies$/i,'$1y'],[/(s)eries$/i,'$1eries'],[/(m)ovies$/i,'$1ovie'],[/(x|ch|ss|sh)es$/i,'$1'],[/^(m|l)ice$/i,'$1ouse'],[/(bus)(es)?$/i,'$1'],[/(o)es$/i,'$1'],[/(shoe)s$/i,'$1'],[/(cris|test)(is|es)$/i,'$1is'],[/^(a)x[ie]s$/i,'$1xis'],[/(octop|vir)(us|i)$/i,'$1us'],[/(alias|status)(es)?$/i,'$1'],[/^(ox)en/i,'$1'],[/(vert|ind)ices$/i,'$1ex'],[/(matr)ices$/i,'$1ix'],[/(quiz)zes$/i,'$1'],[/(database)s$/i,'$1']],irregularPairs:[['person','people'],['man','men'],['child','children'],['sex','sexes'],['move','moves'],['cow','kine'],['zombie','zombies']],uncountable:['equipment','information','rice','money','species','series','fish','sheep','jeans','police']};})();(function(){if(Ember.EXTEND_PROTOTYPES){String.prototype.pluralize=function(){return Ember.String.pluralize(this);};String.prototype.singularize=function(){return Ember.String.singularize(this);};}})();(function(){Ember.Inflector.inflector=new Ember.Inflector(Ember.Inflector.defaultRules);})();(function(){})();})();(function(){if('undefined'===typeof DS){DS=Ember.Namespace.create({VERSION:'1.0.0-beta.1'});if('undefined'!==typeof window){window.DS=DS;}}})();(function(){var isNone=Ember.isNone,isEmpty=Ember.isEmpty;DS.JSONTransforms={string:{deserialize:function(serialized){return isNone(serialized)?null:String(serialized);},serialize:function(deserialized){return isNone(deserialized)?null:String(deserialized);}},number:{deserialize:function(serialized){return isEmpty(serialized)?null:Number(serialized);},serialize:function(deserialized){return isEmpty(deserialized)?null:Number(deserialized);}},'boolean':{deserialize:function(serialized){var type=typeof serialized;if(type==="boolean"){return serialized;}else if(type==="string"){return serialized.match(/^true$|^t$|^1$/i)!==null;}else if(type==="number"){return serialized===1;}else{return false;}},serialize:function(deserialized){return Boolean(deserialized);}},date:{deserialize:function(serialized){var type=typeof serialized;if(type==="string"){return new Date(Ember.Date.parse(serialized));}else if(type==="number"){return new Date(serialized);}else if(serialized===null||serialized===undefined){return serialized;}else{return null;}},serialize:function(date){if(date instanceof Date){var days=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];var months=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];var pad=function(num){return num<10?"0"+num:""+num;};var utcYear=date.getUTCFullYear(),utcMonth=date.getUTCMonth(),utcDayOfMonth=date.getUTCDate(),utcDay=date.getUTCDay(),utcHours=date.getUTCHours(),utcMinutes=date.getUTCMinutes(),utcSeconds=date.getUTCSeconds();var dayOfWeek=days[utcDay];var dayOfMonth=pad(utcDayOfMonth);var month=months[utcMonth];return dayOfWeek+", "+dayOfMonth+" "+month+" "+utcYear+" "+
pad(utcHours)+":"+pad(utcMinutes)+":"+pad(utcSeconds)+" GMT";}else{return null;}}}};})();(function(){var get=Ember.get,set=Ember.set,isNone=Ember.isNone;var transforms=DS.JSONTransforms;function aliasMethod(methodName){return function(){return this[methodName].apply(this,arguments);};}
DS.JSONSerializer=Ember.Object.extend({primaryKey:'id',deserialize:function(type,data){var store=get(this,'store');type.eachTransformedAttribute(function(key,type){data[key]=transforms[type].deserialize(data[key]);});type.eachRelationship(function(key,relationship){if(data.links&&data.links[key]){return;}
var type=relationship.type,value=data[key];if(value==null){return;}
if(relationship.kind==='belongsTo'){this.deserializeRecordId(data,key,relationship,value);}else if(relationship.kind==='hasMany'){this.deserializeRecordIds(data,key,relationship,value);}},this);return data;},deserializeRecordId:function(data,key,relationship,id){if(isNone(id)||id instanceof DS.Model){return;}
var type;if(typeof id==='number'||typeof id==='string'){type=this.typeFor(relationship,key,data);data[key]=get(this,'store').recordForId(type,id);}else if(typeof id==='object'){data[key]=get(this,'store').recordForId(id.type,id.id);}},deserializeRecordIds:function(data,key,relationship,ids){for(var i=0,l=ids.length;i<l;i++){this.deserializeRecordId(ids,i,relationship,ids[i]);}},serialize:function(record,options){var store=get(this,'store');var json={};if(options&&options.includeId){var id=get(record,'id');if(id){json[get(this,'primaryKey')]=get(record,'id');}}
var attrs=get(this,'attrs');record.eachAttribute(function(key,attribute){var value=get(record,key),type=attribute.type;if(type){value=transforms[type].serialize(value);}
key=attrs&&attrs[key]||key;json[key]=value;},this);record.eachRelationship(function(key,relationship){if(relationship.kind==='belongsTo'){this.serializeBelongsTo(record,json,relationship);}else if(relationship.kind==='hasMany'){this.serializeHasMany(record,json,relationship);}},this);return json;},serializeBelongsTo:function(record,json,relationship){var key=relationship.key;var belongsTo=get(record,key);if(isNone(belongsTo)){return;}
json[key]=get(belongsTo,'id');if(relationship.options.polymorphic){json[key+"_type"]=belongsTo.constructor.typeKey;}},serializeHasMany:Ember.K,extract:function(store,type,payload,id,requestType){var specificExtract="extract"+requestType.charAt(0).toUpperCase()+requestType.substr(1);return this[specificExtract](store,type,payload,id,requestType);},extractFindAll:aliasMethod('extractArray'),extractFindQuery:aliasMethod('extractArray'),extractFindMany:aliasMethod('extractArray'),extractFindHasMany:aliasMethod('extractArray'),extractCreateRecord:aliasMethod('extractSave'),extractUpdateRecord:aliasMethod('extractSave'),extractDeleteRecord:aliasMethod('extractSave'),extractFind:aliasMethod('extractSingle'),extractSave:aliasMethod('extractSingle'),extractSingle:function(store,type,payload){return payload;},extractArray:function(store,type,payload){return payload;},typeFor:function(relationship,key,data){if(relationship.options.polymorphic){return data[key+"_type"];}else{return relationship.type;}},eachEmbeddedRecord:function(){}});})();(function(){var get=Ember.get,capitalize=Ember.String.capitalize,underscore=Ember.String.underscore,DS=window.DS;DS.DebugAdapter=Ember.DataAdapter.extend({getFilters:function(){return[{name:'isNew',desc:'New'},{name:'isModified',desc:'Modified'},{name:'isClean',desc:'Clean'}];},detect:function(klass){return klass!==DS.Model&&DS.Model.detect(klass);},columnsForType:function(type){var columns=[{name:'id',desc:'Id'}],count=0,self=this;Ember.A(get(type,'attributes')).forEach(function(name,meta){if(count++>self.attributeLimit){return false;}
var desc=capitalize(underscore(name).replace('_',' '));columns.push({name:name,desc:desc});});return columns;},getRecords:function(type){return this.get('store').all(type);},getRecordColumnValues:function(record){var self=this,count=0,columnValues={id:get(record,'id')};record.eachAttribute(function(key){if(count++>self.attributeLimit){return false;}
var value=get(record,key);columnValues[key]=value;});return columnValues;},getRecordKeywords:function(record){var keywords=[],keys=Ember.A(['id']);record.eachAttribute(function(key){keys.push(key);});keys.forEach(function(key){keywords.push(get(record,key));});return keywords;},getRecordFilterValues:function(record){return{isNew:record.get('isNew'),isModified:record.get('isDirty')&&!record.get('isNew'),isClean:!record.get('isDirty')};},getRecordColor:function(record){var color='black';if(record.get('isNew')){color='green';}else if(record.get('isDirty')){color='blue';}
return color;},observeRecord:function(record,recordUpdated){var releaseMethods=Ember.A(),self=this,keysToObserve=Ember.A(['id','isNew','isDirty']);record.eachAttribute(function(key){keysToObserve.push(key);});keysToObserve.forEach(function(key){var handler=function(){recordUpdated(self.wrapRecord(record));};Ember.addObserver(record,key,handler);releaseMethods.push(function(){Ember.removeObserver(record,key,handler);});});var release=function(){releaseMethods.forEach(function(fn){fn();});};return release;}});})();(function(){var set=Ember.set;Ember.onLoad('Ember.Application',function(Application){Application.initializer({name:"store",initialize:function(container,application){application.register('store:main',application.Store||DS.Store);application.register('serializer:_default',DS.JSONSerializer);application.register('serializer:_rest',DS.RESTSerializer);application.register('adapter:_rest',DS.RESTAdapter);container.lookup('store:main');}});Application.initializer({name:"dataAdapter",initialize:function(container,application){application.register('dataAdapter:main',DS.DebugAdapter);}});Application.initializer({name:"injectStore",initialize:function(container,application){application.inject('controller','store','store:main');application.inject('route','store','store:main');application.inject('serializer','store','store:main');application.inject('dataAdapter','store','store:main');}});});})();(function(){Ember.Date=Ember.Date||{};var origParse=Date.parse,numericKeys=[1,4,5,6,7,10,11];Ember.Date.parse=function(date){var timestamp,struct,minutesOffset=0;if((struct=/^(\d{4}|[+\-]\d{6})(?:-(\d{2})(?:-(\d{2}))?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(?:\.(\d{3}))?)?(?:(Z)|([+\-])(\d{2})(?::(\d{2}))?)?)?$/.exec(date))){for(var i=0,k;(k=numericKeys[i]);++i){struct[k]=+struct[k]||0;}
struct[2]=(+struct[2]||1)-1;struct[3]=+struct[3]||1;if(struct[8]!=='Z'&&struct[9]!==undefined){minutesOffset=struct[10]*60+struct[11];if(struct[9]==='+'){minutesOffset=0-minutesOffset;}}
timestamp=Date.UTC(struct[1],struct[2],struct[3],struct[4],struct[5]+minutesOffset,struct[6],struct[7]);}
else{timestamp=origParse?origParse(date):NaN;}
return timestamp;};if(Ember.EXTEND_PROTOTYPES===true||Ember.EXTEND_PROTOTYPES.Date){Date.parse=Ember.Date.parse;}})();(function(){})();(function(){var get=Ember.get,set=Ember.set;DS.RecordArray=Ember.ArrayProxy.extend(Ember.Evented,{type:null,content:null,isLoaded:false,isUpdating:false,store:null,objectAtContent:function(index){var content=get(this,'content');return content.objectAt(index);},update:function(){if(get(this,'isUpdating')){return;}
var store=get(this,'store'),type=get(this,'type');store.fetchAll(type,this);},addRecord:function(record){get(this,'content').addObject(record);},removeRecord:function(record){get(this,'content').removeObject(record);}});})();(function(){var get=Ember.get;DS.FilteredRecordArray=DS.RecordArray.extend({filterFunction:null,isLoaded:true,replace:function(){var type=get(this,'type').toString();throw new Error("The result of a client-side filter (on "+type+") is immutable.");},updateFilter:Ember.observer(function(){var manager=get(this,'manager');manager.updateFilter(this,get(this,'type'),get(this,'filterFunction'));},'filterFunction')});})();(function(){var get=Ember.get,set=Ember.set;DS.AdapterPopulatedRecordArray=DS.RecordArray.extend({query:null,replace:function(){var type=get(this,'type').toString();throw new Error("The result of a server query (on "+type+") is immutable.");},load:function(data){var store=get(this,'store'),type=get(this,'type'),records=store.pushMany(type,data);this.setProperties({content:Ember.A(records),isLoaded:true});Ember.run.once(this,'trigger','didLoad');}});})();(function(){var get=Ember.get,set=Ember.set;var map=Ember.EnumerableUtils.map;DS.ManyArray=DS.RecordArray.extend({init:function(){this._super.apply(this,arguments);this._changesToSync=Ember.OrderedSet.create();},owner:null,isPolymorphic:false,isLoaded:false,loadingRecordsCount:function(count){this.loadingRecordsCount=count;},loadedRecord:function(){this.loadingRecordsCount--;if(this.loadingRecordsCount===0){set(this,'isLoaded',true);this.trigger('didLoad');}},fetch:function(){var records=get(this,'content'),store=get(this,'store'),owner=get(this,'owner');var unloadedRecords=records.filterProperty('isEmpty',true);store.fetchMany(unloadedRecords,owner);},replaceContent:function(index,removed,added){added=map(added,function(record){Ember.assert("You cannot add '"+record.constructor.typeKey+"' records to this relationship (only '"+this.type.typeKey+"' allowed)",!this.type||record instanceof this.type);return record;},this);this._super(index,removed,added);},arrangedContentDidChange:function(){this.fetch();},arrayContentWillChange:function(index,removed,added){var owner=get(this,'owner'),name=get(this,'name');if(!owner._suspendedRelationships){for(var i=index;i<index+removed;i++){var record=get(this,'content').objectAt(i);var change=DS.RelationshipChange.createChange(owner,record,get(this,'store'),{parentType:owner.constructor,changeType:"remove",kind:"hasMany",key:name});this._changesToSync.add(change);}}
return this._super.apply(this,arguments);},arrayContentDidChange:function(index,removed,added){this._super.apply(this,arguments);var owner=get(this,'owner'),name=get(this,'name'),store=get(this,'store');if(!owner._suspendedRelationships){for(var i=index;i<index+added;i++){var record=get(this,'content').objectAt(i);var change=DS.RelationshipChange.createChange(owner,record,store,{parentType:owner.constructor,changeType:"add",kind:"hasMany",key:name});change.hasManyName=name;this._changesToSync.add(change);}
this._changesToSync.forEach(function(change){change.sync();});this._changesToSync.clear();}},createRecord:function(hash){var owner=get(this,'owner'),store=get(owner,'store'),type=get(this,'type'),record;Ember.assert("You cannot add '"+type.typeKey+"' records to this polymorphic relationship.",!get(this,'isPolymorphic'));record=store.createRecord.call(store,type,hash);this.pushObject(record);return record;}});})();(function(){})();(function(){var get=Ember.get;var forEach=Ember.ArrayPolyfills.forEach;var resolveMapConflict=function(oldValue,newValue){return oldValue;};var transformMapKey=function(key,value){return key;};var transformMapValue=function(key,value){return value;};DS._Mappable=Ember.Mixin.create({createInstanceMapFor:function(mapName){var instanceMeta=getMappableMeta(this);instanceMeta.values=instanceMeta.values||{};if(instanceMeta.values[mapName]){return instanceMeta.values[mapName];}
var instanceMap=instanceMeta.values[mapName]=new Ember.Map();var klass=this.constructor;while(klass&&klass!==DS.Store){this._copyMap(mapName,klass,instanceMap);klass=klass.superclass;}
instanceMeta.values[mapName]=instanceMap;return instanceMap;},_copyMap:function(mapName,klass,instanceMap){var classMeta=getMappableMeta(klass);var classMap=classMeta[mapName];if(classMap){forEach.call(classMap,eachMap,this);}
function eachMap(key,value){var transformedKey=(klass.transformMapKey||transformMapKey)(key,value);var transformedValue=(klass.transformMapValue||transformMapValue)(key,value);var oldValue=instanceMap.get(transformedKey);var newValue=transformedValue;if(oldValue){newValue=(this.constructor.resolveMapConflict||resolveMapConflict)(oldValue,newValue);}
instanceMap.set(transformedKey,newValue);}}});DS._Mappable.generateMapFunctionFor=function(mapName,transform){return function(key,value){var meta=getMappableMeta(this);var map=meta[mapName]||Ember.MapWithDefault.create({defaultValue:function(){return{};}});transform.call(this,key,value,map);meta[mapName]=map;};};function getMappableMeta(obj){var meta=Ember.meta(obj,true),keyName='DS.Mappable',value=meta[keyName];if(!value){meta[keyName]={};}
if(!meta.hasOwnProperty(keyName)){meta[keyName]=Ember.create(meta[keyName]);}
return meta[keyName];}})();(function(){var get=Ember.get,set=Ember.set;var once=Ember.run.once;var isNone=Ember.isNone;var forEach=Ember.EnumerableUtils.forEach;var indexOf=Ember.EnumerableUtils.indexOf;var map=Ember.EnumerableUtils.map;var OrderedSet=Ember.OrderedSet;var resolve=Ember.RSVP.resolve;var coerceId=function(id){return id==null?null:id+'';};DS.Store=Ember.Object.extend(DS._Mappable,{init:function(){this.typeMaps={};this.recordArrayManager=DS.RecordArrayManager.create({store:this});this._relationshipChanges={};this._pendingSave=[];},adapter:'_rest',serialize:function(record,options){return this.serializerFor(record.constructor.typeKey).serialize(record,options);},defaultAdapter:Ember.computed(function(){var adapter=get(this,'adapter');Ember.assert('You tried to set `adapter` property to an instance of `DS.Adapter`, where it should be a name or a factory',!(adapter instanceof DS.Adapter));if(typeof adapter==='string'){adapter=this.container.lookup('adapter:'+adapter)||this.container.lookup('adapter:application')||this.container.lookup('adapter:_rest');}
if(DS.Adapter.detect(adapter)){adapter=adapter.create({container:this.container});}
return adapter;}).property('adapter'),createRecord:function(type,properties){type=this.modelFor(type);properties=properties||{};if(isNone(properties.id)){properties.id=this._generateId(type);}
properties.id=coerceId(properties.id);var record=this.buildRecord(type,properties.id);record.loadedData();record.setProperties(properties);return record;},_generateId:function(type){var adapter=this.adapterForType(type);if(adapter&&adapter.generateIdForRecord){return adapter.generateIdForRecord(this);}
return null;},deleteRecord:function(record){record.deleteRecord();},unloadRecord:function(record){record.unloadRecord();},find:function(type,id){if(id===undefined){return this.findAll(type);}
if(Ember.typeOf(id)==='object'){return this.findQuery(type,id);}
return this.findById(type,coerceId(id));},findById:function(type,id){type=this.modelFor(type);var record=this.getById(type,id);if(get(record,'isEmpty')){return promiseObject(this.fetchRecord(record));}else{return promiseObject(resolve(record));}},findByIds:function(type,ids){var store=this;return promiseArray(Ember.RSVP.all(map(ids,function(id){return store.findById(type,id);})).then(function(array){return Ember.A(array);}));},fetchRecord:function(record){var type=record.constructor,id=get(record,'id'),resolver=Ember.RSVP.defer();record.loadingData();var adapter=this.adapterForType(type);Ember.assert("You tried to find a record but you have no adapter (for "+type+")",adapter);Ember.assert("You tried to find a record but your adapter (for "+type+") does not implement 'find'",adapter.find);_find(adapter,this,type,id,resolver);return resolver.promise;},getById:function(type,id){type=this.modelFor(type);if(this.hasRecordForId(type,id)){return this.recordForId(type,id);}else{return this.buildRecord(type,id);}},reloadRecord:function(record,resolver){var type=record.constructor,adapter=this.adapterForType(type),store=this,id=get(record,'id');Ember.assert("You cannot reload a record without an ID",id);Ember.assert("You tried to reload a record but you have no adapter (for "+type+")",adapter);Ember.assert("You tried to reload a record but your adapter does not implement `find`",adapter.find);return _find(adapter,this,type,id,resolver);},fetchMany:function(records,owner,resolver){if(!records.length){return;}
var recordsByTypeMap=Ember.MapWithDefault.create({defaultValue:function(){return Ember.A();}});forEach(records,function(record){recordsByTypeMap.get(record.constructor).push(record);});forEach(recordsByTypeMap,function(type,records){var ids=records.mapProperty('id'),adapter=this.adapterForType(type);Ember.assert("You tried to load many records but you have no adapter (for "+type+")",adapter);Ember.assert("You tried to load many records but your adapter does not implement `findMany`",adapter.findMany);_findMany(adapter,this,type,ids,owner,resolver);},this);},hasRecordForId:function(type,id){id=coerceId(id);return!!this.typeMapFor(type).idToRecord[id];},recordForId:function(type,id){type=this.modelFor(type);id=coerceId(id);var record=this.typeMapFor(type).idToRecord[id];if(!record){record=this.buildRecord(type,id);}
return record;},findMany:function(owner,records,type,resolver){type=this.modelFor(type);records=Ember.A(records);var unloadedRecords=records.filterProperty('isEmpty',true),manyArray=this.recordArrayManager.createManyArray(type,records);forEach(unloadedRecords,function(record){record.loadingData();});manyArray.loadingRecordsCount=unloadedRecords.length;if(unloadedRecords.length){forEach(unloadedRecords,function(record){this.recordArrayManager.registerWaitingRecordArray(record,manyArray);},this);this.fetchMany(unloadedRecords,owner,resolver);}else{manyArray.set('isLoaded',true);Ember.run.once(manyArray,'trigger','didLoad');}
return manyArray;},findHasMany:function(owner,link,relationship,resolver){var adapter=this.adapterForType(owner.constructor);Ember.assert("You tried to load a hasMany relationship but you have no adapter (for "+owner.constructor+")",adapter);Ember.assert("You tried to load a hasMany relationship from a specified `link` in the original payload but your adapter does not implement `findHasMany`",adapter.findHasMany);var records=this.recordArrayManager.createManyArray(relationship.type,Ember.A([]));_findHasMany(adapter,this,owner,link,relationship,resolver);return records;},findQuery:function(type,query){type=this.modelFor(type);var array=DS.AdapterPopulatedRecordArray.create({type:type,query:query,content:Ember.A(),store:this});var adapter=this.adapterForType(type),resolver=Ember.RSVP.defer();Ember.assert("You tried to load a query but you have no adapter (for "+type+")",adapter);Ember.assert("You tried to load a query but your adapter does not implement `findQuery`",adapter.findQuery);_findQuery(adapter,this,type,query,array,resolver);return promiseArray(resolver.promise);},findAll:function(type){type=this.modelFor(type);return this.fetchAll(type,this.all(type));},fetchAll:function(type,array){var adapter=this.adapterForType(type),sinceToken=this.typeMapFor(type).metadata.since,resolver=Ember.RSVP.defer();set(array,'isUpdating',true);Ember.assert("You tried to load all records but you have no adapter (for "+type+")",adapter);Ember.assert("You tried to load all records but your adapter does not implement `findAll`",adapter.findAll);_findAll(adapter,this,type,sinceToken,resolver);return promiseArray(resolver.promise);},didUpdateAll:function(type){var findAllCache=this.typeMapFor(type).findAllCache;set(findAllCache,'isUpdating',false);},all:function(type){type=this.modelFor(type);var typeMap=this.typeMapFor(type),findAllCache=typeMap.findAllCache;if(findAllCache){return findAllCache;}
var array=DS.RecordArray.create({type:type,content:Ember.A(),store:this,isLoaded:true});this.recordArrayManager.registerFilteredRecordArray(array,type);typeMap.findAllCache=array;return array;},filter:function(type,query,filter){var promise;if(arguments.length===3){promise=this.findQuery(type,query);}else if(arguments.length===2){filter=query;}
type=this.modelFor(type);var array=DS.FilteredRecordArray.create({type:type,content:Ember.A(),store:this,manager:this.recordArrayManager,filterFunction:filter});this.recordArrayManager.registerFilteredRecordArray(array,type,filter);if(promise){return promise.then(function(){return array;});}else{return array;}},recordIsLoaded:function(type,id){if(!this.hasRecordForId(type,id)){return false;}
return!get(this.recordForId(type,id),'isEmpty');},dataWasUpdated:function(type,record){if(get(record,'isDeleted')){return;}
if(get(record,'isLoaded')){this.recordArrayManager.recordDidChange(record);}},scheduleSave:function(record,resolver){record.adapterWillCommit();this._pendingSave.push([record,resolver]);once(this,'flushPendingSave');},flushPendingSave:function(){var pending=this._pendingSave.slice();this._pendingSave=[];forEach(pending,function(tuple){var record=tuple[0],resolver=tuple[1],adapter=this.adapterForType(record.constructor),operation;if(get(record,'isNew')){operation='createRecord';}else if(get(record,'isDeleted')){operation='deleteRecord';}else{operation='updateRecord';}
_commit(adapter,this,operation,record,resolver);},this);},didSaveRecord:function(record,data){if(data){this.updateId(record,data);}
record.adapterDidCommit(data);},recordWasInvalid:function(record,errors){record.adapterDidInvalidate(errors);},recordWasError:function(record){record.adapterDidError();},updateId:function(record,data){var oldId=get(record,'id'),id=coerceId(data.id);Ember.assert("An adapter cannot assign a new id to a record that already has an id. "+record+" had id: "+oldId+" and you tried to update it with "+id+". This likely happened because your server returned data in response to a find or update that had a different id than the one you sent.",oldId===null||id===oldId);this.typeMapFor(record.constructor).idToRecord[id]=record;set(record,'id',id);},typeMapFor:function(type){var typeMaps=get(this,'typeMaps'),guid=Ember.guidFor(type),typeMap;typeMap=typeMaps[guid];if(typeMap){return typeMap;}
typeMap={idToRecord:{},records:[],metadata:{}};typeMaps[guid]=typeMap;return typeMap;},_load:function(type,data){var id=coerceId(data.id),record=this.recordForId(type,id);record.setupData(data);this.recordArrayManager.recordDidChange(record);return record;},modelFor:function(key){if(typeof key!=='string'){return key;}
var factory=this.container.lookupFactory('model:'+key);Ember.assert("No model was found for '"+key+"'",factory);factory.store=this;factory.typeKey=key;return factory;},push:function(type,data){var serializer=this.serializerFor(type);type=this.modelFor(type);data=serializer.deserialize(type,data);this._load(type,data);return this.recordForId(type,data.id);},pushMany:function(type,datas){return map(datas,function(data){return this.push(type,data);},this);},buildRecord:function(type,id,data){var typeMap=this.typeMapFor(type),idToRecord=typeMap.idToRecord;Ember.assert('The id '+id+' has already been used with another record of type '+type.toString()+'.',!id||!idToRecord[id]);var record=type._create({id:id,store:this,});if(data){record.setupData(data);}
if(id){idToRecord[id]=record;}
typeMap.records.push(record);return record;},dematerializeRecord:function(record){var type=record.constructor,typeMap=this.typeMapFor(type),id=get(record,'id');record.updateRecordArrays();if(id){delete typeMap.idToRecord[id];}
var loc=indexOf(typeMap.records,record);typeMap.records.splice(loc,1);},addRelationshipChangeFor:function(childRecord,childKey,parentRecord,parentKey,change){var clientId=childRecord.clientId,parentClientId=parentRecord?parentRecord:parentRecord;var key=childKey+parentKey;var changes=this._relationshipChanges;if(!(clientId in changes)){changes[clientId]={};}
if(!(parentClientId in changes[clientId])){changes[clientId][parentClientId]={};}
if(!(key in changes[clientId][parentClientId])){changes[clientId][parentClientId][key]={};}
changes[clientId][parentClientId][key][change.changeType]=change;},removeRelationshipChangeFor:function(clientRecord,childKey,parentRecord,parentKey,type){var clientId=clientRecord.clientId,parentClientId=parentRecord?parentRecord.clientId:parentRecord;var changes=this._relationshipChanges;var key=childKey+parentKey;if(!(clientId in changes)||!(parentClientId in changes[clientId])||!(key in changes[clientId][parentClientId])){return;}
delete changes[clientId][parentClientId][key][type];},relationshipChangePairsFor:function(record){var toReturn=[];if(!record){return toReturn;}
var changesObject=this._relationshipChanges[record.clientId];for(var objKey in changesObject){if(changesObject.hasOwnProperty(objKey)){for(var changeKey in changesObject[objKey]){if(changesObject[objKey].hasOwnProperty(changeKey)){toReturn.push(changesObject[objKey][changeKey]);}}}}
return toReturn;},adapterForType:function(type){var container=this.container,adapter;if(container){adapter=container.lookup('adapter:'+type.typeKey)||container.lookup('adapter:application');}
return adapter||get(this,'defaultAdapter');},serializerFor:function(type){var container=this.container;return container.lookup('serializer:'+type)||container.lookup('serializer:application')||container.lookup('serializer:_default');}});DS.PromiseArray=Ember.ArrayProxy.extend(Ember.PromiseProxyMixin);DS.PromiseObject=Ember.ObjectProxy.extend(Ember.PromiseProxyMixin);function promiseObject(promise){return DS.PromiseObject.create({promise:promise});}
function promiseArray(promise){return DS.PromiseArray.create({promise:promise});}
function isThenable(object){return object&&typeof object.then==='function';}
function serializerFor(adapter,type){var serializer=adapter.serializer,defaultSerializer=adapter.defaultSerializer,container=adapter.container;if(container&&serializer===undefined){serializer=container.lookup('serializer:'+type.typeKey)||container.lookup('serializer:application')||container.lookup('serializer:'+defaultSerializer||'serializer:_default');}
if(serializer===null||serializer===undefined){serializer={extract:function(store,type,payload){return payload;}};}
return serializer;}
function _find(adapter,store,type,id,resolver){var promise=adapter.find(store,type,id),serializer=serializerFor(adapter,type);return resolve(promise).then(function(payload){Ember.assert("You made a request for a "+type.typeKey+" with id "+id+", but the adapter's response did not have any data",payload);payload=serializer.extract(store,type,payload,id,'find');return store.push(type,payload);}).then(resolver.resolve,resolver.reject);}
function _findMany(adapter,store,type,ids,owner,resolver){var promise=adapter.findMany(store,type,ids,owner),serializer=serializerFor(adapter,type);return resolve(promise).then(function(payload){payload=serializer.extract(store,type,payload,null,'findMany');store.pushMany(type,payload);}).then(resolver.resolve,resolver.reject);}
function _findHasMany(adapter,store,record,link,relationship,resolver){var promise=adapter.findHasMany(store,record,link,relationship),serializer=serializerFor(adapter,relationship.type);return resolve(promise).then(function(payload){payload=serializer.extract(store,relationship.type,payload,null,'findHasMany');var records=store.pushMany(relationship.type,payload);record.updateHasMany(relationship.key,records);}).then(resolver.resolve,resolver.reject);}
function _findAll(adapter,store,type,sinceToken,resolver){var promise=adapter.findAll(store,type,sinceToken),serializer=serializerFor(adapter,type);return resolve(promise).then(function(payload){payload=serializer.extract(store,type,payload,null,'findAll');store.pushMany(type,payload);store.didUpdateAll(type);return store.all(type);}).then(resolver.resolve,resolver.reject);}
function _findQuery(adapter,store,type,query,recordArray,resolver){var promise=adapter.findQuery(store,type,query,recordArray),serializer=serializerFor(adapter,type);return resolve(promise).then(function(payload){payload=serializer.extract(store,type,payload,null,'findAll');recordArray.load(payload);return recordArray;}).then(resolver.resolve,resolver.reject);}
function _commit(adapter,store,operation,record,resolver){var type=record.constructor,promise=adapter[operation](store,type,record),serializer=serializerFor(adapter,type);Ember.assert("Your adapter's '"+operation+"' method must return a promise, but it returned "+promise,isThenable(promise));return promise.then(function(payload){payload=serializer.extract(store,type,payload,get(record,'id'),operation);store.didSaveRecord(record,payload);return record;},function(reason){if(reason instanceof DS.InvalidError){store.recordWasInvalid(record,reason.errors);}else{store.recordWasError(record,reason);}
throw reason;}).then(resolver.resolve,resolver.reject);}})();(function(){var get=Ember.get,set=Ember.set,once=Ember.run.once,arrayMap=Ember.ArrayPolyfills.map;var hasDefinedProperties=function(object){var names=Ember.keys(object);var i,l,name;for(i=0,l=names.length;i<l;i++){name=names[i];if(object.hasOwnProperty(name)&&object[name]){return true;}}
return false;};var didSetProperty=function(record,context){if(context.value!==context.oldValue){record.send('becomeDirty');record.updateRecordArraysLater();}};var DirtyState={initialState:'uncommitted',isDirty:true,uncommitted:{didSetProperty:didSetProperty,pushedData:Ember.K,becomeDirty:Ember.K,willCommit:function(record){record.transitionTo('inFlight');},reloadRecord:function(record,resolver){get(record,'store').reloadRecord(record,resolver);},rolledBack:function(record){record.transitionTo('loaded.saved');},becameInvalid:function(record){record.transitionTo('invalid');},rollback:function(record){record.rollback();}},inFlight:{isSaving:true,didSetProperty:didSetProperty,becomeDirty:Ember.K,pushedData:Ember.K,willCommit:Ember.K,didCommit:function(record){var dirtyType=get(this,'dirtyType');record.transitionTo('saved');record.send('invokeLifecycleCallbacks',dirtyType);},becameInvalid:function(record,errors){set(record,'errors',errors);record.transitionTo('invalid');record.send('invokeLifecycleCallbacks');},becameError:function(record){record.transitionTo('uncommitted');record.triggerLater('becameError',record);}},invalid:{isValid:false,deleteRecord:function(record){record.transitionTo('deleted.uncommitted');record.clearRelationships();},didSetProperty:function(record,context){var errors=get(record,'errors'),key=context.name;set(errors,key,null);if(!hasDefinedProperties(errors)){record.send('becameValid');}
didSetProperty(record,context);},becomeDirty:Ember.K,rollback:function(record){record.send('becameValid');record.send('rollback');},becameValid:function(record){record.transitionTo('uncommitted');},invokeLifecycleCallbacks:function(record){record.triggerLater('becameInvalid',record);}}};function deepClone(object){var clone={},value;for(var prop in object){value=object[prop];if(value&&typeof value==='object'){clone[prop]=deepClone(value);}else{clone[prop]=value;}}
return clone;}
function mixin(original,hash){for(var prop in hash){original[prop]=hash[prop];}
return original;}
function dirtyState(options){var newState=deepClone(DirtyState);return mixin(newState,options);}
var createdState=dirtyState({dirtyType:'created',isNew:true});var updatedState=dirtyState({dirtyType:'updated'});createdState.uncommitted.deleteRecord=function(record){record.clearRelationships();record.transitionTo('deleted.saved');};createdState.uncommitted.rollback=function(record){DirtyState.uncommitted.rollback.apply(this,arguments);record.transitionTo('deleted.saved');};updatedState.uncommitted.deleteRecord=function(record){record.transitionTo('deleted.uncommitted');record.clearRelationships();};var RootState={isEmpty:false,isLoading:false,isLoaded:false,isDirty:false,isSaving:false,isDeleted:false,isNew:false,isValid:true,rolledBack:Ember.K,empty:{isEmpty:true,loadingData:function(record){record.transitionTo('loading');},loadedData:function(record){record.transitionTo('loaded.created.uncommitted');record.suspendRelationshipObservers(function(){record.notifyPropertyChange('data');});},pushedData:function(record){record.transitionTo('loaded.saved');}},loading:{isLoading:true,pushedData:function(record){record.transitionTo('loaded.saved');record.triggerLater('didLoad');set(record,'isError',false);},becameError:function(record){record.triggerLater('becameError',record);}},loaded:{initialState:'saved',isLoaded:true,saved:{setup:function(record){var attrs=record._attributes,isDirty=false;for(var prop in attrs){if(attrs.hasOwnProperty(prop)){isDirty=true;break;}}
if(isDirty){record.adapterDidDirty();}},didSetProperty:didSetProperty,pushedData:Ember.K,becomeDirty:function(record){record.transitionTo('updated.uncommitted');},willCommit:function(record){record.transitionTo('updated.inFlight');},reloadRecord:function(record,resolver){get(record,'store').reloadRecord(record,resolver);},deleteRecord:function(record){record.transitionTo('deleted.uncommitted');record.clearRelationships();},unloadRecord:function(record){record.clearRelationships();record.transitionTo('deleted.saved');},didCommit:function(record){record.send('invokeLifecycleCallbacks',get(record,'lastDirtyType'));},},created:createdState,updated:updatedState},deleted:{initialState:'uncommitted',dirtyType:'deleted',isDeleted:true,isLoaded:true,isDirty:true,setup:function(record){var store=get(record,'store');store.recordArrayManager.remove(record);},uncommitted:{willCommit:function(record){record.transitionTo('inFlight');},rollback:function(record){record.rollback();},becomeDirty:Ember.K,deleteRecord:Ember.K,rolledBack:function(record){record.transitionTo('loaded.saved');}},inFlight:{isSaving:true,willCommit:Ember.K,didCommit:function(record){record.transitionTo('saved');record.send('invokeLifecycleCallbacks');},becameError:function(record){record.transitionTo('uncommitted');record.triggerLater('becameError',record);}},saved:{isDirty:false,setup:function(record){var store=get(record,'store');store.dematerializeRecord(record);},invokeLifecycleCallbacks:function(record){record.triggerLater('didDelete',record);record.triggerLater('didCommit',record);}}},invokeLifecycleCallbacks:function(record,dirtyType){if(dirtyType==='created'){record.triggerLater('didCreate',record);}else{record.triggerLater('didUpdate',record);}
record.triggerLater('didCommit',record);}};var hasOwnProp={}.hasOwnProperty;function wireState(object,parent,name){object=mixin(parent?Ember.create(parent):{},object);object.parentState=parent;object.stateName=name;for(var prop in object){if(!object.hasOwnProperty(prop)||prop==='parentState'||prop==='stateName'){continue;}
if(typeof object[prop]==='object'){object[prop]=wireState(object[prop],object,name+"."+prop);}}
return object;}
RootState=wireState(RootState,null,"root");DS.RootState=RootState;})();(function(){var get=Ember.get,set=Ember.set,map=Ember.EnumerableUtils.map,merge=Ember.merge,once=Ember.run.once;var arrayMap=Ember.ArrayPolyfills.map;var retrieveFromCurrentState=Ember.computed(function(key,value){return get(get(this,'currentState'),key);}).property('currentState').readOnly();DS.Model=Ember.Object.extend(Ember.Evented,{isEmpty:retrieveFromCurrentState,isLoading:retrieveFromCurrentState,isLoaded:retrieveFromCurrentState,isDirty:retrieveFromCurrentState,isSaving:retrieveFromCurrentState,isDeleted:retrieveFromCurrentState,isNew:retrieveFromCurrentState,isValid:retrieveFromCurrentState,dirtyType:retrieveFromCurrentState,isError:false,isReloading:false,clientId:null,id:null,transaction:null,currentState:null,errors:null,serialize:function(options){var store=get(this,'store');return store.serialize(this,options);},toJSON:function(options){var serializer=DS.JSONSerializer.create();return serializer.serialize(this,options);},didLoad:Ember.K,didReload:Ember.K,didUpdate:Ember.K,didCreate:Ember.K,didDelete:Ember.K,becameInvalid:Ember.K,becameError:Ember.K,data:Ember.computed(function(){this._data=this._data||{};return this._data;}).property(),_data:null,init:function(){set(this,'currentState',DS.RootState.empty);this._super();this._setup();},_setup:function(){this._changesToSync={};this._deferredTriggers=[];this._data={};this._attributes={};this._inFlightAttributes={};this._relationships={};},send:function(name,context){var currentState=get(this,'currentState');if(!currentState[name]){this._unhandledEvent(currentState,name,context);}
return currentState[name](this,context);},transitionTo:function(name){var pivotName=name.split(".",1),currentState=get(this,'currentState'),state=currentState;do{if(state.exit){state.exit(this);}
state=state.parentState;}while(!state.hasOwnProperty(pivotName));var path=name.split(".");var setups=[],enters=[],i,l;for(i=0,l=path.length;i<l;i++){state=state[path[i]];if(state.enter){enters.push(state);}
if(state.setup){setups.push(state);}}
for(i=0,l=enters.length;i<l;i++){enters[i].enter(this);}
set(this,'currentState',state);for(i=0,l=setups.length;i<l;i++){setups[i].setup(this);}},_unhandledEvent:function(state,name,context){var errorMessage="Attempted to handle event `"+name+"` ";errorMessage+="on "+String(this)+" while in state ";errorMessage+=state.stateName+". ";if(context!==undefined){errorMessage+="Called with "+Ember.inspect(context)+".";}
throw new Ember.Error(errorMessage);},withTransaction:function(fn){var transaction=get(this,'transaction');if(transaction){fn(transaction);}},loadingData:function(){this.send('loadingData');},loadedData:function(){this.send('loadedData');},pushedData:function(){this.send('pushedData');},deleteRecord:function(){this.send('deleteRecord');},unloadRecord:function(){Ember.assert("You can only unload a loaded, non-dirty record.",!get(this,'isDirty'));this.send('unloadRecord');},clearRelationships:function(){this.eachRelationship(function(name,relationship){if(relationship.kind==='belongsTo'){set(this,name,null);}else if(relationship.kind==='hasMany'){var hasMany=this._relationships[relationship.name];if(hasMany){hasMany.clear();}}},this);},updateRecordArrays:function(){var store=get(this,'store');if(store){store.dataWasUpdated(this.constructor,this);}},adapterWillCommit:function(){this.send('willCommit');},adapterDidCommit:function(data){set(this,'isError',false);if(data){this._data=data;}else{Ember.mixin(this._data,this._inFlightAttributes);}
this._inFlightAttributes={};this.send('didCommit');this.updateRecordArraysLater();if(!data){return;}
this.suspendRelationshipObservers(function(){this.notifyPropertyChange('data');});},adapterDidDirty:function(){this.send('becomeDirty');this.updateRecordArraysLater();},dataDidChange:Ember.observer(function(){this.reloadHasManys();},'data'),reloadHasManys:function(){var relationships=get(this.constructor,'relationshipsByName');this.updateRecordArraysLater();relationships.forEach(function(name,relationship){if(relationship.kind==='hasMany'){this.hasManyDidChange(relationship.key);}},this);},hasManyDidChange:function(key){var hasMany=this._relationships[key];if(hasMany){var type=get(this.constructor,'relationshipsByName').get(key).type;var store=get(this,'store');var records=this._data[key]||[];set(hasMany,'content',Ember.A(records));set(hasMany,'isLoaded',true);hasMany.trigger('didLoad');}},updateRecordArraysLater:function(){Ember.run.once(this,this.updateRecordArrays);},setupData:function(data){this._data=data;if(data){this.pushedData();}
this.suspendRelationshipObservers(function(){this.notifyPropertyChange('data');});},materializeId:function(id){set(this,'id',id);},materializeAttributes:function(attributes){Ember.assert("Must pass a hash of attributes to materializeAttributes",!!attributes);merge(this._data,attributes);},materializeAttribute:function(name,value){this._data[name]=value;},updateHasMany:function(name,records){this._data[name]=records;this.hasManyDidChange(name);},rollback:function(){this._attributes={};this.send('rolledBack');this.suspendRelationshipObservers(function(){this.notifyPropertyChange('data');});},toStringExtension:function(){return get(this,'id');},suspendRelationshipObservers:function(callback,binding){var observers=get(this.constructor,'relationshipNames').belongsTo;var self=this;try{this._suspendedRelationships=true;Ember._suspendObservers(self,observers,null,'belongsToDidChange',function(){Ember._suspendBeforeObservers(self,observers,null,'belongsToWillChange',function(){callback.call(binding||self);});});}finally{this._suspendedRelationships=false;}},save:function(){var resolver=Ember.RSVP.defer(),record=this;this.get('store').scheduleSave(this,resolver);this._inFlightAttributes=this._attributes;this._attributes={};return DS.PromiseObject.create({promise:resolver.promise});},reload:function(){set(this,'isReloading',true);var resolver=Ember.RSVP.defer(),record=this;resolver.promise=resolver.promise.then(function(){record.set('isReloading',false);record.set('isError',false);return record;},function(reason){record.set('isError',true);throw reason;});this.send('reloadRecord',resolver);return DS.PromiseObject.create({promise:resolver.promise});},adapterDidUpdateAttribute:function(attributeName,value){if(value!==undefined){this._data[attributeName]=value;this.notifyPropertyChange(attributeName);}else{this._data[attributeName]=this._inFlightAttributes[attributeName];}
this.updateRecordArraysLater();},adapterDidInvalidate:function(errors){this.send('becameInvalid',errors);},adapterDidError:function(){this.send('becameError');set(this,'isError',true);},trigger:function(name){Ember.tryInvoke(this,name,[].slice.call(arguments,1));this._super.apply(this,arguments);},triggerLater:function(){this._deferredTriggers.push(arguments);once(this,'_triggerDeferredTriggers');},_triggerDeferredTriggers:function(){for(var i=0,l=this._deferredTriggers.length;i<l;i++){this.trigger.apply(this,this._deferredTriggers[i]);}
this._deferredTriggers=[];}});DS.Model.reopenClass({_create:DS.Model.create,create:function(){throw new Ember.Error("You should not call `create` on a model. Instead, call `store.createRecord` with the attributes you would like to set.");}});})();(function(){var get=Ember.get;DS.Model.reopenClass({attributes:Ember.computed(function(){var map=Ember.Map.create();this.eachComputedProperty(function(name,meta){if(meta.isAttribute){Ember.assert("You may not set `id` as an attribute on your model. Please remove any lines that look like: `id: DS.attr('<type>')` from "+this.toString(),name!=='id');meta.name=name;map.set(name,meta);}});return map;}),transformedAttributes:Ember.computed(function(){var map=Ember.Map.create();this.eachAttribute(function(key,meta){if(meta.type){map.set(key,meta.type);}});return map;}),eachAttribute:function(callback,binding){get(this,'attributes').forEach(function(name,meta){callback.call(binding,name,meta);},binding);},eachTransformedAttribute:function(callback,binding){get(this,'transformedAttributes').forEach(function(name,type){callback.call(binding,name,type);});}});DS.Model.reopen({eachAttribute:function(callback,binding){this.constructor.eachAttribute(callback,binding);}});function getDefaultValue(record,options,key){if(typeof options.defaultValue==="function"){return options.defaultValue();}else{return options.defaultValue;}}
function hasValue(record,key){return record._attributes.hasOwnProperty(key)||record._inFlightAttributes.hasOwnProperty(key)||record._data.hasOwnProperty(key);}
function getValue(record,key){if(record._attributes.hasOwnProperty(key)){return record._attributes[key];}else if(record._inFlightAttributes.hasOwnProperty(key)){return record._inFlightAttributes[key];}else{return record._data[key];}}
DS.attr=function(type,options){options=options||{};var meta={type:type,isAttribute:true,options:options};return Ember.computed(function(key,value,oldValue){var currentValue;if(arguments.length>1){Ember.assert("You may not set `id` as an attribute on your model. Please remove any lines that look like: `id: DS.attr('<type>')` from "+this.constructor.toString(),key!=='id');this.send('didSetProperty',{name:key,oldValue:this._attributes[key]||this._inFlightAttributes[key]||this._data[key],value:value});this._attributes[key]=value;return value;}else if(hasValue(this,key)){return getValue(this,key);}else{return getDefaultValue(this,options,key);}}).property('data').meta(meta);};})();(function(){})();(function(){var AttributeChange=DS.AttributeChange=function(options){this.record=options.record;this.store=options.store;this.name=options.name;this.value=options.value;this.oldValue=options.oldValue;};AttributeChange.createChange=function(options){return new AttributeChange(options);};AttributeChange.prototype={sync:function(){if(this.value!==this.oldValue){this.record.send('becomeDirty');this.record.updateRecordArraysLater();}
this.destroy();},destroy:function(){delete this.record._changesToSync[this.name];}};})();(function(){var get=Ember.get,set=Ember.set;var forEach=Ember.EnumerableUtils.forEach;DS.RelationshipChange=function(options){this.parentRecord=options.parentRecord;this.childRecord=options.childRecord;this.firstRecord=options.firstRecord;this.firstRecordKind=options.firstRecordKind;this.firstRecordName=options.firstRecordName;this.secondRecord=options.secondRecord;this.secondRecordKind=options.secondRecordKind;this.secondRecordName=options.secondRecordName;this.changeType=options.changeType;this.store=options.store;this.committed={};};DS.RelationshipChangeAdd=function(options){DS.RelationshipChange.call(this,options);};DS.RelationshipChangeRemove=function(options){DS.RelationshipChange.call(this,options);};DS.RelationshipChange.create=function(options){return new DS.RelationshipChange(options);};DS.RelationshipChangeAdd.create=function(options){return new DS.RelationshipChangeAdd(options);};DS.RelationshipChangeRemove.create=function(options){return new DS.RelationshipChangeRemove(options);};DS.OneToManyChange={};DS.OneToNoneChange={};DS.ManyToNoneChange={};DS.OneToOneChange={};DS.ManyToManyChange={};DS.RelationshipChange._createChange=function(options){if(options.changeType==="add"){return DS.RelationshipChangeAdd.create(options);}
if(options.changeType==="remove"){return DS.RelationshipChangeRemove.create(options);}};DS.RelationshipChange.determineRelationshipType=function(recordType,knownSide){var knownKey=knownSide.key,key,otherKind;var knownKind=knownSide.kind;var inverse=recordType.inverseFor(knownKey);if(inverse){key=inverse.name;otherKind=inverse.kind;}
if(!inverse){return knownKind==="belongsTo"?"oneToNone":"manyToNone";}
else{if(otherKind==="belongsTo"){return knownKind==="belongsTo"?"oneToOne":"manyToOne";}
else{return knownKind==="belongsTo"?"oneToMany":"manyToMany";}}};DS.RelationshipChange.createChange=function(firstRecord,secondRecord,store,options){var firstRecordType=firstRecord.constructor,changeType;changeType=DS.RelationshipChange.determineRelationshipType(firstRecordType,options);if(changeType==="oneToMany"){return DS.OneToManyChange.createChange(firstRecord,secondRecord,store,options);}
else if(changeType==="manyToOne"){return DS.OneToManyChange.createChange(secondRecord,firstRecord,store,options);}
else if(changeType==="oneToNone"){return DS.OneToNoneChange.createChange(firstRecord,secondRecord,store,options);}
else if(changeType==="manyToNone"){return DS.ManyToNoneChange.createChange(firstRecord,secondRecord,store,options);}
else if(changeType==="oneToOne"){return DS.OneToOneChange.createChange(firstRecord,secondRecord,store,options);}
else if(changeType==="manyToMany"){return DS.ManyToManyChange.createChange(firstRecord,secondRecord,store,options);}};DS.OneToNoneChange.createChange=function(childRecord,parentRecord,store,options){var key=options.key;var change=DS.RelationshipChange._createChange({parentRecord:parentRecord,childRecord:childRecord,firstRecord:childRecord,store:store,changeType:options.changeType,firstRecordName:key,firstRecordKind:"belongsTo"});store.addRelationshipChangeFor(childRecord,key,parentRecord,null,change);return change;};DS.ManyToNoneChange.createChange=function(childRecord,parentRecord,store,options){var key=options.key;var change=DS.RelationshipChange._createChange({parentRecord:childRecord,childRecord:parentRecord,secondRecord:childRecord,store:store,changeType:options.changeType,secondRecordName:options.key,secondRecordKind:"hasMany"});store.addRelationshipChangeFor(childRecord,key,parentRecord,null,change);return change;};DS.ManyToManyChange.createChange=function(childRecord,parentRecord,store,options){var key=options.key;var change=DS.RelationshipChange._createChange({parentRecord:parentRecord,childRecord:childRecord,firstRecord:childRecord,secondRecord:parentRecord,firstRecordKind:"hasMany",secondRecordKind:"hasMany",store:store,changeType:options.changeType,firstRecordName:key});store.addRelationshipChangeFor(childRecord,key,parentRecord,null,change);return change;};DS.OneToOneChange.createChange=function(childRecord,parentRecord,store,options){var key;if(options.parentType){key=options.parentType.inverseFor(options.key).name;}else if(options.key){key=options.key;}else{Ember.assert("You must pass either a parentType or belongsToName option to OneToManyChange.forChildAndParent",false);}
var change=DS.RelationshipChange._createChange({parentRecord:parentRecord,childRecord:childRecord,firstRecord:childRecord,secondRecord:parentRecord,firstRecordKind:"belongsTo",secondRecordKind:"belongsTo",store:store,changeType:options.changeType,firstRecordName:key});store.addRelationshipChangeFor(childRecord,key,parentRecord,null,change);return change;};DS.OneToOneChange.maintainInvariant=function(options,store,childRecord,key){if(options.changeType==="add"&&store.recordIsMaterialized(childRecord)){var oldParent=get(childRecord,key);if(oldParent){var correspondingChange=DS.OneToOneChange.createChange(childRecord,oldParent,store,{parentType:options.parentType,hasManyName:options.hasManyName,changeType:"remove",key:options.key});store.addRelationshipChangeFor(childRecord,key,options.parentRecord,null,correspondingChange);correspondingChange.sync();}}};DS.OneToManyChange.createChange=function(childRecord,parentRecord,store,options){var key;if(options.parentType){key=options.parentType.inverseFor(options.key).name;DS.OneToManyChange.maintainInvariant(options,store,childRecord,key);}else if(options.key){key=options.key;}else{Ember.assert("You must pass either a parentType or belongsToName option to OneToManyChange.forChildAndParent",false);}
var change=DS.RelationshipChange._createChange({parentRecord:parentRecord,childRecord:childRecord,firstRecord:childRecord,secondRecord:parentRecord,firstRecordKind:"belongsTo",secondRecordKind:"hasMany",store:store,changeType:options.changeType,firstRecordName:key});store.addRelationshipChangeFor(childRecord,key,parentRecord,change.getSecondRecordName(),change);return change;};DS.OneToManyChange.maintainInvariant=function(options,store,childRecord,key){if(options.changeType==="add"&&childRecord){var oldParent=get(childRecord,key);if(oldParent){var correspondingChange=DS.OneToManyChange.createChange(childRecord,oldParent,store,{parentType:options.parentType,hasManyName:options.hasManyName,changeType:"remove",key:options.key});store.addRelationshipChangeFor(childRecord,key,options.parentRecord,correspondingChange.getSecondRecordName(),correspondingChange);correspondingChange.sync();}}};DS.RelationshipChange.prototype={getSecondRecordName:function(){var name=this.secondRecordName,parent;if(!name){parent=this.secondRecord;if(!parent){return;}
var childType=this.firstRecord.constructor;var inverse=childType.inverseFor(this.firstRecordName);this.secondRecordName=inverse.name;}
return this.secondRecordName;},getFirstRecordName:function(){var name=this.firstRecordName;return name;},destroy:function(){var childRecord=this.childRecord,belongsToName=this.getFirstRecordName(),hasManyName=this.getSecondRecordName(),store=this.store;store.removeRelationshipChangeFor(childRecord,belongsToName,this.parentRecord,hasManyName,this.changeType);},getSecondRecord:function(){return this.secondRecord;},getFirstRecord:function(){return this.firstRecord;},coalesce:function(){var relationshipPairs=this.store.relationshipChangePairsFor(this.firstRecord);forEach(relationshipPairs,function(pair){var addedChange=pair["add"];var removedChange=pair["remove"];if(addedChange&&removedChange){addedChange.destroy();removedChange.destroy();}});}};DS.RelationshipChangeAdd.prototype=Ember.create(DS.RelationshipChange.create({}));DS.RelationshipChangeRemove.prototype=Ember.create(DS.RelationshipChange.create({}));function isValue(object){return typeof object==='object'&&(!object.then||typeof object.then!=='function');}
DS.RelationshipChangeAdd.prototype.changeType="add";DS.RelationshipChangeAdd.prototype.sync=function(){var secondRecordName=this.getSecondRecordName(),firstRecordName=this.getFirstRecordName(),firstRecord=this.getFirstRecord(),secondRecord=this.getSecondRecord();if(secondRecord instanceof DS.Model&&firstRecord instanceof DS.Model){if(this.secondRecordKind==="belongsTo"){secondRecord.suspendRelationshipObservers(function(){set(secondRecord,secondRecordName,firstRecord);});}
else if(this.secondRecordKind==="hasMany"){secondRecord.suspendRelationshipObservers(function(){var relationship=get(secondRecord,secondRecordName);if(isValue(relationship)){relationship.addObject(firstRecord);}});}}
if(firstRecord instanceof DS.Model&&secondRecord instanceof DS.Model&&get(firstRecord,firstRecordName)!==secondRecord){if(this.firstRecordKind==="belongsTo"){firstRecord.suspendRelationshipObservers(function(){set(firstRecord,firstRecordName,secondRecord);});}
else if(this.firstRecordKind==="hasMany"){firstRecord.suspendRelationshipObservers(function(){var relationship=get(firstRecord,firstRecordName);if(isValue(relationship)){relationship.addObject(secondRecord);}});}}
this.coalesce();};DS.RelationshipChangeRemove.prototype.changeType="remove";DS.RelationshipChangeRemove.prototype.sync=function(){var secondRecordName=this.getSecondRecordName(),firstRecordName=this.getFirstRecordName(),firstRecord=this.getFirstRecord(),secondRecord=this.getSecondRecord();if(secondRecord instanceof DS.Model&&firstRecord instanceof DS.Model){if(this.secondRecordKind==="belongsTo"){secondRecord.suspendRelationshipObservers(function(){set(secondRecord,secondRecordName,null);});}
else if(this.secondRecordKind==="hasMany"){secondRecord.suspendRelationshipObservers(function(){var relationship=get(secondRecord,secondRecordName);if(isValue(relationship)){relationship.removeObject(firstRecord);}});}}
if(firstRecord instanceof DS.Model&&get(firstRecord,firstRecordName)){if(this.firstRecordKind==="belongsTo"){firstRecord.suspendRelationshipObservers(function(){set(firstRecord,firstRecordName,null);});}
else if(this.firstRecordKind==="hasMany"){firstRecord.suspendRelationshipObservers(function(){var relationship=get(firstRecord,firstRecordName);if(isValue(relationship)){relationship.removeObject(secondRecord);}});}}
this.coalesce();};})();(function(){})();(function(){var get=Ember.get,set=Ember.set,isNone=Ember.isNone;function asyncBelongsTo(type,options,meta){return Ember.computed(function(key,value){var data=get(this,'data'),store=get(this,'store');if(arguments.length===2){Ember.assert("You can only add a '"+type+"' record to this relationship",!value||value instanceof store.modelFor(type));return value===undefined?null:value;}
return store.fetchRecord(data[key]);}).property('data').meta(meta);}
DS.belongsTo=function(type,options){Ember.assert("The first argument DS.belongsTo must be a model type or string, like DS.belongsTo(App.Person)",!!type&&(typeof type==='string'||DS.Model.detect(type)));options=options||{};var meta={type:type,isRelationship:true,options:options,kind:'belongsTo'};if(options.async){return asyncBelongsTo(type,options,meta);}
return Ember.computed(function(key,value){var data=get(this,'data'),store=get(this,'store'),belongsTo,typeClass;if(typeof type==='string'){if(type.indexOf(".")===-1){typeClass=store.modelFor(type);}else{typeClass=get(Ember.lookup,type);}}else{typeClass=type;}
if(arguments.length===2){Ember.assert("You can only add a '"+type+"' record to this relationship",!value||value instanceof typeClass);return value===undefined?null:value;}
belongsTo=data[key];if(isNone(belongsTo)){return null;}
if(get(belongsTo,'isEmpty')){store.fetchRecord(belongsTo);}
return belongsTo;}).property('data').meta(meta);};DS.Model.reopen({belongsToWillChange:Ember.beforeObserver(function(record,key){if(get(record,'isLoaded')){var oldParent=get(record,key),store=get(record,'store');if(oldParent){var change=DS.RelationshipChange.createChange(record,oldParent,store,{key:key,kind:"belongsTo",changeType:"remove"});change.sync();this._changesToSync[key]=change;}}}),belongsToDidChange:Ember.immediateObserver(function(record,key){if(get(record,'isLoaded')){var newParent=get(record,key);if(newParent){var store=get(record,'store'),change=DS.RelationshipChange.createChange(record,newParent,store,{key:key,kind:"belongsTo",changeType:"add"});change.sync();}}
delete this._changesToSync[key];})});})();(function(){var get=Ember.get,set=Ember.set,setProperties=Ember.setProperties;var forEach=Ember.EnumerableUtils.forEach;function asyncHasMany(type,options,meta){return Ember.computed(function(key,value){var resolver=Ember.RSVP.defer();var relationship=buildRelationship(this,key,options,function(store,data){var link=data.links&&data.links[key];if(link){return store.findHasMany(this,link,meta,resolver);}else{return store.findMany(this,data[key],meta.type,resolver);}});var promise=resolver.promise.then(function(){return relationship;});return DS.PromiseArray.create({promise:promise});}).property('data').meta(meta);}
function buildRelationship(record,key,options,callback){var rels=record._relationships;if(rels[key]){return rels[key];}
var data=get(record,'data'),store=get(record,'store');var relationship=rels[key]=callback.call(record,store,data);return setProperties(relationship,{owner:record,name:key,isPolymorphic:options.polymorphic});}
function hasRelationship(type,options){options=options||{};var meta={type:type,isRelationship:true,options:options,kind:'hasMany'};if(options.async){return asyncHasMany(type,options,meta);}
return Ember.computed(function(key,value){return buildRelationship(this,key,options,function(store,data){var records=data[key];Ember.assert("You looked up the '"+key+"' relationship on '"+this+"' but some of the associated records were not loaded. Either make sure they are all loaded together with the parent record, or specify that the relationship is async (`DS.attr({ async: true })`)",Ember.A(records).everyProperty('isEmpty',false));return store.findMany(this,data[key],meta.type);});}).property('data').meta(meta);}
DS.hasMany=function(type,options){Ember.assert("The type passed to DS.hasMany must be defined",!!type);return hasRelationship(type,options);};})();(function(){var get=Ember.get,set=Ember.set;DS.Model.reopen({didDefineProperty:function(proto,key,value){if(value instanceof Ember.Descriptor){var meta=value.meta();if(meta.isRelationship&&meta.kind==='belongsTo'){Ember.addObserver(proto,key,null,'belongsToDidChange');Ember.addBeforeObserver(proto,key,null,'belongsToWillChange');}
meta.parentType=proto.constructor;}}});DS.Model.reopenClass({typeForRelationship:function(name){var relationship=get(this,'relationshipsByName').get(name);return relationship&&relationship.type;},inverseFor:function(name){var inverseType=this.typeForRelationship(name);if(!inverseType){return null;}
var options=this.metaForProperty(name).options;if(options.inverse===null){return null;}
var inverseName,inverseKind;if(options.inverse){inverseName=options.inverse;inverseKind=Ember.get(inverseType,'relationshipsByName').get(inverseName).kind;}else{var possibleRelationships=findPossibleInverses(this,inverseType);if(possibleRelationships.length===0){return null;}
Ember.assert("You defined the '"+name+"' relationship on "+this+", but multiple possible inverse relationships of type "+this+" were found on "+inverseType+".",possibleRelationships.length===1);inverseName=possibleRelationships[0].name;inverseKind=possibleRelationships[0].kind;}
function findPossibleInverses(type,inverseType,possibleRelationships){possibleRelationships=possibleRelationships||[];var relationshipMap=get(inverseType,'relationships');if(!relationshipMap){return;}
var relationships=relationshipMap.get(type);if(relationships){possibleRelationships.push.apply(possibleRelationships,relationshipMap.get(type));}
if(type.superclass){findPossibleInverses(type.superclass,inverseType,possibleRelationships);}
return possibleRelationships;}
return{type:inverseType,name:inverseName,kind:inverseKind};},relationships:Ember.computed(function(){var map=new Ember.MapWithDefault({defaultValue:function(){return[];}});this.eachComputedProperty(function(name,meta){if(meta.isRelationship){if(typeof meta.type==='string'){meta.type=Ember.get(Ember.lookup,meta.type);}
var relationshipsForType=map.get(meta.type);relationshipsForType.push({name:name,kind:meta.kind});}});return map;}),relationshipNames:Ember.computed(function(){var names={hasMany:[],belongsTo:[]};this.eachComputedProperty(function(name,meta){if(meta.isRelationship){names[meta.kind].push(name);}});return names;}),relatedTypes:Ember.computed(function(){var type,types=Ember.A();this.eachComputedProperty(function(name,meta){if(meta.isRelationship){type=meta.type;if(typeof type==='string'){type=get(this,type,false)||get(Ember.lookup,type);}
Ember.assert("You specified a hasMany ("+meta.type+") on "+meta.parentType+" but "+meta.type+" was not found.",type);if(!types.contains(type)){Ember.assert("Trying to sideload "+name+" on "+this.toString()+" but the type doesn't exist.",!!type);types.push(type);}}});return types;}),relationshipsByName:Ember.computed(function(){var map=Ember.Map.create(),type;this.eachComputedProperty(function(name,meta){if(meta.isRelationship){meta.key=name;type=meta.type;if(typeof type==='string'){meta.type=this.store.modelFor(type);}
map.set(name,meta);}});return map;}),fields:Ember.computed(function(){var map=Ember.Map.create();this.eachComputedProperty(function(name,meta){if(meta.isRelationship){map.set(name,meta.kind);}else if(meta.isAttribute){map.set(name,'attribute');}});return map;}),eachRelationship:function(callback,binding){get(this,'relationshipsByName').forEach(function(name,relationship){callback.call(binding,name,relationship);});},eachRelatedType:function(callback,binding){get(this,'relatedTypes').forEach(function(type){callback.call(binding,type);});}});DS.Model.reopen({eachRelationship:function(callback,binding){this.constructor.eachRelationship(callback,binding);}});})();(function(){})();(function(){var get=Ember.get,set=Ember.set;var once=Ember.run.once;var forEach=Ember.EnumerableUtils.forEach;DS.RecordArrayManager=Ember.Object.extend({init:function(){this.filteredRecordArrays=Ember.MapWithDefault.create({defaultValue:function(){return[];}});this.changedRecords=[];},recordDidChange:function(record){this.changedRecords.push(record);once(this,this.updateRecordArrays);},recordArraysForRecord:function(record){record._recordArrays=record._recordArrays||Ember.OrderedSet.create();return record._recordArrays;},updateRecordArrays:function(){forEach(this.changedRecords,function(record){var type=record.constructor,recordArrays=this.filteredRecordArrays.get(type),filter;forEach(recordArrays,function(array){filter=get(array,'filterFunction');this.updateRecordArray(array,filter,type,record);},this);var manyArrays=record._loadingRecordArrays;if(manyArrays){for(var i=0,l=manyArrays.length;i<l;i++){manyArrays[i].loadedRecord();}
record._loadingRecordArrays=[];}},this);this.changedRecords=[];},updateRecordArray:function(array,filter,type,record){var shouldBeInArray;if(!filter){shouldBeInArray=true;}else{shouldBeInArray=filter(record);}
var recordArrays=this.recordArraysForRecord(record);if(shouldBeInArray){recordArrays.add(array);array.addRecord(record);}else if(!shouldBeInArray){recordArrays.remove(array);array.removeRecord(record);}},remove:function(record){var recordArrays=record._recordArrays;if(!recordArrays){return;}
forEach(recordArrays,function(array){array.removeRecord(record);});},updateFilter:function(array,type,filter){var typeMap=this.store.typeMapFor(type),records=typeMap.records,record;for(var i=0,l=records.length;i<l;i++){record=records[i];if(!get(record,'isDeleted')&&!get(record,'isEmpty')){this.updateRecordArray(array,filter,type,record);}}},createManyArray:function(type,records){var manyArray=DS.ManyArray.create({type:type,content:records,store:this.store});forEach(records,function(record){var arrays=this.recordArraysForRecord(record);arrays.add(manyArray);},this);return manyArray;},registerFilteredRecordArray:function(array,type,filter){var recordArrays=this.filteredRecordArrays.get(type);recordArrays.push(array);this.updateFilter(array,type,filter);},registerWaitingRecordArray:function(record,array){var loadingRecordArrays=record._loadingRecordArrays||[];loadingRecordArrays.push(array);record._loadingRecordArrays=loadingRecordArrays;}});})();(function(){var get=Ember.get,set=Ember.set,merge=Ember.merge;var map=Ember.ArrayPolyfills.map;var resolve=Ember.RSVP.resolve;var errorProps=['description','fileName','lineNumber','message','name','number','stack'];DS.InvalidError=function(errors){var tmp=Error.prototype.constructor.call(this,"The backend rejected the commit because it was invalid: "+Ember.inspect(errors));this.errors=errors;for(var i=0,l=errorProps.length;i<l;i++){this[errorProps[i]]=tmp[errorProps[i]];}};DS.InvalidError.prototype=Ember.create(Error.prototype);function isThenable(object){return object&&typeof object.then==='function';}
function aliasMethod(methodName){return function(){return this[methodName].apply(this,arguments);};}
DS.Adapter=Ember.Object.extend(DS._Mappable,{find:Ember.required(Function),findAll:null,findQuery:null,generateIdForRecord:null,serialize:function(record,options){return get(record,'store').serializerFor(record.constructor.typeKey).serialize(record,options);},createRecord:Ember.required(Function),updateRecord:Ember.required(Function),deleteRecord:Ember.required(Function),findMany:function(store,type,ids){var promises=map.call(ids,function(id){return this.find(store,type,id);},this);return Ember.RSVP.all(promises);}});})();(function(){var get=Ember.get,fmt=Ember.String.fmt,indexOf=Ember.EnumerableUtils.indexOf;var counter=0;DS.FixtureAdapter=DS.Adapter.extend({serializer:null,simulateRemoteResponse:true,latency:50,fixturesForType:function(type){if(type.FIXTURES){var fixtures=Ember.A(type.FIXTURES);return fixtures.map(function(fixture){var fixtureIdType=typeof fixture.id;if(fixtureIdType!=="number"&&fixtureIdType!=="string"){throw new Error(fmt('the id property must be defined as a number or string for fixture %@',[fixture]));}
fixture.id=fixture.id+'';return fixture;});}
return null;},queryFixtures:function(fixtures,query,type){Ember.assert('Not implemented: You must override the DS.FixtureAdapter::queryFixtures method to support querying the fixture store.');},updateFixtures:function(type,fixture){if(!type.FIXTURES){type.FIXTURES=[];}
var fixtures=type.FIXTURES;this.deleteLoadedFixture(type,fixture);fixtures.push(fixture);},mockJSON:function(store,type,record){return store.serializerFor(type).serialize(record,{includeId:true});},generateIdForRecord:function(store){return counter++;},find:function(store,type,id){var fixtures=this.fixturesForType(type),fixture;Ember.warn("Unable to find fixtures for model type "+type.toString(),fixtures);if(fixtures){fixture=Ember.A(fixtures).findProperty('id',id);}
if(fixture){return this.simulateRemoteCall(function(){return fixture;},this);}},findMany:function(store,type,ids){var fixtures=this.fixturesForType(type);Ember.assert("Unable to find fixtures for model type "+type.toString(),!!fixtures);if(fixtures){fixtures=fixtures.filter(function(item){return indexOf(ids,item.id)!==-1;});}
if(fixtures){return this.simulateRemoteCall(function(){return fixtures;},this);}},findAll:function(store,type){var fixtures=this.fixturesForType(type);Ember.assert("Unable to find fixtures for model type "+type.toString(),!!fixtures);return this.simulateRemoteCall(function(){return fixtures;},this);},findQuery:function(store,type,query,array){var fixtures=this.fixturesForType(type);Ember.assert("Unable to find fixtures for model type "+type.toString(),!!fixtures);fixtures=this.queryFixtures(fixtures,query,type);if(fixtures){return this.simulateRemoteCall(function(){return fixtures;},this);}},createRecord:function(store,type,record){var fixture=this.mockJSON(store,type,record);this.updateFixtures(type,fixture);return this.simulateRemoteCall(function(){return fixture;},this);},updateRecord:function(store,type,record){var fixture=this.mockJSON(store,type,record);this.updateFixtures(type,fixture);return this.simulateRemoteCall(function(){return fixture;},this);},deleteRecord:function(store,type,record){var fixture=this.mockJSON(store,type,record);this.deleteLoadedFixture(type,fixture);return this.simulateRemoteCall(function(){return null;});},deleteLoadedFixture:function(type,record){var existingFixture=this.findExistingFixture(type,record);if(existingFixture){var index=indexOf(type.FIXTURES,existingFixture);type.FIXTURES.splice(index,1);return true;}},findExistingFixture:function(type,record){var fixtures=this.fixturesForType(type);var id=get(record,'id');return this.findFixtureById(fixtures,id);},findFixtureById:function(fixtures,id){return Ember.A(fixtures).find(function(r){if(''+get(r,'id')===''+id){return true;}else{return false;}});},simulateRemoteCall:function(callback,context){var adapter=this;return new Ember.RSVP.Promise(function(resolve){if(get(adapter,'simulateRemoteResponse')){Ember.run.later(function(){resolve(callback.call(context));},get(adapter,'latency'));}else{Ember.run.once(function(){resolve(callback.call(context));});}});}});})();(function(){var get=Ember.get,set=Ember.set;var forEach=Ember.ArrayPolyfills.forEach;DS.rejectionHandler=function(reason){Ember.Logger.assert([reason,reason.message,reason.stack]);throw reason;};function coerceId(id){return id==null?null:id+'';}
DS.RESTSerializer=DS.JSONSerializer.extend({normalize:function(type,prop,hash){this.normalizeId(hash);this.normalizeAttributes(hash);if(this.normalizeHash&&this.normalizeHash[prop]){return this.normalizeHash[prop](hash);}
return hash;},normalizeId:function(hash){var primaryKey=get(this,'primaryKey');if(primaryKey==='id'){return;}
hash.id=hash[primaryKey];delete hash[primaryKey];},normalizeAttributes:function(hash){var attrs=get(this,'attrs');if(!attrs){return;}
for(var key in attrs){var payloadKey=attrs[key];hash[key]=hash[payloadKey];delete hash[payloadKey];}},extractSingle:function(store,primaryType,payload,recordId,requestType){var primaryTypeName=primaryType.typeKey,primaryRecord;for(var prop in payload){if(prop===primaryTypeName){primaryRecord=this.normalize(primaryType,prop,payload[prop]);continue;}
var typeName=this.singularize(prop),type=store.modelFor(typeName);forEach.call(payload[prop],function(hash){hash=this.normalize(type,prop,hash);var isFirstCreatedRecord=typeName===primaryTypeName&&!recordId&&!primaryRecord,isUpdatedRecord=typeName===primaryTypeName&&coerceId(hash.id)===recordId;if(isFirstCreatedRecord||isUpdatedRecord){primaryRecord=hash;}else{store.push(typeName,hash);}},this);}
return primaryRecord;},extractArray:function(store,primaryType,payload){var primaryTypeName=primaryType.typeKey,primaryArray;for(var prop in payload){var typeName=this.singularize(prop),type=store.modelFor(typeName),isPrimary=typeName===primaryTypeName;var normalizedArray=payload[prop].map(function(hash){return this.normalize(type,prop,hash);},this);if(isPrimary){primaryArray=normalizedArray;}else{store.pushMany(typeName,normalizedArray);}}
return primaryArray;},pluralize:function(key){return Ember.String.pluralize(key);},singularize:function(key){return Ember.String.singularize(key);},serialize:function(record,options){return this._super.apply(this,arguments);}});DS.RESTAdapter=DS.Adapter.extend({defaultSerializer:'_rest',find:function(store,type,id){return this.ajax(this.buildURL(type,id),'GET');},findAll:function(store,type){return this.ajax(this.buildURL(type),'GET');},findQuery:function(store,type,query){return this.ajax(this.buildURL(type),'GET',{data:query});},findMany:function(store,type,ids){return this.ajax(this.buildURL(type),'GET',{data:{ids:ids}});},findHasMany:function(store,record,url){return this.ajax(url,'GET');},createRecord:function(store,type,record){var data={};data[type.typeKey]=this.serializerFor(type.typeKey).serialize(record,{includeId:true});return this.ajax(this.buildURL(type),"POST",{data:data});},updateRecord:function(store,type,record){var data={};data[type.typeKey]=this.serializerFor(type.typeKey).serialize(record);var id=get(record,'id');return this.ajax(this.buildURL(type,id),"PUT",{data:data});},deleteRecord:function(store,type,record){var id=get(record,'id');return this.ajax(this.buildURL(type,id),"DELETE");},buildURL:function(type,id){var host=get(this,'host'),namespace=get(this,'namespace'),url=[];if(host){url.push(host);}
if(namespace){url.push(namespace);}
url.push(Ember.String.pluralize(type.typeKey));if(id){url.push(id);}
url=url.join('/');if(!host){url='/'+url;}
return url;},serializerFor:function(type){return this.container.lookup('serializer:'+type)||this.container.lookup('serializer:application')||this.container.lookup('serializer:_rest');},ajax:function(url,type,hash){var adapter=this;return new Ember.RSVP.Promise(function(resolve,reject){hash=hash||{};hash.url=url;hash.type=type;hash.dataType='json';hash.context=adapter;if(hash.data&&type!=='GET'){hash.contentType='application/json; charset=utf-8';hash.data=JSON.stringify(hash.data);}
if(adapter.headers!==undefined){var headers=adapter.headers;hash.beforeSend=function(xhr){forEach.call(Ember.keys(headers),function(key){xhr.setRequestHeader(key,headers[key]);});};}
hash.success=function(json){Ember.run(null,resolve,json);};hash.error=function(jqXHR,textStatus,errorThrown){if(jqXHR){jqXHR.then=null;}
Ember.run(null,reject,jqXHR);};Ember.$.ajax(hash);});}});})();(function(){})();(function(){DS.Model.reopen({_debugInfo:function(){var attributes=['id'],relationships={belongsTo:[],hasMany:[]},expensiveProperties=[];this.eachAttribute(function(name,meta){attributes.push(name);},this);this.eachRelationship(function(name,relationship){relationships[relationship.kind].push(name);expensiveProperties.push(name);});var groups=[{name:'Attributes',properties:attributes,expand:true,},{name:'Belongs To',properties:relationships.belongsTo,expand:true},{name:'Has Many',properties:relationships.hasMany,expand:true},{name:'Flags',properties:['isLoaded','isDirty','isSaving','isDeleted','isError','isNew','isValid']}];return{propertyInfo:{includeOtherProperties:true,groups:groups,expensiveProperties:expensiveProperties}};}});})();(function(){})();(function(){})();