/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.GUIDGenerator;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskExecutionContext;
import it.sauronsoftware.cron4j.TaskExecutorListener;
import java.util.ArrayList;
import java.util.Iterator;

public class TaskExecutor {
    private Scheduler scheduler;
    private Task task;
    private MyContext context;
    private String guid = GUIDGenerator.generate();
    private TaskExecutor myself = this;
    private ArrayList listeners = new ArrayList();
    private long startTime = -1L;
    private Thread thread;
    private boolean paused = false;
    private boolean stopped = false;
    private Object lock = new Object();

    TaskExecutor(Scheduler scheduler, Task task) {
        this.scheduler = scheduler;
        this.task = task;
        this.context = new MyContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskExecutorListener(TaskExecutorListener taskExecutorListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(taskExecutorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskExecutorListener(TaskExecutorListener taskExecutorListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(taskExecutorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutorListener[] getTaskExecutorListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            TaskExecutorListener[] taskExecutorListenerArray = new TaskExecutorListener[n];
            for (int i = 0; i < n; ++i) {
                taskExecutorListenerArray[i] = (TaskExecutorListener)this.listeners.get(i);
            }
            return taskExecutorListenerArray;
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Task getTask() {
        return this.task;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean canBePaused() {
        return this.task.canBePaused();
    }

    public boolean canBeStopped() {
        return this.task.canBeStopped();
    }

    public boolean supportsCompletenessTracking() {
        return this.task.supportsCompletenessTracking();
    }

    public boolean supportsStatusTracking() {
        return this.task.supportsStatusTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.startTime = System.currentTimeMillis();
            String string = "cron4j::scheduler[" + this.scheduler.getGuid() + "]::executor[" + this.guid + "]";
            this.thread = new Thread(new Runner());
            this.thread.setDaemon(bl);
            this.thread.setName(string);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws UnsupportedOperationException {
        if (!this.canBePaused()) {
            throw new UnsupportedOperationException("Pause not supported");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.thread != null && !this.paused) {
                this.notifyExecutionPausing();
                this.paused = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.thread != null && this.paused) {
                this.notifyExecutionResuming();
                this.paused = false;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws UnsupportedOperationException {
        if (!this.canBeStopped()) {
            throw new UnsupportedOperationException("Stop not supported");
        }
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.thread != null && !this.stopped) {
                this.stopped = true;
                if (this.paused) {
                    this.resume();
                }
                this.notifyExecutionStopping();
                this.thread.interrupt();
                bl = true;
            }
        }
        if (bl) {
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.thread = null;
        }
    }

    public void join() throws InterruptedException {
        if (this.thread != null) {
            this.thread.join();
        }
    }

    public boolean isAlive() {
        if (this.thread != null) {
            return this.thread.isAlive();
        }
        return false;
    }

    public String getStatusMessage() throws UnsupportedOperationException {
        if (!this.supportsStatusTracking()) {
            throw new UnsupportedOperationException("Status tracking not supported");
        }
        return this.context.getStatusMessage();
    }

    public double getCompleteness() throws UnsupportedOperationException {
        if (!this.supportsCompletenessTracking()) {
            throw new UnsupportedOperationException("Completeness tracking not supported");
        }
        return this.context.getCompleteness();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExecutionPausing() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TaskExecutorListener taskExecutorListener = (TaskExecutorListener)iterator.next();
                taskExecutorListener.executionPausing(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExecutionResuming() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TaskExecutorListener taskExecutorListener = (TaskExecutorListener)iterator.next();
                taskExecutorListener.executionResuming(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExecutionStopping() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TaskExecutorListener taskExecutorListener = (TaskExecutorListener)iterator.next();
                taskExecutorListener.executionStopping(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExecutionTerminated(Throwable throwable) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TaskExecutorListener taskExecutorListener = (TaskExecutorListener)iterator.next();
                taskExecutorListener.executionTerminated(this, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatusMessageChanged(String string) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TaskExecutorListener taskExecutorListener = (TaskExecutorListener)iterator.next();
                taskExecutorListener.statusMessageChanged(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCompletenessValueChanged(double d) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TaskExecutorListener taskExecutorListener = (TaskExecutorListener)iterator.next();
                taskExecutorListener.completenessValueChanged(this, d);
            }
        }
    }

    private class MyContext
    implements TaskExecutionContext {
        private String message = "";
        private double completeness = 0.0;

        private MyContext() {
        }

        public Scheduler getScheduler() {
            return TaskExecutor.this.scheduler;
        }

        public TaskExecutor getTaskExecutor() {
            return TaskExecutor.this.myself;
        }

        public boolean isStopped() {
            return TaskExecutor.this.stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pauseIfRequested() {
            Object object = TaskExecutor.this.lock;
            synchronized (object) {
                if (TaskExecutor.this.paused) {
                    try {
                        TaskExecutor.this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public void setCompleteness(double d) {
            if (d >= 0.0 && d <= 1.0) {
                this.completeness = d;
                TaskExecutor.this.notifyCompletenessValueChanged(d);
            }
        }

        public void setStatusMessage(String string) {
            this.message = string != null ? string : "";
            TaskExecutor.this.notifyStatusMessageChanged(string);
        }

        public String getStatusMessage() {
            return this.message;
        }

        public double getCompleteness() {
            return this.completeness;
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Throwable throwable = null;
            TaskExecutor.this.startTime = System.currentTimeMillis();
            try {
                TaskExecutor.this.scheduler.notifyTaskLaunching(TaskExecutor.this.myself);
                TaskExecutor.this.task.execute(TaskExecutor.this.context);
                TaskExecutor.this.scheduler.notifyTaskSucceeded(TaskExecutor.this.myself);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                TaskExecutor.this.scheduler.notifyTaskFailed(TaskExecutor.this.myself, throwable2);
            }
            finally {
                TaskExecutor.this.notifyExecutionTerminated(throwable);
                TaskExecutor.this.scheduler.notifyExecutorCompleted(TaskExecutor.this.myself);
            }
        }
    }
}

