/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import com.google.common.collect.Range;
import java.util.List;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ConversionException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.RangeValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public abstract class RangeParserValidator<T extends Comparable<T>>
extends BaseParserValidator<T> {
    public static final String LEFT_RANGE_DELIMITER = "[";
    public static final String RIGHT_RANGE_DELIMITER = "]";
    protected static final String LEFT_RANGE_DELIMITER_REGEXP = "\\[";
    protected static final String RIGHT_RANGE_DELIMITER_REGEXP = "\\]";
    protected static final String RANGE_MAIN_REGEXP = "\\[([^)]+)\\]";

    public RangeParserValidator(String model) throws ModelSyntaxException {
        super(model);
    }

    @Override
    protected Validator<T> createValidator(String model, Converter<T> converter) throws ModelSyntaxException {
        if (model.matches(this.getTypeRegexp())) {
            return new RangeValidator();
        }
        String mainRangeRegexp = "^" + this.getTypeRegexp() + RANGE_MAIN_REGEXP + "$";
        String rangeString = this.parseAndGetOneGroup(model, mainRangeRegexp);
        try {
            return new RangeValidator(this.extractRange(rangeString, converter));
        }
        catch (IllegalArgumentException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }

    protected Range<T> extractRange(String value, Converter<T> converter) throws ModelSyntaxException {
        String rangeRegexp = "^([^),]+)$|^([^),]+),([^),]+)$";
        try {
            List<String> modelArguments = RangeParserValidator.parseAndGetRegexGroups(value, rangeRegexp);
            if (modelArguments.size() == 1) {
                Comparable minValue = (Comparable)converter.convert(modelArguments.get(0));
                return Range.atLeast((Comparable)minValue);
            }
            if (modelArguments.size() == 2) {
                Comparable minValue = (Comparable)converter.convert(modelArguments.get(0));
                Comparable maxValue = (Comparable)converter.convert(modelArguments.get(1));
                return Range.closed((Comparable)minValue, (Comparable)maxValue);
            }
            throw new ModelSyntaxException("Internal error, regular expression for " + this.getType() + " '" + rangeRegexp + "' is invalid.");
        }
        catch (IllegalArgumentException | ConversionException e) {
            throw new ModelSyntaxException("Illegal " + this.getType() + " range expression '" + value + "', " + e.getMessage(), e);
        }
    }
}

