/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.InfoResidue0;
import com.jcraft.jorbis.LookResidue0;

class Residue0
extends FuncResidue {
    static int[][][] partword = new int[2][][];

    void pack(Object vr, Buffer opb) {
        InfoResidue0 info = (InfoResidue0)vr;
        int acc = 0;
        opb.write(info.begin, 24);
        opb.write(info.end, 24);
        opb.write(info.grouping - 1, 24);
        opb.write(info.partitions - 1, 6);
        opb.write(info.groupbook, 8);
        int j = 0;
        while (j < info.partitions) {
            if (Residue0.ilog(info.secondstages[j]) > 3) {
                opb.write(info.secondstages[j], 3);
                opb.write(1, 1);
                opb.write(info.secondstages[j] >>> 3, 5);
            } else {
                opb.write(info.secondstages[j], 4);
            }
            acc += Residue0.icount(info.secondstages[j]);
            ++j;
        }
        j = 0;
        while (j < acc) {
            opb.write(info.booklist[j], 8);
            ++j;
        }
    }

    Object unpack(Info vi, Buffer opb) {
        int acc = 0;
        InfoResidue0 info = new InfoResidue0();
        info.begin = opb.read(24);
        info.end = opb.read(24);
        info.grouping = opb.read(24) + 1;
        info.partitions = opb.read(6) + 1;
        info.groupbook = opb.read(8);
        int j = 0;
        while (j < info.partitions) {
            int cascade = opb.read(3);
            if (opb.read(1) != 0) {
                cascade |= opb.read(5) << 3;
            }
            info.secondstages[j] = cascade;
            acc += Residue0.icount(cascade);
            ++j;
        }
        j = 0;
        while (j < acc) {
            info.booklist[j] = opb.read(8);
            ++j;
        }
        if (info.groupbook >= vi.books) {
            this.free_info(info);
            return null;
        }
        j = 0;
        while (j < acc) {
            if (info.booklist[j] >= vi.books) {
                this.free_info(info);
                return null;
            }
            ++j;
        }
        return info;
    }

    Object look(DspState vd, InfoMode vm, Object vr) {
        InfoResidue0 info = (InfoResidue0)vr;
        LookResidue0 look = new LookResidue0();
        int acc = 0;
        int maxstage = 0;
        look.info = info;
        look.map = vm.mapping;
        look.parts = info.partitions;
        look.fullbooks = vd.fullbooks;
        look.phrasebook = vd.fullbooks[info.groupbook];
        int dim = look.phrasebook.dim;
        look.partbooks = new int[look.parts][];
        int j = 0;
        while (j < look.parts) {
            int stages = Residue0.ilog(info.secondstages[j]);
            if (stages != 0) {
                if (stages > maxstage) {
                    maxstage = stages;
                }
                look.partbooks[j] = new int[stages];
                int k = 0;
                while (k < stages) {
                    if ((info.secondstages[j] & 1 << k) != 0) {
                        look.partbooks[j][k] = info.booklist[acc++];
                    }
                    ++k;
                }
            }
            ++j;
        }
        look.partvals = (int)Math.rint(Math.pow(look.parts, dim));
        look.stages = maxstage;
        look.decodemap = new int[look.partvals][];
        j = 0;
        while (j < look.partvals) {
            int val = j;
            int mult = look.partvals / look.parts;
            look.decodemap[j] = new int[dim];
            int k = 0;
            while (k < dim) {
                int deco = val / mult;
                val -= deco * mult;
                mult /= look.parts;
                look.decodemap[j][k] = deco;
                ++k;
            }
            ++j;
        }
        return look;
    }

    void free_info(Object i) {
    }

    void free_look(Object i) {
    }

    int forward(Block vb, Object vl, float[][] in, int ch) {
        System.err.println("Residue0.forward: not implemented");
        return 0;
    }

    static synchronized int _01inverse(Block vb, Object vl, float[][] in, int ch, int decodepart) {
        int j;
        LookResidue0 look = (LookResidue0)vl;
        InfoResidue0 info = look.info;
        int samples_per_partition = info.grouping;
        int partitions_per_word = look.phrasebook.dim;
        int n = info.end - info.begin;
        int partvals = n / samples_per_partition;
        int partwords = (partvals + partitions_per_word - 1) / partitions_per_word;
        if (partword.length < ch) {
            partword = new int[ch][][];
            j = 0;
            while (j < ch) {
                Residue0.partword[j] = new int[partwords][];
                ++j;
            }
        } else {
            j = 0;
            while (j < ch) {
                if (partword[j] == null || partword[j].length < partwords) {
                    Residue0.partword[j] = new int[partwords][];
                }
                ++j;
            }
        }
        int s = 0;
        while (s < look.stages) {
            int i = 0;
            int l = 0;
            while (i < partvals) {
                if (s == 0) {
                    j = 0;
                    while (j < ch) {
                        int temp = look.phrasebook.decode(vb.opb);
                        if (temp == -1) {
                            return 0;
                        }
                        Residue0.partword[j][l] = look.decodemap[temp];
                        if (partword[j][l] == null) {
                            return 0;
                        }
                        ++j;
                    }
                }
                int k = 0;
                while (k < partitions_per_word && i < partvals) {
                    j = 0;
                    while (j < ch) {
                        CodeBook stagebook;
                        int offset = info.begin + i * samples_per_partition;
                        if ((info.secondstages[partword[j][l][k]] & 1 << s) != 0 && (stagebook = look.fullbooks[look.partbooks[partword[j][l][k]][s]]) != null && (decodepart == 0 ? stagebook.decodevs_add(in[j], offset, vb.opb, samples_per_partition) == -1 : decodepart == 1 && stagebook.decodev_add(in[j], offset, vb.opb, samples_per_partition) == -1)) {
                            return 0;
                        }
                        ++j;
                    }
                    ++k;
                    ++i;
                }
                ++l;
            }
            ++s;
        }
        return 0;
    }

    static int _2inverse(Block vb, Object vl, float[][] in, int ch) {
        LookResidue0 look = (LookResidue0)vl;
        InfoResidue0 info = look.info;
        int samples_per_partition = info.grouping;
        int partitions_per_word = look.phrasebook.dim;
        int n = info.end - info.begin;
        int partvals = n / samples_per_partition;
        int partwords = (partvals + partitions_per_word - 1) / partitions_per_word;
        int[][] partword = new int[partwords][];
        int s = 0;
        while (s < look.stages) {
            int i = 0;
            int l = 0;
            while (i < partvals) {
                if (s == 0) {
                    int temp = look.phrasebook.decode(vb.opb);
                    if (temp == -1) {
                        return 0;
                    }
                    partword[l] = look.decodemap[temp];
                    if (partword[l] == null) {
                        return 0;
                    }
                }
                int k = 0;
                while (k < partitions_per_word && i < partvals) {
                    CodeBook stagebook;
                    int offset = info.begin + i * samples_per_partition;
                    if ((info.secondstages[partword[l][k]] & 1 << s) != 0 && (stagebook = look.fullbooks[look.partbooks[partword[l][k]][s]]) != null && stagebook.decodevv_add(in, offset, ch, vb.opb, samples_per_partition) == -1) {
                        return 0;
                    }
                    ++k;
                    ++i;
                }
                ++l;
            }
            ++s;
        }
        return 0;
    }

    int inverse(Block vb, Object vl, float[][] in, int[] nonzero, int ch) {
        int used = 0;
        int i = 0;
        while (i < ch) {
            if (nonzero[i] != 0) {
                in[used++] = in[i];
            }
            ++i;
        }
        if (used != 0) {
            return Residue0._01inverse(vb, vl, in, used, 0);
        }
        return 0;
    }

    private static final int ilog(int v) {
        int ret = 0;
        while (v != 0) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    private static final int icount(int v) {
        int ret = 0;
        while (v != 0) {
            ret += v & 1;
            v >>>= 1;
        }
        return ret;
    }

    Residue0() {
    }
}

