/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.CodingMode;
import com.fluendo.jheora.Playback;
import com.fluendo.jheora.Recon;
import com.fluendo.jheora.iDCT;
import com.fluendo.utils.MemUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DCTDecode {
    private static final int PUR = 8;
    private static final int PU = 4;
    private static final int PUL = 2;
    private static final int PL = 1;
    private static final int[] ModeUsesMC;
    private static final short[][] pc;
    private static final int[] bc_mask;
    private static final short[] Mode2Frame;
    private short[] ReconDataBuffer;
    private int[] v;
    private int[] fn;
    private short[] Last;
    private iDCT idct;

    private final void ExpandKFBlock(Playback pbi, int FragmentNumber) {
        short[] dequant_coeffs;
        int ReconPixelsPerLine;
        if (FragmentNumber < pbi.YPlaneFragments) {
            ReconPixelsPerLine = pbi.YStride;
            dequant_coeffs = pbi.dequant_Y_coeffs;
        } else {
            ReconPixelsPerLine = pbi.UVStride;
            dequant_coeffs = pbi.dequant_UV_coeffs;
        }
        short[] quantized_list = pbi.QFragData[FragmentNumber];
        switch (pbi.FragCoefEOB[FragmentNumber]) {
            case 0: 
            case 1: {
                this.idct.IDct1(quantized_list, dequant_coeffs, this.ReconDataBuffer);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.idct.IDct10(quantized_list, dequant_coeffs, this.ReconDataBuffer);
                break;
            }
            default: {
                this.idct.IDctSlow(quantized_list, dequant_coeffs, this.ReconDataBuffer);
            }
        }
        int ReconPixelIndex = pbi.recon_pixel_index_table[FragmentNumber];
        Recon.ReconIntra(pbi.ThisFrameRecon, ReconPixelIndex, this.ReconDataBuffer, ReconPixelsPerLine);
    }

    private final void ExpandBlock(Playback pbi, int FragmentNumber) {
        short[] dequant_coeffs;
        int MvModMask;
        int MvShift;
        int ReconPixelsPerLine;
        CodingMode codingMode = pbi.getFrameType() == 0 ? CodingMode.CODE_INTRA : pbi.FragCodingMethod[FragmentNumber];
        if (FragmentNumber < pbi.YPlaneFragments) {
            ReconPixelsPerLine = pbi.YStride;
            MvShift = 1;
            MvModMask = 1;
            dequant_coeffs = codingMode == CodingMode.CODE_INTRA ? pbi.dequant_Y_coeffs : pbi.dequant_Inter_coeffs;
        } else {
            ReconPixelsPerLine = pbi.UVStride;
            MvShift = 2;
            MvModMask = 3;
            dequant_coeffs = codingMode == CodingMode.CODE_INTRA ? pbi.dequant_UV_coeffs : pbi.dequant_Inter_coeffs;
        }
        short[] quantized_list = pbi.QFragData[FragmentNumber];
        switch (pbi.FragCoefEOB[FragmentNumber]) {
            case 0: 
            case 1: {
                this.idct.IDct1(quantized_list, dequant_coeffs, this.ReconDataBuffer);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.idct.IDct10(quantized_list, dequant_coeffs, this.ReconDataBuffer);
                break;
            }
            default: {
                this.idct.IDctSlow(quantized_list, dequant_coeffs, this.ReconDataBuffer);
            }
        }
        int ReconPixelIndex = pbi.recon_pixel_index_table[FragmentNumber];
        if (codingMode == CodingMode.CODE_INTER_NO_MV) {
            Recon.ReconInter(pbi.ThisFrameRecon, ReconPixelIndex, pbi.LastFrameRecon, ReconPixelIndex, this.ReconDataBuffer, ReconPixelsPerLine);
        } else if (ModeUsesMC[codingMode.getValue()] != 0) {
            int ReconPtr2Offset = 0;
            int MVOffset = 0;
            int dir = pbi.FragMVect[FragmentNumber].x;
            if (dir > 0) {
                MVOffset = dir >> MvShift;
                if ((dir & MvModMask) != 0) {
                    ReconPtr2Offset = 1;
                }
            } else if (dir < 0) {
                MVOffset = -(-dir >> MvShift);
                if ((-dir & MvModMask) != 0) {
                    ReconPtr2Offset = -1;
                }
            }
            dir = pbi.FragMVect[FragmentNumber].y;
            if (dir > 0) {
                MVOffset += (dir >> MvShift) * ReconPixelsPerLine;
                if ((dir & MvModMask) != 0) {
                    ReconPtr2Offset += ReconPixelsPerLine;
                }
            } else if (dir < 0) {
                MVOffset -= (-dir >> MvShift) * ReconPixelsPerLine;
                if ((-dir & MvModMask) != 0) {
                    ReconPtr2Offset -= ReconPixelsPerLine;
                }
            }
            int LastFrameRecOffset = ReconPixelIndex + MVOffset;
            short[] LastFrameRecPtr = codingMode == CodingMode.CODE_GOLDEN_MV ? pbi.GoldenFrame : pbi.LastFrameRecon;
            if (ReconPtr2Offset == 0) {
                Recon.ReconInter(pbi.ThisFrameRecon, ReconPixelIndex, LastFrameRecPtr, LastFrameRecOffset, this.ReconDataBuffer, ReconPixelsPerLine);
            } else {
                Recon.ReconInterHalfPixel2(pbi.ThisFrameRecon, ReconPixelIndex, LastFrameRecPtr, LastFrameRecOffset, LastFrameRecPtr, LastFrameRecOffset + ReconPtr2Offset, this.ReconDataBuffer, ReconPixelsPerLine);
            }
        } else if (codingMode == CodingMode.CODE_USING_GOLDEN) {
            Recon.ReconInter(pbi.ThisFrameRecon, ReconPixelIndex, pbi.GoldenFrame, ReconPixelIndex, this.ReconDataBuffer, ReconPixelsPerLine);
        } else {
            Recon.ReconIntra(pbi.ThisFrameRecon, ReconPixelIndex, this.ReconDataBuffer, ReconPixelsPerLine);
        }
    }

    private final void UpdateUMV_HBorders(Playback pbi, short[] DestReconPtr, int PlaneFragOffset) {
        int LineFragments;
        int PlaneFragments;
        int PlaneBorderWidth;
        int PlaneStride;
        int BlockVStep;
        if (PlaneFragOffset == 0) {
            BlockVStep = pbi.YStride * 7;
            PlaneStride = pbi.YStride;
            PlaneBorderWidth = 16;
            PlaneFragments = pbi.YPlaneFragments;
            LineFragments = pbi.HFragments;
        } else {
            BlockVStep = pbi.UVStride * 7;
            PlaneStride = pbi.UVStride;
            PlaneBorderWidth = 8;
            PlaneFragments = pbi.UVPlaneFragments;
            LineFragments = pbi.HFragments / 2;
        }
        int PixelIndex = pbi.recon_pixel_index_table[PlaneFragOffset];
        short[] SrcPtr1 = DestReconPtr;
        int SrcOff1 = PixelIndex - PlaneBorderWidth;
        short[] DestPtr1 = SrcPtr1;
        int DestOff1 = SrcOff1 - PlaneBorderWidth * PlaneStride;
        PixelIndex = pbi.recon_pixel_index_table[PlaneFragOffset + PlaneFragments - LineFragments] + BlockVStep;
        short[] SrcPtr2 = DestReconPtr;
        int SrcOff2 = PixelIndex - PlaneBorderWidth;
        short[] DestPtr2 = SrcPtr2;
        int DestOff2 = SrcOff2 + PlaneStride;
        int i = 0;
        while (i < PlaneBorderWidth) {
            System.arraycopy(SrcPtr1, SrcOff1, DestPtr1, DestOff1, PlaneStride);
            System.arraycopy(SrcPtr2, SrcOff2, DestPtr2, DestOff2, PlaneStride);
            DestOff1 += PlaneStride;
            DestOff2 += PlaneStride;
            ++i;
        }
    }

    private final void UpdateUMV_VBorders(Playback pbi, short[] DestReconPtr, int PlaneFragOffset) {
        int PlaneHeight;
        int LineFragments;
        int PlaneBorderWidth;
        int PlaneStride;
        if (PlaneFragOffset == 0) {
            PlaneStride = pbi.YStride;
            PlaneBorderWidth = 16;
            LineFragments = pbi.HFragments;
            PlaneHeight = pbi.info.height;
        } else {
            PlaneStride = pbi.UVStride;
            PlaneBorderWidth = 8;
            LineFragments = pbi.HFragments / 2;
            PlaneHeight = pbi.info.height / 2;
        }
        int PixelIndex = pbi.recon_pixel_index_table[PlaneFragOffset];
        short[] SrcPtr1 = DestReconPtr;
        int SrcOff1 = PixelIndex;
        short[] DestPtr1 = DestReconPtr;
        int DestOff1 = PixelIndex - PlaneBorderWidth;
        PixelIndex = pbi.recon_pixel_index_table[PlaneFragOffset + LineFragments - 1] + 7;
        short[] SrcPtr2 = DestReconPtr;
        int SrcOff2 = PixelIndex;
        short[] DestPtr2 = DestReconPtr;
        int DestOff2 = PixelIndex + 1;
        int i = 0;
        while (i < PlaneHeight) {
            MemUtils.set(DestPtr1, DestOff1, (int)SrcPtr1[SrcOff1], PlaneBorderWidth);
            MemUtils.set(DestPtr2, DestOff2, (int)SrcPtr2[SrcOff2], PlaneBorderWidth);
            DestOff1 += PlaneStride;
            DestOff2 += PlaneStride;
            SrcOff1 += PlaneStride;
            SrcOff2 += PlaneStride;
            ++i;
        }
    }

    private final void UpdateUMVBorder(Playback pbi, short[] DestReconPtr) {
        int PlaneFragOffset = 0;
        this.UpdateUMV_VBorders(pbi, DestReconPtr, PlaneFragOffset);
        this.UpdateUMV_HBorders(pbi, DestReconPtr, PlaneFragOffset);
        PlaneFragOffset = pbi.YPlaneFragments;
        this.UpdateUMV_VBorders(pbi, DestReconPtr, PlaneFragOffset);
        this.UpdateUMV_HBorders(pbi, DestReconPtr, PlaneFragOffset);
        PlaneFragOffset = pbi.YPlaneFragments + pbi.UVPlaneFragments;
        this.UpdateUMV_VBorders(pbi, DestReconPtr, PlaneFragOffset);
        this.UpdateUMV_HBorders(pbi, DestReconPtr, PlaneFragOffset);
    }

    private final void CopyRecon(Playback pbi, short[] DestReconPtr, short[] SrcReconPtr) {
        int PixelIndex;
        int PlaneLineStep = pbi.YStride;
        int i = 0;
        while (i < pbi.YPlaneFragments) {
            if (pbi.display_fragments[i] != 0) {
                PixelIndex = pbi.recon_pixel_index_table[i];
                Recon.CopyBlock(SrcReconPtr, DestReconPtr, PixelIndex, PlaneLineStep);
            }
            ++i;
        }
        PlaneLineStep = pbi.UVStride;
        i = pbi.YPlaneFragments;
        while (i < pbi.UnitFragments) {
            if (pbi.display_fragments[i] != 0) {
                PixelIndex = pbi.recon_pixel_index_table[i];
                Recon.CopyBlock(SrcReconPtr, DestReconPtr, PixelIndex, PlaneLineStep);
            }
            ++i;
        }
    }

    private final void CopyNotRecon(Playback pbi, short[] DestReconPtr, short[] SrcReconPtr) {
        int PixelIndex;
        int PlaneLineStep = pbi.YStride;
        int i = 0;
        while (i < pbi.YPlaneFragments) {
            if (pbi.display_fragments[i] == 0) {
                PixelIndex = pbi.recon_pixel_index_table[i];
                Recon.CopyBlock(SrcReconPtr, DestReconPtr, PixelIndex, PlaneLineStep);
            }
            ++i;
        }
        PlaneLineStep = pbi.UVStride;
        i = pbi.YPlaneFragments;
        while (i < pbi.UnitFragments) {
            if (pbi.display_fragments[i] == 0) {
                PixelIndex = pbi.recon_pixel_index_table[i];
                Recon.CopyBlock(SrcReconPtr, DestReconPtr, PixelIndex, PlaneLineStep);
            }
            ++i;
        }
    }

    public void ExpandToken(short[] ExpandedBlock, byte[] CoeffIndex, int FragIndex, int Token, int ExtraBits) {
        if (Token >= 23) {
            if (Token < 30) {
                if (Token < 28) {
                    int n = FragIndex;
                    CoeffIndex[n] = (byte)(CoeffIndex[n] + (byte)(Token - 23 + 1));
                    ExpandedBlock[CoeffIndex[FragIndex]] = (short)(-(((ExtraBits & 1) << 1) - 1));
                } else if (Token == 28) {
                    int n = FragIndex;
                    CoeffIndex[n] = (byte)(CoeffIndex[n] + (6 + (ExtraBits & 3)));
                    ExpandedBlock[CoeffIndex[FragIndex]] = (short)(-(((ExtraBits & 4) >> 1) - 1));
                } else {
                    int n = FragIndex;
                    CoeffIndex[n] = (byte)(CoeffIndex[n] + (10 + (ExtraBits & 7)));
                    ExpandedBlock[CoeffIndex[FragIndex]] = (short)(-(((ExtraBits & 8) >> 2) - 1));
                }
            } else if (Token == 30) {
                int n = FragIndex;
                CoeffIndex[n] = (byte)(CoeffIndex[n] + 1);
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((2 + (ExtraBits & 1)) * -((ExtraBits & 2) - 1));
            } else {
                int n = FragIndex;
                CoeffIndex[n] = (byte)(CoeffIndex[n] + (2 + (ExtraBits & 1)));
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((2 + ((ExtraBits & 2) >> 1)) * -(((ExtraBits & 4) >> 1) - 1));
            }
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + 1);
        } else if (Token == 7) {
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + (ExtraBits + 1));
        } else if (Token == 8) {
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + (ExtraBits + 1));
        } else if (Token < 13) {
            switch (Token) {
                case 9: {
                    ExpandedBlock[CoeffIndex[FragIndex]] = 1;
                    break;
                }
                case 10: {
                    ExpandedBlock[CoeffIndex[FragIndex]] = -1;
                    break;
                }
                case 11: {
                    ExpandedBlock[CoeffIndex[FragIndex]] = 2;
                    break;
                }
                case 12: {
                    ExpandedBlock[CoeffIndex[FragIndex]] = -2;
                    break;
                }
            }
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + 1);
        } else {
            if (Token < 17) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)(((Token -= 13) + 3) * -((ExtraBits << 1) - 1));
            } else if (Token == 17) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((7 + (ExtraBits & 1)) * -((ExtraBits & 2) - 1));
            } else if (Token == 18) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((9 + (ExtraBits & 3)) * -(((ExtraBits & 4) >> 1) - 1));
            } else if (Token == 19) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((13 + (ExtraBits & 7)) * -(((ExtraBits & 8) >> 2) - 1));
            } else if (Token == 20) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((21 + (ExtraBits & 0xF)) * -(((ExtraBits & 0x10) >> 3) - 1));
            } else if (Token == 21) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((37 + (ExtraBits & 0x1F)) * -(((ExtraBits & 0x20) >> 4) - 1));
            } else if (Token == 22) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((69 + (ExtraBits & 0x1FF)) * -(((ExtraBits & 0x200) >> 8) - 1));
            }
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + 1);
        }
    }

    public void ClearDownQFragData(Playback pbi) {
        int i = 0;
        while (i < pbi.CodedBlockIndex) {
            short[] QFragPtr = pbi.QFragData[pbi.CodedBlockList[i]];
            int j = 0;
            while (j < 64) {
                QFragPtr[j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public void ReconRefFrames(Playback pbi) {
        int FragsAcross = pbi.HFragments;
        int FragsDown = pbi.VFragments;
        boolean bl = false;
        if (pbi.getFrameType() == 0) {
            bl = true;
        }
        boolean isBaseFrame = bl;
        pbi.filter.SetupLoopFilter(pbi.FrameQIndex);
        int j = 0;
        while (j < 3) {
            int FromFragment;
            switch (j) {
                case 0: {
                    FromFragment = 0;
                    FragsAcross = pbi.HFragments;
                    FragsDown = pbi.VFragments;
                    break;
                }
                case 1: {
                    FromFragment = pbi.YPlaneFragments;
                    FragsAcross = pbi.HFragments >> 1;
                    FragsDown = pbi.VFragments >> 1;
                    break;
                }
                default: {
                    FromFragment = pbi.YPlaneFragments + pbi.UVPlaneFragments;
                    FragsAcross = pbi.HFragments >> 1;
                    FragsDown = pbi.VFragments >> 1;
                    break;
                }
            }
            int k = 0;
            while (k < 3) {
                this.Last[k] = 0;
                ++k;
            }
            int i = FromFragment;
            int m = 0;
            while (m < FragsDown) {
                int n = 0;
                while (n < FragsAcross) {
                    if (pbi.display_fragments[i] != 0 || pbi.getFrameType() == 0) {
                        short WhichFrame = Mode2Frame[pbi.FragCodingMethod[i].getValue()];
                        int n2 = 0;
                        if (n == 0) {
                            n2 = 1;
                        }
                        int n3 = 0;
                        if (m == 0) {
                            n3 = 1;
                        }
                        int n4 = n2 + (n3 << 1);
                        int n5 = 0;
                        if (n + 1 == FragsAcross) {
                            n5 = 1;
                        }
                        int WhichCase = n4 + (n5 << 2);
                        this.fn[0] = i - 1;
                        this.fn[1] = i - FragsAcross - 1;
                        this.fn[2] = i - FragsAcross;
                        this.fn[3] = i - FragsAcross + 1;
                        int wpc = 0;
                        int pcount = 0;
                        k = 0;
                        while (k < 4) {
                            int pflag = 1 << k;
                            if ((bc_mask[WhichCase] & pflag) != 0 && pbi.display_fragments[this.fn[k]] != 0 && Mode2Frame[pbi.FragCodingMethod[this.fn[k]].getValue()] == WhichFrame) {
                                this.v[pcount] = pbi.QFragData[this.fn[k]][0];
                                wpc = (short)(wpc | pflag);
                                ++pcount;
                            }
                            ++k;
                        }
                        if (wpc == 0) {
                            short[] sArray = pbi.QFragData[i];
                            sArray[0] = (short)(sArray[0] + this.Last[WhichFrame]);
                        } else {
                            short PredictedDC = (short)(pc[wpc][0] * this.v[0]);
                            k = 1;
                            while (k < pcount) {
                                PredictedDC = (short)(PredictedDC + pc[wpc][k] * this.v[k]);
                                ++k;
                            }
                            if (pc[wpc][4] != 0) {
                                if (PredictedDC < 0) {
                                    PredictedDC = (short)(PredictedDC + pc[wpc][5]);
                                }
                                PredictedDC = (short)(PredictedDC >> pc[wpc][4]);
                            }
                            if ((wpc & 7) == 7) {
                                if (Math.abs(PredictedDC - this.v[2]) > 128) {
                                    PredictedDC = (short)this.v[2];
                                } else if (Math.abs(PredictedDC - this.v[0]) > 128) {
                                    PredictedDC = (short)this.v[0];
                                } else if (Math.abs(PredictedDC - this.v[1]) > 128) {
                                    PredictedDC = (short)this.v[1];
                                }
                            }
                            short[] sArray = pbi.QFragData[i];
                            sArray[0] = (short)(sArray[0] + PredictedDC);
                        }
                        this.Last[WhichFrame] = pbi.QFragData[i][0];
                        if (isBaseFrame) {
                            this.ExpandKFBlock(pbi, i);
                        } else {
                            this.ExpandBlock(pbi, i);
                        }
                    }
                    ++n;
                    ++i;
                }
                ++m;
            }
            ++j;
        }
        if (pbi.CodedBlockIndex > pbi.UnitFragments >> 1) {
            short[] SwapReconBuffersTemp = pbi.ThisFrameRecon;
            pbi.ThisFrameRecon = pbi.LastFrameRecon;
            pbi.LastFrameRecon = SwapReconBuffersTemp;
            this.CopyNotRecon(pbi, pbi.LastFrameRecon, pbi.ThisFrameRecon);
        } else {
            this.CopyRecon(pbi, pbi.LastFrameRecon, pbi.ThisFrameRecon);
        }
        pbi.filter.LoopFilter(pbi);
        this.UpdateUMVBorder(pbi, pbi.LastFrameRecon);
        if (isBaseFrame) {
            this.CopyRecon(pbi, pbi.GoldenFrame, pbi.LastFrameRecon);
            this.UpdateUMVBorder(pbi, pbi.GoldenFrame);
        }
    }

    private final /* synthetic */ void this() {
        this.ReconDataBuffer = new short[64];
        this.v = new int[4];
        this.fn = new int[4];
        this.Last = new short[3];
        this.idct = new iDCT();
    }

    public DCTDecode() {
        this.this();
    }

    static {
        int[] nArray = new int[8];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        ModeUsesMC = nArray;
        short[][] sArrayArray = new short[16][];
        sArrayArray[0] = new short[6];
        short[] sArray = new short[6];
        sArray[0] = 1;
        sArrayArray[1] = sArray;
        short[] sArray2 = new short[6];
        sArray2[0] = 1;
        sArrayArray[2] = sArray2;
        short[] sArray3 = new short[6];
        sArray3[0] = 1;
        sArrayArray[3] = sArray3;
        short[] sArray4 = new short[6];
        sArray4[0] = 1;
        sArrayArray[4] = sArray4;
        short[] sArray5 = new short[6];
        sArray5[0] = 1;
        sArray5[1] = 1;
        sArray5[4] = 1;
        sArray5[5] = 1;
        sArrayArray[5] = sArray5;
        short[] sArray6 = new short[6];
        sArray6[1] = 1;
        sArrayArray[6] = sArray6;
        short[] sArray7 = new short[6];
        sArray7[0] = 29;
        sArray7[1] = -26;
        sArray7[2] = 29;
        sArray7[4] = 5;
        sArray7[5] = 31;
        sArrayArray[7] = sArray7;
        short[] sArray8 = new short[6];
        sArray8[0] = 1;
        sArrayArray[8] = sArray8;
        short[] sArray9 = new short[6];
        sArray9[0] = 75;
        sArray9[1] = 53;
        sArray9[4] = 7;
        sArray9[5] = 127;
        sArrayArray[9] = sArray9;
        short[] sArray10 = new short[6];
        sArray10[0] = 1;
        sArray10[1] = 1;
        sArray10[4] = 1;
        sArray10[5] = 1;
        sArrayArray[10] = sArray10;
        short[] sArray11 = new short[6];
        sArray11[0] = 75;
        sArray11[2] = 53;
        sArray11[4] = 7;
        sArray11[5] = 127;
        sArrayArray[11] = sArray11;
        short[] sArray12 = new short[6];
        sArray12[0] = 1;
        sArrayArray[12] = sArray12;
        short[] sArray13 = new short[6];
        sArray13[0] = 75;
        sArray13[2] = 53;
        sArray13[4] = 7;
        sArray13[5] = 127;
        sArrayArray[13] = sArray13;
        short[] sArray14 = new short[6];
        sArray14[0] = 3;
        sArray14[1] = 10;
        sArray14[2] = 3;
        sArray14[4] = 4;
        sArray14[5] = 15;
        sArrayArray[14] = sArray14;
        short[] sArray15 = new short[6];
        sArray15[0] = 29;
        sArray15[1] = -26;
        sArray15[2] = 29;
        sArray15[4] = 5;
        sArray15[5] = 31;
        sArrayArray[15] = sArray15;
        pc = sArrayArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 15;
        nArray2[1] = 12;
        nArray2[2] = 1;
        nArray2[4] = 7;
        nArray2[5] = 4;
        nArray2[6] = 1;
        bc_mask = nArray2;
        short[] sArray16 = new short[8];
        sArray16[0] = 1;
        sArray16[2] = 1;
        sArray16[3] = 1;
        sArray16[4] = 1;
        sArray16[5] = 2;
        sArray16[6] = 2;
        sArray16[7] = 1;
        Mode2Frame = sArray16;
    }
}

