import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-writeback',
    version='0.2.1',
    packages=['writeback'],
    include_package_data=True,
    install_requires=['Django>=1.5, <1.7'],
    license='BSD License',
    description='A pluggable customizable Django app to collect feedback from site visitors.',
    long_description=README,
    url='https://github.com/timgin/django-writeback/',
    author='Timour Ghinatoulline',
    author_email='tim@plusone.su',
    keywords=['blog', 'django', 'feedback', 'ajax', 'user', 'customer', 'comment'],
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
