try:
    import json
except ImportError:
    import simplejson as json
from geopy import geocoders
from geopy.geocoders.google import GQueryError

from zope.interface import implements
from zope.component import getUtility
from Products.Five.browser import BrowserView

from collective.geo.geographer.interfaces import IGeoCoder


def get_geocoder():
    return GeoCoderUtility()


class GeoCoderUtility(object):
    """Wrapper class for geopy
    """
    implements(IGeoCoder)

    def retrieve(self, address=None, google_api=None):
        # TODO: fix google_api > secret_key and client_id parameters
        # See https://github.com/geopy/geopy/blob/master/geopy/geocoders/googlev3.py#L31
        self.geocoder = geocoders.GoogleV3()

        if not address:
            raise GQueryError
        return self.geocoder.geocode(address, exactly_one=False)


class GeoCoder(object):

    def __init__(self, context):
        self.context = context

    def retrieve(self, address=None, google_api=None):
        import warnings
        import textwrap
        warnings.warn(textwrap.dedent(
            "IGeoCoder adapter is deprecated"
            " use corresponding utility instead"
        ), DeprecationWarning, 2)
        geocoder = GeoCoderUtility()
        return geocoder.retrieve(address, google_api)


class GeoCoderView(BrowserView):
    """A simple view which provides a json output from geopy query.
    """

    def __init__(self, context, request):
        super(GeoCoderView, self).__init__(context, request)
        self.geocoder = getUtility(IGeoCoder)

    def __call__(self, address=None, google_api=None):
        try:
            locations = self.geocoder.retrieve(address, google_api)
        except GQueryError:
            return 'null'
        return json.dumps([loc for loc in locations])
