/*
 * Decompiled with CFR 0.152.
 */
package unsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import unsign.Utils;

public class Unsign {
    private static void unsign(File file) {
        byte[] byArray = new byte[4096];
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        File file2 = file;
        File file3 = new File(file.getParentFile(), new Date().getTime() + ".tmp");
        try {
            if (!file.renameTo(file3)) {
                try {
                    Utils.transferFile(file, file3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException("Unable to rename " + file);
                }
            }
            zipInputStream = new ZipInputStream(new FileInputStream(file3));
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (string.startsWith("META-INF/")) {
                    System.out.println("Removing: " + string);
                    continue;
                }
                zipOutputStream.putNextEntry(new ZipEntry(string));
                int n = -1;
                while ((n = zipInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                throw new RuntimeException("Unable to sign zip " + file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                Utils.close(zipInputStream);
                Utils.close(zipOutputStream);
                throw throwable;
            }
        }
        Utils.close(zipInputStream);
        Utils.close(zipOutputStream);
        Utils.delete(file3);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            System.out.println("Usage: java -jar unsign.jar input.zip");
            System.exit(0);
        }
        File file = new File(stringArray[0]);
        Unsign.unsign(file);
    }
}

