# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .image_template_distributor import ImageTemplateDistributor


class ImageTemplateSharedImageDistributor(ImageTemplateDistributor):
    """Distribute via Shared Image Gallery.

    All required parameters must be populated in order to send to Azure.

    :param run_output_name: Required. The name to be used for the associated
     RunOutput.
    :type run_output_name: str
    :param artifact_tags: Tags that will be applied to the artifact once it
     has been created/updated by the distributor.
    :type artifact_tags: dict[str, str]
    :param type: Required. Constant filled by server.
    :type type: str
    :param gallery_image_id: Required. Resource Id of the Shared Image Gallery
     image
    :type gallery_image_id: str
    :param replication_regions: Required.
    :type replication_regions: list[str]
    """

    _validation = {
        'run_output_name': {'required': True, 'pattern': r'^[A-Za-z0-9-_]{1,64}$'},
        'type': {'required': True},
        'gallery_image_id': {'required': True},
        'replication_regions': {'required': True},
    }

    _attribute_map = {
        'run_output_name': {'key': 'runOutputName', 'type': 'str'},
        'artifact_tags': {'key': 'artifactTags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
        'gallery_image_id': {'key': 'galleryImageId', 'type': 'str'},
        'replication_regions': {'key': 'replicationRegions', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ImageTemplateSharedImageDistributor, self).__init__(**kwargs)
        self.gallery_image_id = kwargs.get('gallery_image_id', None)
        self.replication_regions = kwargs.get('replication_regions', None)
        self.type = 'SharedImage'
