# -*- coding: utf-8 -*-

import sys
import urllib2
import time
import json
import pyconn.wx.config as cfg


class Token(object):
    def __init__(self, corp_id, corp_secret):
        self.baseurl = cfg.TOKEN_URL.format(corp_id, corp_secret)
        self.expire_time = sys.maxint

    def get_token(self):
        if self.expire_time > time.time():
            request = urllib2.Request(self.baseurl)
            response = urllib2.urlopen(request)
            ret = response.read().strip()
            ret = json.loads(ret)
            if 'errcode' in ret.keys():
                print 'Get Wechat token Error: %s' % (ret['errmsg'])
                sys.exit(1)
            self.expire_time = time.time() + ret['expires_in']
            return ret['access_token']


class Wechat(object):
    def __init__(self, wechat_token):
        self.__token__ = wechat_token

    def send(self, msg):
        url = cfg.SEND_MSG_URL.format(self.__token__)
        payload = {
            "touser": "{0}".format(msg.receivers),
            "msgtype": "text",
            "agentid": msg.agentid,
            "text": {
                "content": "{0}".format(msg.content)

            },
            "safe": "0"
        }
        request = urllib2.Request(url)
        request.add_header('Content-Type', 'application/json')
        ret = {}
        try:
            response = urllib2.urlopen(request, json.dumps(payload, ensure_ascii=False)).read()
            ret = json.JSONDecoder().decode(response)
        except urllib2.URLError, e:
            print 'Send Wechat Msg urllib2.URLError: %s' % (e.reason)
        return ret


class WechatMessage:
    def __init__(self, agentid, receivers, content):
        timestamp = time.strftime('%m-%d %H:%M:%S', time.localtime(time.time()))
        self.agentid = agentid
        self.content = '%s\n[%s]' % (content, timestamp)
        self.receivers = receivers
