#!/usr/bin/env python
# Generated by jaraco.develop 2.20
# https://pypi.python.org/pypi/jaraco.develop

import io
import sys

import setuptools

with io.open('README.txt', encoding='utf-8') as readme:
	long_description = readme.read()

needs_pytest = {'pytest', 'test'}.intersection(sys.argv)
pytest_runner = ['pytest_runner'] if needs_pytest else []
needs_sphinx = {'release', 'build_sphinx', 'upload_docs'}.intersection(sys.argv)
sphinx = ['sphinx'] if needs_sphinx else []

setup_params = dict(
	name='jaraco.video',
	use_scm_version=True,
	author="Jason R. Coombs",
	author_email="jaraco@jaraco.com",
	description="A pure-python framegrabber for Windows",
	long_description=long_description,
	url="https://bitbucket.org/jaraco/jaraco.video",
	packages=setuptools.find_packages(exclude=['tests']),
	include_package_data=True,
	namespace_packages=['jaraco'],
	install_requires=[
		'comtypes',
		'Pillow',
		'jaraco.structures',
	],
	extras_require={
	},
	setup_requires=[
		'setuptools_scm',
	] + pytest_runner + sphinx,
	tests_require=[
		'pytest',
	],
	classifiers=[
		"Development Status :: 5 - Production/Stable",
		"Operating System :: Microsoft :: Windows",
		"Intended Audience :: Developers",
		"License :: OSI Approved :: MIT License",
		"Programming Language :: Python :: 2.7",
		"Programming Language :: Python :: 3",
		"Topic :: Multimedia :: Video :: Capture",
	],
	entry_points={
		'console_scripts': [
			'save-frame = jaraco.video.capture:save_frame',
		],
	},
)
if __name__ == '__main__':
	setuptools.setup(**setup_params)
