/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.receivers.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.log4j.component.spi.ComponentBase;
import org.apache.log4j.receivers.db.ConnectionSource;
import org.apache.log4j.receivers.db.DBHelper;
import org.apache.log4j.receivers.db.dialect.Util;

public abstract class ConnectionSourceSkeleton
extends ComponentBase
implements ConnectionSource {
    private Boolean overriddenSupportsGetGeneratedKeys = null;
    private String user = null;
    private String password = null;
    private int dialectCode = 0;
    private boolean supportsGetGeneratedKeys = false;
    private boolean supportsBatchUpdates = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverConnnectionProperties() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            if (connection == null) {
                this.getLogger().warn("Could not get a conneciton");
                return;
            }
            DatabaseMetaData meta = connection.getMetaData();
            Util util = new Util();
            util.setLoggerRepository(this.repository);
            this.supportsGetGeneratedKeys = this.overriddenSupportsGetGeneratedKeys != null ? this.overriddenSupportsGetGeneratedKeys.booleanValue() : util.supportsGetGeneratedKeys(meta);
            this.supportsBatchUpdates = util.supportsBatchUpdates(meta);
            this.dialectCode = Util.discoverSQLDialect(meta);
        }
        catch (SQLException se) {
            this.getLogger().warn((Object)"Could not discover the dialect to use.", se);
        }
        finally {
            DBHelper.closeConnection(connection);
        }
    }

    public final boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    public final int getSQLDialectCode() {
        return this.dialectCode;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setUser(String username) {
        this.user = username;
    }

    public String getOverriddenSupportsGetGeneratedKeys() {
        return this.overriddenSupportsGetGeneratedKeys != null ? this.overriddenSupportsGetGeneratedKeys.toString() : null;
    }

    public void setOverriddenSupportsGetGeneratedKeys(String overriddenSupportsGetGeneratedKeys) {
        this.overriddenSupportsGetGeneratedKeys = Boolean.valueOf(overriddenSupportsGetGeneratedKeys);
    }

    public final boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }
}

