/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import java.net.URI;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.URIConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.AcceptAllValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class URIParserValidator
extends BaseParserValidator<URI> {
    public static final String URI_TYPE = "URI";
    protected static final String URI_TYPE_REGEXP = "[Uu][Rr][Ii]";

    public URIParserValidator(String model) throws ModelSyntaxException {
        super(model);
        if (!model.matches("^[Uu][Rr][Ii]$")) {
            throw new ModelSyntaxException("URI expression in model does not match [Uu][Rr][Ii]$");
        }
    }

    @Override
    public String getType() {
        return URI_TYPE;
    }

    @Override
    public String getTypeRegexp() {
        return URI_TYPE_REGEXP;
    }

    @Override
    public Class getClassType() {
        return URI.class;
    }

    @Override
    protected Converter<URI> createConverter(String model) throws ModelSyntaxException {
        return new URIConverter();
    }

    @Override
    protected Validator<URI> createValidator(String model, Converter<URI> converter) throws ModelSyntaxException {
        return new AcceptAllValidator<URI>();
    }
}

