/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.ds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.task.dataspaces.RemoteSpace;
import org.ow2.proactive_grid_cloud_portal.common.FileType;
import org.ow2.proactive_grid_cloud_portal.dataspace.dto.ListFile;

public interface IDataSpaceClient {
    public boolean create(IRemoteSource var1) throws NotConnectedException, PermissionException;

    public boolean download(IRemoteSource var1, ILocalDestination var2) throws NotConnectedException, PermissionException;

    public boolean upload(ILocalSource var1, IRemoteDestination var2) throws NotConnectedException, PermissionException;

    public ListFile list(IRemoteSource var1) throws NotConnectedException, PermissionException;

    public boolean delete(IRemoteSource var1) throws NotConnectedException, PermissionException;

    public Map<String, String> metadata(IRemoteSource var1) throws NotConnectedException, PermissionException;

    public RemoteSpace getGlobalSpace();

    public RemoteSpace getUserSpace();

    public static interface IRemoteDestination {
        public Dataspace getDataspace();

        public String getPath();
    }

    public static interface ILocalSource {
        public void writeTo(OutputStream var1) throws IOException;

        public String getEncoding() throws IOException;
    }

    public static interface ILocalDestination {
        public void readFrom(InputStream var1, String var2) throws IOException;
    }

    public static interface IRemoteSource {
        public Dataspace getDataspace();

        public String getPath();

        public List<String> getIncludes();

        public List<String> getExcludes();

        public FileType getType();
    }

    public static enum Dataspace {
        USER("user"),
        GLOBAL("global");

        private String value;

        private Dataspace(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }
    }
}

