# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SecretValueResourceDescription(Model):
    """This type describes a value of a secret resource. The name of this resource
    is the version identifier corresponding to this secret value.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Version identifier of the secret value.
    :type name: str
    :param value: The actual value of the secret.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecretValueResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
