# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PagedSecretValueResourceDescriptionList(Model):
    """The list of values of a secret resource, paged if the number of results
    exceeds the limits of a single message. The next set of results can be
    obtained by executing the same query with the continuation token provided
    in the previous page.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: One page of the list.
    :type items:
     list[~azure.servicefabric.models.SecretValueResourceDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[SecretValueResourceDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedSecretValueResourceDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)
