# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .secret_resource_properties import SecretResourceProperties


class InlinedValueSecretResourceProperties(SecretResourceProperties):
    """Describes the properties of a secret resource whose value is provided
    explicitly as plaintext. The secret resource may have multiple values, each
    being uniquely versioned. The secret value of each version is stored
    encrypted, and delivered as plaintext into the context of applications
    referencing it.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param description: User readable description of the secret.
    :type description: str
    :ivar status: Status of the resource. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the secret.
    :vartype status_details: str
    :param content_type: The type of the content stored in the secret value.
     The value of this property is opaque to Service Fabric. Once set, the
     value of this property cannot be changed.
    :type content_type: str
    """

    _validation = {
        'kind': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InlinedValueSecretResourceProperties, self).__init__(**kwargs)
        self.kind = 'inlinedValue'
