# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .connection_info_py3 import ConnectionInfo


class MiSqlConnectionInfo(ConnectionInfo):
    """Properties required to create a connection to Azure SQL database Managed
    instance.

    All required parameters must be populated in order to send to Azure.

    :param user_name: User name
    :type user_name: str
    :param password: Password credential.
    :type password: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param managed_instance_resource_id: Required. Resource id for Azure SQL
     database Managed instance
    :type managed_instance_resource_id: str
    """

    _validation = {
        'type': {'required': True},
        'managed_instance_resource_id': {'required': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'managed_instance_resource_id': {'key': 'managedInstanceResourceId', 'type': 'str'},
    }

    def __init__(self, *, managed_instance_resource_id: str, user_name: str=None, password: str=None, **kwargs) -> None:
        super(MiSqlConnectionInfo, self).__init__(user_name=user_name, password=password, **kwargs)
        self.managed_instance_resource_id = managed_instance_resource_id
        self.type = 'MiSqlConnectionInfo'
