# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnectToSourceMySqlTaskInput(Model):
    """Input for the task that validates MySQL database connection.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to
     MySQL source
    :type source_connection_info:
     ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :param target_platform: Target Platform for the migration. Possible values
     include: 'SqlServer', 'AzureDbForMySQL'
    :type target_platform: str or
     ~azure.mgmt.datamigration.models.MySqlTargetPlatformType
    :param check_permissions_group: Permission group for validations. Possible
     values include: 'Default', 'MigrationFromSqlServerToAzureDB',
     'MigrationFromSqlServerToAzureMI', 'MigrationFromMySQLToAzureDBForMySQL'
    :type check_permissions_group: str or
     ~azure.mgmt.datamigration.models.ServerLevelPermissionsGroup
    """

    _validation = {
        'source_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'MySqlConnectionInfo'},
        'target_platform': {'key': 'targetPlatform', 'type': 'str'},
        'check_permissions_group': {'key': 'checkPermissionsGroup', 'type': 'ServerLevelPermissionsGroup'},
    }

    def __init__(self, **kwargs):
        super(ConnectToSourceMySqlTaskInput, self).__init__(**kwargs)
        self.source_connection_info = kwargs.get('source_connection_info', None)
        self.target_platform = kwargs.get('target_platform', None)
        self.check_permissions_group = kwargs.get('check_permissions_group', None)
