# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackupSetInfo(Model):
    """Information of backup set.

    :param backup_set_id: Id for the set of backup files
    :type backup_set_id: str
    :param first_lsn: First log sequence number of the backup file
    :type first_lsn: str
    :param last_lsn: Last log sequence number of the backup file
    :type last_lsn: str
    :param last_modified_time: Last modified time of the backup file in share
     location
    :type last_modified_time: datetime
    :param backup_type: Enum of the different backup types. Possible values
     include: 'Database', 'TransactionLog', 'File', 'DifferentialDatabase',
     'DifferentialFile', 'Partial', 'DifferentialPartial'
    :type backup_type: str or ~azure.mgmt.datamigration.models.BackupType
    :param list_of_backup_files: List of files in the backup set
    :type list_of_backup_files:
     list[~azure.mgmt.datamigration.models.BackupFileInfo]
    :param database_name: Name of the database to which the backup set belongs
    :type database_name: str
    :param backup_start_date: Date and time that the backup operation began
    :type backup_start_date: datetime
    :param backup_finished_date: Date and time that the backup operation
     finished
    :type backup_finished_date: datetime
    :param is_backup_restored: Whether the backup set is restored or not
    :type is_backup_restored: bool
    """

    _attribute_map = {
        'backup_set_id': {'key': 'backupSetId', 'type': 'str'},
        'first_lsn': {'key': 'firstLsn', 'type': 'str'},
        'last_lsn': {'key': 'lastLsn', 'type': 'str'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'backup_type': {'key': 'backupType', 'type': 'str'},
        'list_of_backup_files': {'key': 'listOfBackupFiles', 'type': '[BackupFileInfo]'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'backup_start_date': {'key': 'backupStartDate', 'type': 'iso-8601'},
        'backup_finished_date': {'key': 'backupFinishedDate', 'type': 'iso-8601'},
        'is_backup_restored': {'key': 'isBackupRestored', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(BackupSetInfo, self).__init__(**kwargs)
        self.backup_set_id = kwargs.get('backup_set_id', None)
        self.first_lsn = kwargs.get('first_lsn', None)
        self.last_lsn = kwargs.get('last_lsn', None)
        self.last_modified_time = kwargs.get('last_modified_time', None)
        self.backup_type = kwargs.get('backup_type', None)
        self.list_of_backup_files = kwargs.get('list_of_backup_files', None)
        self.database_name = kwargs.get('database_name', None)
        self.backup_start_date = kwargs.get('backup_start_date', None)
        self.backup_finished_date = kwargs.get('backup_finished_date', None)
        self.is_backup_restored = kwargs.get('is_backup_restored', None)
