# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackupFileInfo(Model):
    """Information of the backup file.

    :param file_location: Location of the backup file in shared folder
    :type file_location: str
    :param family_sequence_number: Sequence number of the backup file in the
     backup set
    :type family_sequence_number: int
    :param status: Status of the backup file during migration. Possible values
     include: 'Arrived', 'Queued', 'Uploading', 'Uploaded', 'Restoring',
     'Restored', 'Cancelled'
    :type status: str or ~azure.mgmt.datamigration.models.BackupFileStatus
    """

    _attribute_map = {
        'file_location': {'key': 'fileLocation', 'type': 'str'},
        'family_sequence_number': {'key': 'familySequenceNumber', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, file_location: str=None, family_sequence_number: int=None, status=None, **kwargs) -> None:
        super(BackupFileInfo, self).__init__(**kwargs)
        self.file_location = file_location
        self.family_sequence_number = family_sequence_number
        self.status = status
