# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SslConfiguration(Model):
    """SSL configuration. If configured data-plane calls to user services will be
    exposed over SSL only.

    :param status: SSL status. Allowed values are Enabled and Disabled.
     Possible values include: 'Enabled', 'Disabled'. Default value: "Enabled" .
    :type status: str or ~azure.mgmt.machinelearningcompute.models.Status
    :param cert: The SSL cert data in PEM format encoded as base64 string
    :type cert: str
    :param key: The SSL key data in PEM format encoded as base64 string. This
     is not returned in response of GET/PUT on the resource. To see this please
     call listKeys API.
    :type key: str
    :param cname: The CName of the certificate.
    :type cname: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'cert': {'key': 'cert', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'cname': {'key': 'cname', 'type': 'str'},
    }

    def __init__(self, status="Enabled", cert=None, key=None, cname=None):
        self.status = status
        self.cert = cert
        self.key = key
        self.cname = cname
