# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServicePrincipalProperties(Model):
    """The Azure service principal used by Kubernetes for configuring load
    balancers.

    :param client_id: The service principal client ID
    :type client_id: str
    :param secret: The service principal secret. This is not returned in
     response of GET/PUT on the resource. To see this please call listKeys.
    :type secret: str
    """

    _validation = {
        'client_id': {'required': True},
        'secret': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(self, client_id, secret):
        self.client_id = client_id
        self.secret = secret
