# Copyright 2010 Boris Figovsky <borfig@gmail.com>
#
# This file is part of pybfc.

# pybfc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# pybfc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with pybfc.  If not, see <http://www.gnu.org/licenses/>.
"""
A simple proxy to access a dict via attributes as keys

>>> d = {}
>>> a = AttrDict(d)
>>> a.foo = '5'
>>> d
{'foo': '5'}
>>> d['a'] = 10
>>> a.a
10
>>> del a.a
>>> d
{'foo': '5'}
>>> a
AttrDict({'foo': '5'})

"""

class AttrDict(object):
    __slots__ = ['__internal_dict']
    def __init__(self, internal_dict):
        object.__setattr__(self, '_AttrDict__internal_dict', internal_dict)

    def __getattr__(self, attr):
        return self.__internal_dict[attr]

    def __setattr__(self, attr, value):
        self.__internal_dict[attr] = value

    def __delattr__(self, attr):
        del self.__internal_dict[attr]

    def __repr__(self):
        return "%s(%r)" % (self.__class__.__name__, self.__internal_dict)
