# coding=utf-8
from __future__ import absolute_import
from django.shortcuts import _get_queryset


def get_object_or_None(klass, *args, **kwargs):
    """
    Uses get() to return an object or None if the object does not exist.
    klass may be a Model, Manager, or QuerySet object.
    All other passed arguments and keyword arguments are used in the get() query.
    """
    queryset = _get_queryset(klass)
    try:
        return queryset.get(*args, **kwargs)
    except queryset.model.DoesNotExist:
        return None


def chunked_qs(qs, chunksize=100):
    total = qs.count()
    for start in xrange(0, total, chunksize):
        for t in qs[start:min(start + chunksize, total)]:
            yield t


def each_fields(for_fields, fields):
    """
    select_related(
        'field__related_field1__text1', 'field__related_field1__text2',
        'field__related_field2__text1', 'field__related_field2__text2',
    )
    each_fields(['field__related_field1', 'field__related_field2'], ['text1', 'text2'])
    """
    r = set()
    for ff in for_fields:
        for f in fields:
            r.add(ff + '__' + f)
    return r
