﻿# coding=utf-8
#This file was originally generated by PyScripter's unitest wizard

import unittest
import sys

sys.path.append("..\\")
import pyinference.fuzzy.domain


class TestRationalRange(unittest.TestCase):

    def test_boundaries_low_acc(self):
        dom = pyinference.fuzzy.domain.RationalRange(0, 1, 10)
        arr = [x for x in dom]
        self.assertAlmostEqual(0.0, arr[0])
        self.assertAlmostEqual(1.0, arr[-1])

    def test_boundaries_high_acc(self):
        dom = pyinference.fuzzy.domain.RationalRange(0, 1, 10000)
        arr = [x for x in dom]
        self.assertAlmostEqual(0.0, arr[0])
        self.assertAlmostEqual(1.0, arr[-1])

    def test_boundaries_arbitrary(self):
        dom = pyinference.fuzzy.domain.RationalRange(-0.92, 152.6, 10000)
        arr = [x for x in dom]
        self.assertAlmostEqual(-0.92, arr[0])
        self.assertAlmostEqual(152.6, arr[-1])

    def test_inner_stability(self):
        dom = pyinference.fuzzy.domain.RationalRange(-0.92, 152.6, 258)
        arr = [x for x in dom]
        self.assertAlmostEqual(25.856744186, arr[45])

    def test_singleton_inner(self):
        dom = pyinference.fuzzy.domain.RationalRange(-0.92, -0.92, 258)
        arr = [x for x in dom]
        self.assertEqual(-0.92, arr[45])

    def test_card_normal(self):
        dom = pyinference.fuzzy.domain.RationalRange(-0.92, 152.6, 258)
        self.assertEqual(153, len(dom))

    def test_card_singleton(self):
        dom = pyinference.fuzzy.domain.RationalRange(-0.92, -0.92, 258)
        self.assertEqual(0.0, len(dom))

    def test_contains_normal(self):
        dom = pyinference.fuzzy.domain.RationalRange(-0.92, 152.6, 258)
        self.assertIn(0.7, dom)
        self.assertIn(-0.92, dom)
        self.assertIn(152.6, dom)

    def test_not_contains_normal(self):
        dom = pyinference.fuzzy.domain.RationalRange(-0.92, 152.6, 258)
        self.assertNotIn(-1.0, dom)
        self.assertNotIn(153.0, dom)

    def test_contains_singleton(self):
        dom = pyinference.fuzzy.domain.RationalRange(-0.92, -0.92, 258)
        self.assertIn(-0.92, dom)
        self.assertNotIn(153.0, dom)


class TestIntegerRange(unittest.TestCase):

    def test_boundaries_low_acc(self):
        dom = pyinference.fuzzy.domain.IntegerRange(0, 1)
        arr = [x for x in dom]
        self.assertAlmostEqual(0.0, arr[0])
        self.assertAlmostEqual(1.0, arr[-1])

    def test_boundaries_arbitrary(self):
        dom = pyinference.fuzzy.domain.IntegerRange(-0.92, 152.6)
        arr = [x for x in dom]
        self.assertAlmostEqual(0, arr[0])
        self.assertAlmostEqual(152, arr[-1])

    def test_inner_stability(self):
        dom = pyinference.fuzzy.domain.IntegerRange(0, 152)
        arr = [x for x in dom]
        self.assertAlmostEqual(45, arr[45])

    def test_singleton_inner(self):
        dom = pyinference.fuzzy.domain.IntegerRange(-0.92, -0.92)
        arr = [x for x in dom]
        self.assertEqual(0, arr[0])

    def test_card_normal(self):
        dom = pyinference.fuzzy.domain.IntegerRange(-0.92, 152.6)
        self.assertEqual(152, len(dom))

    def test_card_singleton(self):
        dom = pyinference.fuzzy.domain.IntegerRange(-0.92, -0.92)
        self.assertEqual(0.0, len(dom))

    def test_contains_normal(self):
        dom = pyinference.fuzzy.domain.IntegerRange(-0.92, 152.6)
        self.assertIn(0, dom)
        self.assertIn(25, dom)
        self.assertIn(152, dom)

    def test_not_contains_normal(self):
        dom = pyinference.fuzzy.domain.IntegerRange(-0.92, 152.6)
        self.assertNotIn(-1.0, dom)
        self.assertNotIn(152.6, dom)

    def test_contains_singleton(self):
        dom = pyinference.fuzzy.domain.IntegerRange(-0.92, -0.92)
        self.assertIn(0, dom)
        self.assertNotIn(-0.92, dom)

if __name__ == '__main__':
    unittest.main()
