/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Sink;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageProducer;

public class VideoSink
extends Sink {
    private Component component;
    private boolean keepAspect = true;
    private Frame frame;
    private int width;
    private int height;
    private int aspect_x;
    private int aspect_y;

    protected boolean setCapsFunc(Caps caps) {
        String mime = caps.getMime();
        if (!mime.equals("video/raw")) {
            return false;
        }
        this.width = caps.getFieldInt("width", -1);
        this.height = caps.getFieldInt("height", -1);
        if (this.width == -1 || this.height == -1) {
            return false;
        }
        this.aspect_x = caps.getFieldInt("aspect_x", 1);
        this.aspect_y = caps.getFieldInt("aspect_y", 1);
        if (this.aspect_y > this.aspect_x) {
            this.height = this.height * this.aspect_y / this.aspect_x;
        } else {
            this.width = this.width * this.aspect_x / this.aspect_y;
        }
        this.component.setVisible(true);
        return true;
    }

    protected int preroll(Buffer buf) {
        return this.render(buf);
    }

    protected int render(Buffer buf) {
        int y;
        int x;
        int h;
        int w;
        Image image;
        if (buf.object instanceof ImageProducer) {
            image = this.component.createImage((ImageProducer)buf.object);
        } else if (buf.object instanceof Image) {
            image = (Image)buf.object;
        } else {
            System.out.println(this + ": unknown buffer received " + buf);
            return -5;
        }
        if (!this.component.isVisible()) {
            return -4;
        }
        Dimension d = this.component.getSize();
        Graphics graphics = this.component.getGraphics();
        if (this.keepAspect) {
            w = d.width;
            h = d.height;
            x = 0;
            y = 0;
        } else {
            w = d.width;
            h = d.height;
            x = 0;
            y = 0;
        }
        graphics.drawImage(image, x, y, w, h, null);
        return 0;
    }

    public String getFactoryName() {
        return "videosink";
    }

    public boolean setProperty(String name, Object value) {
        if (name.equals("component")) {
            this.component = (Component)value;
        } else if (name.equals("keep-aspect")) {
            this.keepAspect = String.valueOf(value).equals("true");
        } else {
            return false;
        }
        return true;
    }

    public Object getProperty(String name) {
        if (name.equals("component")) {
            return this.component;
        }
        if (name.equals("keep-aspect")) {
            return this.keepAspect ? "true" : "false";
        }
        return null;
    }

    protected int changeState(int transition) {
        if (this.currentState == 1 && this.pendingState == 2 && this.component == null) {
            this.frame = new Frame();
            this.component = this.frame;
        }
        return super.changeState(transition);
    }
}

