/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Clock;
import com.fluendo.jst.ClockProvider;
import com.fluendo.jst.Event;
import com.fluendo.jst.Sink;
import com.fluendo.jst.SystemClock;
import com.fluendo.utils.Debug;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AudioSink
extends Sink
implements ClockProvider {
    protected RingBuffer ringBuffer;
    private AudioClock audioClock;

    public Clock provideClock() {
        return this.audioClock;
    }

    protected int doSync(long time) {
        return 0;
    }

    protected boolean doEvent(Event event) {
        switch (event.getType()) {
            case 1: {
                this.ringBuffer.setFlushing(true);
                break;
            }
            case 2: {
                this.ringBuffer.setFlushing(false);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    protected int render(Buffer buf) {
        long time;
        if (buf.isFlagSet(1)) {
            this.ringBuffer.nextSample = -1;
        }
        if ((time = buf.timestamp - this.segStart) < 0L) {
            return 0;
        }
        long sample = (time += this.baseTime) * (long)this.ringBuffer.rate / 1000000L;
        this.ringBuffer.commit(buf.data, sample, buf.offset, buf.length);
        return 0;
    }

    protected boolean setCapsFunc(Caps caps) {
        this.ringBuffer.release();
        boolean res = this.ringBuffer.acquire(caps);
        return res;
    }

    protected int changeState(int transition) {
        int result;
        block6: {
            switch (transition) {
                case 18: {
                    this.ringBuffer = this.createRingBuffer();
                    this.ringBuffer.setFlushing(false);
                    break;
                }
                case 35: {
                    this.ringBuffer.setAutoStart(true);
                    break;
                }
                case 50: {
                    this.reset();
                    this.ringBuffer.setAutoStart(false);
                    this.ringBuffer.pause();
                    break;
                }
                case 33: {
                    this.ringBuffer.setFlushing(true);
                    break;
                }
            }
            result = super.changeState(transition);
            if (transition != 33) break block6;
            this.ringBuffer.release();
        }
        return result;
    }

    protected abstract RingBuffer createRingBuffer();

    protected abstract boolean open(RingBuffer var1);

    protected abstract boolean close(RingBuffer var1);

    protected abstract int write(byte[] var1, int var2, int var3);

    protected abstract long delay();

    protected abstract void reset();

    private final /* synthetic */ void this() {
        this.ringBuffer = null;
        this.audioClock = new AudioClock();
    }

    public AudioSink() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class RingBuffer
    implements Runnable {
        private static final int STOP = 0;
        private static final int PAUSE = 1;
        private static final int PLAY = 2;
        protected byte[] buffer;
        private int state;
        private Thread thread;
        private long nextSample;
        private boolean flushing;
        private boolean autoStart;
        private boolean opened;
        public int bps;
        public int sps;
        public byte[] emptySeg;
        public long playSeg;
        public int segTotal;
        public int segSize;
        public int rate;
        public int channels;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            boolean running = true;
            while (running) {
                RingBuffer ringBuffer;
                block12: {
                    ringBuffer = this;
                    // MONITORENTER : ringBuffer
                    {
                        if (this.state == 2) break block12;
                        while (this.state == 1) {
                            try {
                                this.notifyAll();
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                        }
                        if (this.state != 0) break block12;
                        running = false;
                        // MONITOREXIT : ringBuffer
                        return;
                    }
                }
                int segNum = (int)(this.playSeg % (long)this.segTotal);
                int index = segNum * this.segSize;
                int toWrite = this.segSize;
                while (toWrite > 0) {
                    int ret = AudioSink.this.write(this.buffer, index, this.segSize);
                    if (ret == -1) break;
                    toWrite -= ret;
                }
                this.clear(segNum);
                ringBuffer = this;
                // MONITORENTER : ringBuffer
                ++this.playSeg;
                this.notifyAll();
                // MONITOREXIT : ringBuffer
            }
        }

        public synchronized void setFlushing(boolean flushing) {
            this.flushing = flushing;
            this.clearAll();
            if (flushing) {
                this.pause();
            }
        }

        protected void startWriteThread() {
            this.thread = new Thread(this);
            this.thread.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized boolean acquire(Caps caps) {
            if (this.thread != null) {
                return false;
            }
            if (this.opened) {
                return false;
            }
            String mime = caps.getMime();
            if (!mime.equals("audio/raw")) {
                return false;
            }
            this.rate = caps.getFieldInt("rate", 44100);
            this.channels = caps.getFieldInt("channels", 1);
            this.bps = 2 * this.channels;
            boolean res = AudioSink.this.open(this);
            if (!res) {
                return res;
            }
            this.opened = true;
            Debug.log(3, "audio: segSize: " + this.segSize);
            Debug.log(3, "audio: segTotal: " + this.segTotal);
            ++this.segTotal;
            this.buffer = new byte[this.segSize * this.segTotal];
            this.sps = this.segSize / this.bps;
            this.state = 1;
            this.nextSample = 0L;
            this.playSeg = 0L;
            this.startWriteThread();
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean release() {
            this.stop();
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                if (this.opened && !AudioSink.this.close(this)) {
                    return false;
                }
                this.opened = false;
                return true;
            }
        }

        private final synchronized boolean waitSegment() {
            if (this.flushing) {
                return false;
            }
            if (this.state != 2 && this.autoStart) {
                this.play();
            }
            try {
                if (this.state != 2) {
                    return false;
                }
                this.wait();
                if (this.flushing) {
                    return false;
                }
                if (this.state != 2) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public int commit(byte[] data, long sample, int offset, int len) {
            if (sample == (long)-1) {
                sample = this.nextSample;
            }
            if (sample < 0L) {
                return len;
            }
            if (this.nextSample != (long)-1) {
                if (Math.abs(sample - this.nextSample) < (long)(this.rate / 10)) {
                    sample = this.nextSample;
                } else {
                    System.out.println("discont: found " + sample + " expected " + this.nextSample);
                }
            }
            int idx = 0;
            this.nextSample = sample + (long)(len / this.bps);
            while (len > 0) {
                int writeOff;
                long writeSeg;
                long diff;
                int writeLen;
                block12: {
                    writeLen = 0;
                    diff = -1;
                    writeSeg = sample / (long)this.sps;
                    writeOff = (int)(sample % (long)this.sps * (long)this.bps);
                    do {
                        block11: {
                            RingBuffer ringBuffer = this;
                            // MONITORENTER : ringBuffer
                            {
                                diff = writeSeg - this.playSeg;
                                // MONITOREXIT : ringBuffer
                                if (diff >= 0L) break block11;
                            }
                            writeLen = Math.min(this.segSize, len);
                            break block12;
                        }
                        if (diff < (long)this.segTotal) break block12;
                    } while (this.waitSegment());
                    return -1;
                }
                if (diff >= 0L) {
                    int writeSegRel = (int)(writeSeg % (long)this.segTotal);
                    writeLen = Math.min(this.segSize - writeOff, len);
                    System.arraycopy(data, idx, this.buffer, writeSegRel * this.segSize + writeOff, writeLen);
                }
                len -= writeLen;
                idx += writeLen;
                sample += (long)(writeLen / this.bps);
            }
            return len;
        }

        public synchronized long samplesPlayed() {
            long delay = AudioSink.this.delay();
            long seg = Math.max(0L, this.playSeg - 1L);
            long samples = seg * (long)this.sps;
            samples = samples >= delay ? (samples -= delay) : 0L;
            return samples;
        }

        public synchronized void clear(long segNum) {
            int index = (int)(segNum % (long)this.segTotal) * this.segSize;
            System.arraycopy(this.emptySeg, 0, this.buffer, index, this.segSize);
        }

        public synchronized void clearAll() {
            int i = 0;
            while (i < this.segTotal) {
                this.clear(i);
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void setSample(long sample) {
            if (sample == (long)-1) {
                sample = 0L;
            }
            this.playSeg = sample / (long)this.sps;
            this.nextSample = sample;
            this.clearAll();
            AudioClock audioClock = AudioSink.this.audioClock;
            synchronized (audioClock) {
                AudioSink.this.audioClock.notifyAll();
                return;
            }
        }

        public synchronized void setAutoStart(boolean start) {
            this.autoStart = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean play() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                if (this.flushing) {
                    return false;
                }
                this.state = 2;
                this.notifyAll();
                AudioSink.this.audioClock.setStarted(true);
                Debug.log(4, this + " playing");
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean pause() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                this.state = 1;
                Debug.log(4, this + " pausing");
                this.notifyAll();
                if (this.thread != null) {
                    try {
                        Debug.log(4, this + " waiting for pause");
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            AudioSink.this.audioClock.setStarted(false);
            Debug.log(4, this + " paused");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean stop() {
            block5: {
                RingBuffer ringBuffer = this;
                synchronized (ringBuffer) {
                    this.state = 0;
                    Debug.log(4, this + " stopping");
                    this.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (this.thread == null) break block5;
                }
                try {
                    Debug.log(4, this + " joining thread");
                    this.thread.join();
                    this.thread = null;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            AudioSink.this.audioClock.setStarted(false);
            Debug.log(4, this + " stopped");
            return true;
        }

        public synchronized int getState() {
            return this.state;
        }

        static /* synthetic */ long access$0(RingBuffer ringBuffer) {
            return ringBuffer.nextSample;
        }

        protected RingBuffer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AudioClock
    extends SystemClock {
        private long lastTime;
        private long diff;
        private boolean started;

        public synchronized void setStarted(boolean s) {
            this.started = s;
            if (this.started) {
                this.diff = -1;
                this.lastTime = -1;
            }
        }

        protected synchronized long getInternalTime() {
            long result;
            if (AudioSink.this.ringBuffer == null || AudioSink.this.ringBuffer.rate == 0) {
                return 0L;
            }
            long samples = AudioSink.this.ringBuffer.samplesPlayed();
            long timePos = samples * 1000000L / (long)AudioSink.this.ringBuffer.rate;
            if (this.started) {
                long now = System.currentTimeMillis() * 1000L;
                if (this.diff == (long)-1) {
                    this.diff = now;
                }
                if (timePos != this.lastTime) {
                    this.lastTime = timePos;
                    this.diff = now - timePos;
                }
                result = now - this.diff;
            } else {
                result = timePos;
            }
            return result;
        }

        private final /* synthetic */ void this() {
            this.lastTime = -1;
            this.diff = -1;
            this.started = false;
        }

        private AudioClock() {
            this.this();
        }
    }
}

